/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class Pendule
	{
	
	public static void main(String[] arg)
	{
	// Rsolution des problmes du Pendule amorti avec 15 conditions initiales diffrentes
	Problem pb = new Problem(2);
	RK ts = new RK();
	
	DVect cd = new DVect(2);
	
	ts.setNstep(1000);
	ts.set(0,100);
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,x.get(1));
				y.set(1,-Math.sin(x.get(0))-0.1*x.get(1));
				return y;
				}
			}
		);

	pb.setTS(ts);
	
	// on rsoud le systme du Pendule avec les 15 conditions initiales diffrentes 
	double[][][] sol = new double[15][3][1000];
	int i;
	for (i=0;i<15;i++)
		{
		cd.set(0,(-7+i>0 ? 1 : -1)*(-Math.PI*7));
		cd.set(1,-7+i);
		pb.setInit(cd);
		pb.solve();
		sol[i]=pb.toArray();
		}
	// A chaque fois, la solution du problme i est stocke dans la variable sol[i]
	
	
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D();
	jf.setTitle("Systme du pendule amorti - Opale-ODE 0.1");
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-20,20,-8,8);
	jf.getPack2D().add(repere,"repere");
	GData2D[] gsol = new GData2D[15];
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	
	//affichage des 15 solutions
	for (i=0;i<15;i++)
		{
		gsol[i] = new GData2D(repere);
		gsol[i].set(1000,sol[i][1],sol[i][2]);
		jf.getPack2D().add(gsol[i],"sol"+i);
		}
	jf.show();
	
	
	
	}

}
