/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;
import opale.m2d.marktype.*;
import opale.tools.*;
import java.io.*;

/**
* This class contains default graphical style for the object : line style, mark type etc... For the moment, only the marktype.
* @author O.C.
* @since Opale-2d 0.18
*/
public class DefaultGraphicalOptions extends InfoObject implements Cloneable
{
//membres privs
private MarkType markType;

//les constructeurs publiques
/**
* Default constructor : stylePoint = 0; typeGraph = 0, sizePoint = 5;
*/
public DefaultGraphicalOptions()
	{
	super();
	markType = new ClassicPoint();
	}

/**
* Copy constructor
* @param DefaultGraphicalOptions inf, object to be copied
*/
public DefaultGraphicalOptions(DefaultGraphicalOptions inf)
	{
	super(inf);
	markType = (MarkType) inf.markType.clone();
	}


//methodes d'accs, publiques
/**
* Clones this object.
* @return Object a clone object.
* @exception  OutOfMemoryError if not anough memory.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
	{
	DefaultGraphicalOptions clo = (DefaultGraphicalOptions) super.clone();
	clo.markType = (MarkType) markType.clone();
	return (DefaultGraphicalOptions) super.clone();
	}
	catch(InternalError e)
	{
	throw e;
	}
	}
	
public final void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	f.print("MARK_TYPE "+p.getUserName(markType.getClass().getName())+" ");
	markType.write(f,p);
	super.writeMore(f,p);
	}	
	
public final int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
{
if ( word.equals("MARK_TYPE"))
		{
		String sval="";
		try
		{
		int type;
		sval = f.next();
		if (p.getNameObject(sval)== null) throw new InvalidFormatException("Unknown type "+sval+" !!!");
		markType = (MarkType)  Class.forName(p.getNameObject(sval)).newInstance();
		markType.read(f,p);
		if (Debug.On) Debug.print("MarkType = ",markType.getClass().getName());
		if (Debug.On) Debug.print("MarkType size = ",markType.getMarksize());
		}
		catch(ClassNotFoundException exc)
		{
		throw new InvalidFormatException("Error reading an object of type "+sval+" : the class does not exist.");
		}
		catch(IllegalAccessException exc)
		{
		throw new InvalidFormatException("Error reading an object of type "+sval+" : access to the class not possible.");
		}
		catch(InstantiationException exc)
		{
		throw new InvalidFormatException("Error reading an object of type "+sval+" : class not instantiable.");
		}	
		return 0;
		}		
else return super.readKeyWord(word,f,p);	

}

/**
* Sets the mark type of the points.
*/	
public void setMarktype(MarkType mt)
	{
	markType = mt;
	}	
	
	
/**
* Gets the mark type of the points.
*/	
public MarkType getMarktype()
	{
	return markType ;
	}	
	
	
	
}
