/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;

/**
* This class represents 2d-axis of an instance of a <code>CoordSystem</code>. It implements <code>GObject2D</code>.
* @author OC
* @since Opale-2d 0.1
*/
public class GAxis2D implements GObject2D,Cloneable
{
//membres privs
private InfoAxis info; //Info sur l'axe
private CoordSystem cs;
private boolean affscale,afflabel;
private String xlabel, ylabel; // les labels sur les axes
/**
* Simple constructor to define axis for a specified coordinate system.
* @param CoordSystem cs, a coordinate system.
*/
public GAxis2D(CoordSystem cs)
	{
	this.cs = cs;
	info = new InfoAxis();
	affscale = true;
	afflabel = true;
	xlabel = "X";
	ylabel = "Y";
	}

//definition des methodes de l'interface ObjetGraphique2D

public void draw(Pen2D crayon)
	{
	if ( info.isVisible())
	{
		double tmp=cs.getXmin();
		double tick;
	
		crayon.drawLine(cs.getXmin(),0,cs.getXmax(),0);
		crayon.drawLine(0,cs.getYmin(),0,cs.getYmax());
	
		if (afflabel)
			{
			crayon.drawString(xlabel,cs.getXmax(),0,-10,20);
			crayon.drawString(ylabel,0,cs.getYmax(),15,10);
			}
		
		tick = info.getXtickMax();
		if ( (tick = info.getXtickMax()) > 0)
			while (tmp <= cs.getXmax())
			{
			crayon.drawYtick(tmp,0,5);
			if ( affscale) crayon.drawString(Double.toString(tmp),tmp,0,-10,15);
			tmp+=tick;
			}

		tmp = cs.getXmin();
		if ( (tick = info.getXtickMin()) > 0)
			while (tmp <= cs.getXmax())
			{
			crayon.drawYtick(tmp,0,3);
			tmp+=tick;
			}

		tmp =  cs.getYmin();
		if ( (tick = info.getYtickMax()) > 0)
			while (tmp <= cs.getYmax())
				{
				crayon.drawXtick(0,tmp,5);
				if ( affscale) crayon.drawString(Double.toString(tmp),0,tmp,10,5);
				tmp+=tick;
				}
		tmp =  cs.getYmin();
		tick = info.getYtickMin();
		if ( (tick = info.getYtickMin()) > 0)
			while (tmp <= cs.getYmax())
			{
			crayon.drawXtick(0,tmp,3);
			tmp+=tick;
			}
		}
	
	}
	
/**
* Sets the flag to draw scale on axis.
* @param boolean, true = scale drawing, false = no scale drawing.
* @since Opale-2d 0.11
*/
public void drawScale(boolean b)
	{
	affscale = b;
	}

/**
* Gets the flag of indicating if the  scale must be printed on the axis
* @return boolean, true = scale must be printed, otherwise false.
* @since Opale-2d 0.11
* @depracated @see getScaleVisibility
*/
public boolean printScale()
	{
	return affscale;
	}

/**
* Gets the flag of indicating if the  scale must be printed on the axis
* @return boolean, true = scale must be printed, otherwise false.
* @since Opale-2d 0.11
*/
public boolean getScaleVisibility()
	{
	return affscale;
	}
		
/**
* Sets the flag to draw the axis label.
* @param boolean
* @since Opale-2d 0.11
*/
public void drawLabel(boolean b)
	{
	afflabel = b;
	}
/**
* Sets the label on X-axis.
* @param String, a label.
* @since Opale-2d 0.11
*/
public void setXLabel(String lab)
	{
	xlabel = lab;
	}
/**
* Sets the label on Y-axis.
* @param String, a label.
* @since Opale-2d 0.11
*/
public void setYLabel(String lab)
	{
	ylabel = lab;
	}
		


public InfoObject getInfo()
	{
	return info;
	}

public String toString()
	{
	String s="Axes 2D";
	return s;
	}
/**
* Clones this object.
* @return Object a clone object.
* @exception  OutOfMemoryError if not enough memory.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
		{
		GAxis2D ax = (GAxis2D) super.clone();
		ax.info = (InfoAxis) info.clone();
		return ax;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
	    throw new InternalError();
		}
    }
public double x(double t) { return 0; }
public double y(double t) {  return 0; }


}