/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;

/**
* This interface must be implemented by the graphical 2d objects. A subclass implementing this interface must define th method <code>draw(Pen2D)</code> to specify how to draw the current 2d object with a Pen2D 
* @author O.C.
* @since Opale-2d 0.1
*/

public interface GObject2D extends Cloneable
{

/**
* Surcharge de toString()
*/
public String toString();



/**
* Methode indiquant la procedure de dessin des objets de la classe
* @param Pen2D crayon, le crayon pour dessiner en 2D dans un repere2D
*/
public void draw(Pen2D crayon);

/**
* Renvoie les infos de l'instance
* @return InfoObjet, info sur l'objet
*/
public InfoObject getInfo();

public Object clone();


/**
* Dfinit une paramtrisation de l'objet afin de pouvoir le parcourir sur un graphique
* @since Opale-2d 0.18
*/
public double x(double t);
public double y(double t);



}



