/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;

/**
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import opale.swools.*;
import opale.m2d.*;




public class AffineTransform2DEditor extends JFrame 
{
private AffineTransform2D afft;
private   JButton okButton = new JButton();
private   JButton appButton = new JButton();
private   JButton closeButton = new JButton();

private   JComboBox setButton = new JComboBox();
private   JComboBox concatenateButton = new JComboBox();

private   BorderLayout layoutFond = new BorderLayout();
private   BorderLayout layoutPanneaufond = new BorderLayout();
private   GridLayout layoutOption = new GridLayout(3,1);
private   JPanel panneauFond = new JPanel();
private   JPanel panneauBouton = new JPanel();
private   JPanel panneauOption = new JPanel();
private   JPanel panneauMatrix = new JPanel();
//private JTable matrix = new JTable(3,3);
private JPanel matrix = new JPanel(new GridLayout(3,3));
private MathExprTextField m00 = new MathExprTextField(15);
private MathExprTextField m01 = new MathExprTextField(15);
private MathExprTextField m02 = new MathExprTextField(15);
private MathExprTextField m10 = new MathExprTextField(15);
private MathExprTextField m11 = new MathExprTextField(15);
private MathExprTextField m12 = new MathExprTextField(15);
private JTextField m20 = new JTextField("0",15);
private JTextField m21 = new JTextField("0",15);
private JTextField m22 = new JTextField("1",15);

public AffineTransform2DEditor(AffineTransform2D at)
{
super();
if (at == null)
	at = new AffineTransform2D();
afft = at;
  try {
    oInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }
}

private void oInit() throws Exception {
  this.setSize(new Dimension(750, 150));
  setResizable(true);
  setTitle("Affine Transform 2D Editor");
  this.getContentPane().setLayout(layoutFond);
  panneauFond.setLayout(layoutPanneaufond);
  panneauOption.setLayout(layoutOption);
  

// Les boutons ok, apply & close
  okButton.setText("Ok");
  okButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      okButton_actionPerformed(e);
    }
  });
  appButton.setText("Apply");
  appButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      appButton_actionPerformed(e);
    }
  });
  closeButton.setText("Close");
  closeButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      closeButton_actionPerformed(e);
    }
  });
  
  setButton.addItem("Set to identity");
  setButton.addItem("Set to translation");
  setButton.addItem("Set to rotation");
  setButton.addItem("Set to scaling");
  concatenateButton.addItem("Translate");
  concatenateButton.addItem("Rotate");
  concatenateButton.addItem("Scale");

  
  setButton.setEditable(false);
  concatenateButton.setEditable(false);

  Delegue delegue = new Delegue(this);
  
  setButton.addActionListener(delegue);
  concatenateButton.addActionListener(delegue);


  this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
  this.getContentPane().add(panneauFond, BorderLayout.CENTER);
  panneauMatrix.add(matrix);
  matrix.add(m00);
  matrix.add(m01);
  matrix.add(m02);
  matrix.add(m10);
  matrix.add(m11);
  matrix.add(m12);
  matrix.add(m20);
  matrix.add(m21);
  matrix.add(m22);
  m20.setEditable(false);
  m21.setEditable(false);
  m22.setEditable(false);

  panneauFond.add(panneauMatrix, BorderLayout.CENTER);
  panneauFond.add(panneauBouton, BorderLayout.SOUTH);
  panneauFond.add(panneauOption, BorderLayout.EAST);

  panneauBouton.add(okButton, null);
  panneauBouton.add(appButton, null);
  panneauBouton.add(closeButton, null);


  JPanel panneauGeneric = new JPanel();
  panneauGeneric.add(setButton);
  panneauOption.add(panneauGeneric, null);

  panneauGeneric = new JPanel();
  panneauGeneric.add(concatenateButton);
  panneauOption.add(panneauGeneric, null);

  updateField();

}

  void updateField()
  	{
	m00.setText(""+afft.getScaleX());
	m11.setText(""+afft.getScaleY());
	m01.setText(""+afft.getShearX());
	m10.setText(""+afft.getShearY());
	m02.setText(""+afft.getTranslateX());
	m12.setText(""+afft.getTranslateY());
	}

  void okButton_actionPerformed(ActionEvent e) {
  dispose();
  }

  void appButton_actionPerformed(ActionEvent e) {
  }

  void closeButton_actionPerformed(ActionEvent e) {
 dispose();

  }

class Delegue implements ActionListener
{
private AffineTransform2DEditor ed;
Delegue(AffineTransform2DEditor ed)
{
this.ed = ed;
}

public void actionPerformed(ActionEvent evt)
	{
//	System.out.println(evt.getSource());
	if (evt.getSource() == setButton)
		{
		int selection = setButton.getSelectedIndex();
		switch(selection)
			{
			case 0:
			m00.setText("1.");
			m11.setText("1.");
			m01.setText("0.");
			m10.setText("0.");
			m02.setText("0.");
			m12.setText("0.");
			break;
			case 1:
			TranslationTransformEditor edt = new TranslationTransformEditor(ed,true,afft);
			edt.show();
			break;
			case 2:
			RotationTransformEditor edr = new RotationTransformEditor(ed,true,afft);
			edr.show();
			break;
			case 3:
			ScalingTransformEditor eds = new ScalingTransformEditor(ed,true,afft);
			eds.show();
			break;
			}
		}
	else if (evt.getSource() == concatenateButton)
		{
		int selection = concatenateButton.getSelectedIndex();
		switch(selection)
			{
			case 0:
			TranslationTransformEditor edt = new TranslationTransformEditor(ed,false,afft);
			edt.show();
			break;
			case 1:
			RotationTransformEditor edr = new RotationTransformEditor(ed,false,afft);
			edr.show();
			break;
			case 2:
			ScalingTransformEditor eds = new ScalingTransformEditor(ed,false,afft);
			eds.show();
			break;
			}
		}
	}

}


public static void main(String[] arg)
{
AffineTransform2DEditor ed = new AffineTransform2DEditor(null);
ed.show();
}

}
