/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import opale.m2d.*;
import opale.m2d.marktype.*;
import opale.tools.*;
import opale.mathtools.*;
import java.io.*;

/**
* Cette classe tend <code>FPolar</code> et reprsente graphiquemnet une fonction polaire r=f(theta).
* @since Opale-2d 0.11
* @author O.C.
*/

public class GFPolar extends FPolar implements Cloneable, GObject2D
{
private DefaultGraphicalOptions info; 


/**
* Constructeur par dfaut.
*/
public GFPolar()
	{
	super();
	if (Debug.On) Debug.print("Dans GFPolar()");
	info = new DefaultGraphicalOptions();
	}

/**
* Construit et initialise la fonction avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public GFPolar(OIJ rep)
	{
	super(rep);
	info = new DefaultGraphicalOptions();
	}


/**
* Le constructeur de copie
* @param GFPolar d, l'objet  copier.
*/
public GFPolar(GFPolar f)
	{
	super(f);	
	info = f.info;
	}

public void draw(Pen2D c)
	{

	double[] x = new double[N];
	double[] y = new double[N];
	int i;
	double pas = Math.abs(tsup-tinf)/(N-1);
	double temp,th;
	
	for (i=0;i<N;i++)
		{
		th = tinf + i*pas;
		temp = val(th);
		x[i] = temp * Math.cos(th);
		y[i] = temp*Math.sin(th);
		}
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
			for (i=0;i<N-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		MarkType mt = info.getMarktype();
		if (!(mt instanceof ClassicPoint))
			for (i=0;i<N;i++)
				mt.draw(c,x[i],y[i]);
		}



	}
	
	
	
public InfoObject getInfo()
	{
	return info;
	}
	

public  int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	info.write(f,p);
	super.writeMore(f,p);
	}	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GFPolar gy = (GFPolar) super.clone();
	return gy;
	}

public double x(double t) { return t; }
public double y(double t) {  return val(t); }
}
