/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.mathtools;

/**
* <code>RootFinder1D</code> is the superclass of solving methods for f(x) = 0 where f : R->R.
* By convention if the precision is not reached, then the number of iterations is MAXITERATION and the variable NITER  is set to -1.  
* @author O.C.
* @date 01/2001
* @since Opale-Mathtools 0.12
*/ 
public abstract class RootFinder1D
{
/**
* This value represents the precision of the solution.
*/
public double PRECISION = 1.e-6;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
public int MAXITERATION = 100;

/**
* This value indicates the number of iterations to obtain the convergence.
*/ 
public int NITER=0;

/**
* Finds the root of a numeric and scalar function f. The root must be between x0 and x1. It is returned by
* this method and will be computed until his precision is PRECISION or the number of iterations is MAXITERATION.
* @param IyFx f, a function.
* @param double x0, x1, values that bracket the root.
* @return double, the root.
* @throws RootSolverException.
*/ 
public abstract double find(IyFx f, double x0, double x1) ;//throws RootFinderException ;
}



