/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.mathtools.parser;

/**
* This class makes it possible to add an user function that will be recognised by the parser. It uses a string definition of the function and so an user can can create dynamicaly an function from a string definition : unlike the class <code>UnaryFunction</code>, this class will be used rather in the conception of a graphical user interface.
* @author OC
*/
public class SUnaryFunction extends UnaryFunction
{
private Parser p;
private String x,keyword;

private SUnaryFunction() {}

/**
* This constructor instanciate an user function : it must specify the keyword for the recognisation, the string definition of the variable and the string definition of the function. 
* <P> For instance, to define the function f(x) = 2*cos(x) : <code> SUnaryFunction myFunc = new SUnaryFunction("f","x","2*cos(x)")</code>
*/
public SUnaryFunction(String keyword,String var, String s)
	{
	this.keyword = keyword;
	p = new Parser(s);
	p.addVar(x=var);
	p.parseString();
	}
	
/**
* Evaluate the function at the point x.
*/
public double eval(double x)
	{
	p.setVar(this.x,x);
	return p.eval();
	}
/**
* Returns the keyword of this function
*/
public String keyword() { return keyword; }

}
