/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSARC_H
#define PAPYRUSARC_H

#include <cmath>

#include <papyrus/shape.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class Arc : public Shape
{
public:
  Arc(double angle_start=0.0, double angle_finish=M_PI/2.0, double radius=1.0);

    ~Arc();

    double get_radius();
    void set_radius(double r);

    double get_start_angle();
    double get_finish_angle();

    void set_angles(double start, double finish);

    virtual void draw_shape(cairo_t* cairo);

  protected:
    double m_radius, m_angle_start, m_angle_finish;

    virtual void on_changed(int i);

  private:
    void on_changed_proxy(int i);



};

}

#endif
