/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "canvas.h"

#include <iostream>

#include <cstdlib>
#include <math.h>

#include <assert.h>

using namespace Papyrus;

Canvas::Canvas(): m_background_color(1.0, 1.0, 1.0, 1.0) {
  m_root.set_pickable(false);
  m_root.signal_need_redraw().connect(sigc::mem_fun(*this, &Canvas::on_need_redraw));

}

Canvas::~Canvas() {}

void Canvas::set_background_color(RGBA color) {
    m_background_color = color;
}

void Canvas::clear() {
    m_root.clear();
}

// std::vector<Item*> Canvas::pick(double x, double y, unsigned depth) {
// //   return m_root.pick(m_cairo.get_cairo(), x, y, depth);
// }

bool Canvas::on_expose_event(GdkEventExpose* e) {
    cairo_t* cairo;
    /**
    * We need to call the paint function passing it the bounds of the window and the cairo drawing surface.
    * To do this, we need to create the cairo surface using gdk_cairo_create which requires the gdk drawable.
    * But, we can't directly access the gdk drawable from a Gtk::Widget. We must obtain the Gdk::Window of the
    * Gtk::Widget. Gdk::Drawable is a parent of Gdk::Window, but the gdk drawable is only available in the
     * parent method. Therefore we must access it this way:
    *
    * Gtk::Widget -> Gdk::Window -> Gdk::Drawable -> gdk drawable
    *
     */

    // get the Gdk::Window for this Gtk::Widget
    Glib::RefPtr<Gdk::Window> window = get_window();

    if (window) {
        // from the Gdk::Window, call the parent Gdk::Drawable gobj() method to obtain the gdk drawable
        GdkDrawable* gdkDrawable = window->Gdk::Drawable::gobj();

        if (gdkDrawable != NULL) {
            // create the gdk cairo surface
            cairo = gdk_cairo_create(gdkDrawable);
            m_root.render(cairo);

            cairo_destroy(cairo);
        }
    }

    return false;
}

void Canvas::on_need_redraw(double x, double y, double w, double h)
{
 queue_draw_area((int)floor(x)-2, (int)floor(y)-2, (int)ceil(w)+4, (int)ceil(h)+4);
}
