<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 foldmethod=marker: */
/* @(#) $Header: /sources/phpprintipp/phpprintipp/ExtendedPrintIPP.php,v 1.5 2006/01/02 20:42:02 harding Exp $
 *
 * Version: 0.3
 * Class PrintIPP - Send extended IPP requests.
 *
 *   Copyright (C) 2005-2006  Thomas HARDING
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   mailto:thomas.harding@laposte.net
 *   Thomas Harding, 56 rue de la bourie rouge, 45 000 ORLEANS -- FRANCE
 *   
 */
    
/*

    This class is intended to implement Internet Printing Protocol on client side.

    References needed to debug / add functionnalities:
        - RFC 2910
        - RFC 2911
        - RFC 3995
        - RFC 3996
        - RFC 3997
        - RFC 3998
        - ...
*/


class ExtendedPrintIPP extends PrintIPP {


    // {{{ constructor
    public function __construct() {
        parent::__construct();
    }
    // }}}


/******************
*
* PUBLIC FUNCTIONS
*
*******************/


// OPERATIONS

    // {{{ printURI ($uri)
    public function printURI ($uri) {

        self::_putDebug( sprintf("*************************\nDate: %s\n*************************\n\n",date('Y-m-d H:i:s')));

        if (!empty($uri)) {
            $this->document_uri = $uri;
            $this->setup->uri = 1;
        }
        
        if(!$this->_stringUri())
            return FALSE;
                       
        $this->output = $this->stringjob;
           
        $post_values = array( "Content-Type" => "application/ipp",
                              "Data" => $this->output);
            
            
        if (self::_sendHttp ($post_values,'/printers/')) {
            
            if(self::_parseServerOutput()) {
                $this->_getJobId();
                //$this->_getPrinterUri();
                $this->_getJobUri();
                }
            }
        
        if (isset($this->serveroutput) && isset($this->serveroutput->status)) {
            
            $this->status = array_merge($this->status,array($this->serveroutput->status));
            if ($this->serveroutput->status == "successfull-ok")
                self::_errorLog(sprintf("printing uri %s, job %s: ",$uri,$this->last_job)
                            .$this->serveroutput->status,3);
            else {    
                $this->jobs = array_merge($this->jobs,array(""));
                $this->jobs_uri = array_merge($this->jobs_uri,array(""));
                self::_errorLog(sprintf("printing uri %s: ",$uri,$this->last_job)
                            .$this->serveroutput->status,1);
                }
            return $this->serveroutput->status; 
            }
            
        $this->status = array_merge($this->status,array("OPERATION FAILED"));
        self::_errorLog("printing uri $uri : OPERATION FAILED",1);
            
    return false;
    }
    // }}}

    // {{{ purgeJobs()
    public function purgeJobs() {
        
        $this->jobs = array_merge($this->jobs,array(""));
        $this->jobs_uri = array_merge($this->jobs_uri,array(""));

        self::_setOperationId();
        $this->parsed = array();
        unset($this->printer_attributes);
        
        if (!isset($this->setup->uri)) {
            $this->getPrinters();
            unset($this->jobs[count($this->jobs) - 1]);
            unset($this->jobs_uri[count($this->jobs_uri) - 1]);
            unset($this->status[count($this->status) - 1]);
            
            if (array_key_exists(0,$this->available_printers))
               self::setPrinterURI($this->available_printers[0]);
            else {
                trigger_error(_("_stringJob: Printer URI is not set: die"),E_USER_WARNING);
                self::_putDebug( _("_stringJob: Printer URI is not set: die\n"));
                self::_errorLog(" Printer URI is not set, die",2);
                return FALSE;
                }
            }
            
        if (!isset($this->setup->charset))
            self::setCharset('us-ascii');
            
        if (!isset($this->setup->language))
            self::setLanguage('en_us');

        if (!isset($this->meta->username))
            self::setUserName();
       
        $this->stringjob = chr(0x01) . chr(0x01) // 1.1  | version-number
                         . chr(0x00) . chr (0x12) // purge-Jobs | operation-id
                         . $this->meta->operation_id //           request-id
                         . chr(0x01) // start operation-attributes | operation-attributes-tag
                         . $this->meta->charset
                         . $this->meta->language
                         . $this->meta->printer_uri
                         . $this->meta->username
                         . chr(0x22)
                         . self::_giveMeStringLength("purge-jobs")
                         . "purge-jobs"
                         . self::_giveMeStringLength(chr(0x01))
                         . chr(0x01)
                         . chr(0x03); // end-of-attributes | end-of-attributes-tag
                         
        self::_putDebug(sprintf(_("String sent to the server is:\n%s\n"), $this->stringjob));
        
        self::_putDebug(sprintf(_("purging jobs of %s\n"),$this->printer_uri)); 
            
        $this->output = $this->stringjob;
          
        $post_values = array( "Content-Type"=>"application/ipp",
                              "Data"=>$this->output);
            
        if (self::_sendHttp ($post_values,'/admin/'))
            self::_parseServerOutput();
        

        
        if (isset($this->serveroutput) && isset($this->serveroutput->status)) {
            
            $this->status = array_merge($this->status,array($this->serveroutput->status));
            
            if ($this->serveroutput->status == "successfull-ok")
                self::_errorLog(sprintf(_("purging jobs of %s: "),$this->printer_uri)
                            .$this->serveroutput->status,3);
            else
                 self::_errorLog(sprintf(_("purging jobs of %s: "),$this->printer_uri)
                                             .$this->serveroutput->status,1);
                                             
            return $this->serveroutput->status; 
            }    
            
        $this->status = array_merge($this->status,array("OPERATION FAILED"));
        self::_errorLog(date("Y-m-d H:i:s : ")
                        .basename($_SERVER['PHP_SELF'])
                        .sprintf(_("ipurging jobs of %s : OPERATION FAILED"),
                                     $this->printer_uri),3);
            
    return false;
    }

    // }}}

    // {{{ createJob()
    public function createJob() {
        

        self::_setOperationId();
        $this->parsed = array();
        unset($this->printer_attributes);
        
        if (!isset($this->setup->uri)) {
            $this->getPrinters();
            unset($this->jobs[count($this->jobs) - 1]);
            unset($this->jobs_uri[count($this->jobs_uri) - 1]);
            unset($this->status[count($this->status) - 1]);
            
            if (array_key_exists(0,$this->available_printers))
               self::setPrinterURI($this->available_printers[0]);
            else {
                trigger_error(_("_stringJob: Printer URI is not set: die"),E_USER_WARNING);
                self::_putDebug( _("_stringJob: Printer URI is not set: die\n"));
                self::_errorLog(" Printer URI is not set, die",2);
                return FALSE;
                }
            }
            
        if (!isset($this->setup->charset))
            self::setCharset('us-ascii');
            
        if (!isset($this->setup->language))
            self::setLanguage('en_us');

        if (!isset($this->meta->username))
            self::setUserName();
        
        if (!isset($this->setup->copies))
            self::setCopies(1);

        if (!isset($this->meta->fidelity))
            $this->meta->fidelity = '';
 
        if (!isset($this->meta->sides))
            $this->meta->sides = '';
        
        if (!isset($this->meta->page_ranges))
            $this->meta->page_ranges = '';
                    
        if (!isset($this->setup->jobname))
            if (is_readable($this->data))
                self::setJobName(basename($this->data),true);
            else
                self::setJobName();
        unset($this->setup->jobname);

        if (!isset($this->timeout))
            $this->timeout = 60;
        
        $timeout = self::_integerBuild($this->timeout);
        

        $this->meta->timeout = chr(0x21) // integer
                             . self::_giveMeStringLength("multiple-operation-time-out")
                             . "multiple-operation-time-out"
                             . self::_giveMeStringLength($timeout)
                             . $timeout;
                             
        $jobattributes = '';
        foreach ($this->job_tags as $key => $value) {
            if (array_key_exists('value',$value))
                $jobattributes .= $value['systag']
                                . self::_giveMeStringLength($key)
                                . $key
                                . self::_giveMeStringLength($value['value'])
                                . $value['value'];
        }
        reset ($this->job_tags);
        
        $printerattributes = '';
        foreach ($this->printer_tags as $key => $value) {
            if (array_key_exists('value',$value))
                $printerattributes .= $value['systag']
                                . self::_giveMeStringLength($key)
                                . $key
                                . self::_giveMeStringLength($value['value'])
                                . $value['value'];
        }
        reset ($this->printer_tags);
 
 
        $this->stringjob = chr(0x01) . chr(0x01) // 1.1  | version-number
                         . chr(0x00) . chr (0x05) // Create-Job | operation-id
                         . $this->meta->operation_id //           request-id
                         . chr(0x01) // start operation-attributes | operation-attributes-tag
                         . $this->meta->charset
                         . $this->meta->language
                         . $this->meta->printer_uri
                         . $this->meta->username
                         . $this->meta->jobname
                         . $this->meta->fidelity
                         . $this->meta->timeout
                         . $printerattributes
                         . chr(0x02) // start job-attributes | job-attributes-tag
                         . $this->meta->copies
                         . $this->meta->sides
                         . $this->meta->page_ranges
                         . $jobattributes
                         . chr(0x03); // end-of-attributes | end-of-attributes-tag
                         
        unset ($this->meta->copies,$this->meta->sides,$this->meta->page_ranges);

        self::_putDebug(sprintf(_("String sent to the server is:\n%s\n"), $this->stringjob));
        
        self::_putDebug(sprintf(_("purging jobs of %s\n"),$this->printer_uri)); 
            
        $this->output = $this->stringjob;
          
        $post_values = array( "Content-Type"=>"application/ipp",
                              "Data"=>$this->output);
            
        if (self::_sendHttp ($post_values,'/printers/'))
            if(self::_parseServerOutput()) {
                $this->_getJobId();
                $this->_getJobUri();
                $this->_parseJobAttributes();
            } else {
                $this->jobs = array_merge($this->jobs,array(''));
                $this->jobs_uri = array_merge($this->jobs_uri,array(''));
                }


        

        
        if (isset($this->serveroutput) && isset($this->serveroutput->status)) {
            
            $this->status = array_merge($this->status,array($this->serveroutput->status));
            
            if ($this->serveroutput->status == "successfull-ok")
                self::_errorLog(sprintf(_("Create job: job %s"),$this->last_job)
                            .$this->serveroutput->status,3);
            else {

                $this->jobs = array_merge($this->jobs,array(""));
                $this->jobs_uri = array_merge($this->jobs_uri,array(""));
                self::_errorLog(sprintf(_("Create-Job: %s"),$this->serveroutput->status),1);
                }                             
            return $this->serveroutput->status; 
            }    
            
        $this->status = array_merge($this->status,array("OPERATION FAILED"));
        self::_errorLog(date("Y-m-d H:i:s : ")
                        .basename($_SERVER['PHP_SELF'])
                        .sprintf(_("ipurging jobs of %s : OPERATION FAILED"),
                                     $this->printer_uri),3);
            
        $this->jobs = array_merge($this->jobs,array(""));
        $this->jobs_uri = array_merge($this->jobs_uri,array(""));
    return false;
    }

    // }}}
    
    // {{{ sendDocument($job)
    public function sendDocument($job,$is_last=false){
        
        self::_putDebug( sprintf("*************************\nDate: %s\n*************************\n\n",date('Y-m-d H:i:s')));

        if (!$this->_stringDocument($job,$is_last))
            return FALSE;
                       
        if (is_readable($this->data)){
            self::_putDebug( _("sending Document\n")); 
                
            $this->output = $this->stringjob;
           
            if ($this->setup->datatype == "TEXT")
                $this->output .= chr(0x16); // ASCII "SYN"
            
             
            $post_values = array( "Content-Type" => "application/ipp",
                                  "Data" => $this->output,
                                  "File" => $this->data);
            
            if ($this->setup->datatype == "TEXT" && !isset($this->setup->noFormFeed))
                $post_values = array_merge($post_values,array("Filetype"=>"TEXT"));
            
        } else {                      
            self::_putDebug( _("sending DATA as document\n")); 
            
            $this->output = $this->stringjob;
            $this->output .= $this->datahead;    
            $this->output .= $this->data;
            $this->output .= $this->datatail;
            
            $post_values = array( "Content-Type" => "application/ipp",
                                  "Data" => $this->output);
             
            
            }
            
        if (self::_sendHttp ($post_values,'/printers/')) {
        
            if(self::_parseServerOutput()) {
                $this->_getJobId();
                //$this->_getPrinterUri();
                $this->_getJobUri();
                $this->_parseJobAttributes();
            } else {
                $this->jobs = array_merge($this->jobs,array($job));
                $this->jobs_uri = array_merge($this->jobs_uri,array($job));
                }

            }
        
        if (isset($this->serveroutput) && isset($this->serveroutput->status)) {
            
            $this->status = array_merge($this->status,array($this->serveroutput->status));

            if ($this->serveroutput->status == "successfull-ok")
                self::_errorLog(sprintf("sending document, job %s: %s",$job,$this->serveroutput->status),3);
            else {
                $this->jobs = array_merge($this->jobs,array(""));
                $this->jobs_uri = array_merge($this->jobs_uri,array(""));
                self::_errorLog(sprintf("sending document, job %s: %s",$job,$this->serveroutput->status),1);
                }
            return $this->serveroutput->status; 
            
            }

        $this->status = array_merge($this->status,array("OPERATION FAILED"));
        $this->jobs = array_merge($this->jobs,array($job));
        $this->jobs_uri = array_merge($this->jobs_uri,array($job));
        self::_errorLog(sprintf("sending document, job %s : OPERATION FAILED",$job),1);
    
    return false;
    }
    // }}}

    // {{{ sendURI ($uri)
    // TODO
    // }}}

    // {{{ pausePrinter ()
    // TODO
    // }}}

    // {{{ Resume-Printer ()
    // TODO
    // }}}

    // {{{ Hold-Job ($job_uri)
    // TODO
    // }}}
    
    // {{{ Release-Job ($job_uri)
    // TODO
    // }}}
    
    // {{{ Restart-Job ($jpb_uri)
    // TODO
    // }}}

// REQUEST BUILDING

    // {{{ _stringUri ()
    protected function _stringUri () {
    
        self::_setDocumentUri();
        
        if (!isset($this->setup->document_uri)) {
            trigger_error(_("_stringUri: Document URI is not set: die"),E_USER_WARNING);
            self::_putDebug( _("_stringUri: Document URI is not set: die\n"));
            self::_errorLog("Document URI is not set, die",2);
            return FALSE;
        }
        unset ($this->setup->document_uri);
               
        if (!isset($this->setup->uri)) {
            $this->getPrinters();
            unset($this->jobs[count($this->jobs) - 1]);
            unset($this->jobs_uri[count($this->jobs) - 1]);
            unset($this->status[count($this->status) - 1]);
            
            if (array_key_exists(0,$this->available_printers))
               self::setPrinterURI($this->available_printers[0]);
            else {
                trigger_error(_("_stringUri: Printer URI is not set: die"),E_USER_WARNING);
                self::_putDebug( _("_stringUri: Printer URI is not set: die\n"));
                self::_errorLog("_stringUri: Printer URI is not set, die",2);
                return FALSE;
                }
            }
  
        if (!isset($this->setup->charset))
            $this->meta->charset = "";
        //    self::setCharset('us-ascii');
        if (!isset($this->setup->datatype))
            self::setBinary();
        if (!isset($this->setup->uri)) {
            trigger_error(_("_stringUri: Printer URI is not set: die"),E_USER_WARNING);
            self::_putDebug( _("_stringUri: Printer URI is not set: die\n"));
            self::_errorLog("Printer URI is not set, die",2);
            return FALSE;
            }
        if (!isset($this->setup->copies))
            self::setCopies(1);
        
        if (!isset($this->setup->language))
            self::setLanguage('en_us');

        if (!isset($this->setup->mime_media_type))
            self::setMimeMediaType();
        unset ($this->setup->mime_media_type);
            
        if (!isset($this->setup->jobname))
            if (is_readable($this->data))
                self::setJobName(basename($this->data),true);
            else
                self::setJobName();
        unset($this->setup->jobname);

        if (!isset($this->meta->username))
            self::setUserName();

        if (!isset($this->meta->fidelity))
            $this->meta->fidelity = '';
        
        if (!isset($this->meta->document_name))
            $this->meta->document_name = '';

        if (!isset($this->meta->sides))
            $this->meta->sides = '';
        
        if (!isset($this->meta->page_ranges))
            $this->meta->page_ranges = '';
         
        $jobattributes = '';
        foreach ($this->job_tags as $key => $value) {
            if (array_key_exists('value',$value))
                $jobattributes .= $value['systag']
                                . self::_giveMeStringLength($key)
                                . $key
                                . self::_giveMeStringLength($value['value'])
                                . $value['value'];
        }
        reset ($this->job_tags);
        
        $printerattributes = '';
        foreach ($this->printer_tags as $key => $value) {
            if (array_key_exists('value',$value))
                $printerattributes .= $value['systag']
                                . self::_giveMeStringLength($key)
                                . $key
                                . self::_giveMeStringLength($value['value'])
                                . $value['value'];
        }
        reset ($this->printer_tags);
         
        self::_setOperationId();
       
        if (!isset($this->error_generation->request_body_malformed))
            $this->error_generation->request_body_malformed = "";
       
        $this->stringjob = chr(0x01) . chr(0x01) // 1.1  | version-number
                         . chr(0x00) . chr (0x03) // Print-URI | operation-id
                         . $this->meta->operation_id //           request-id
                         . $this->error_generation->request_body_malformed
                         . chr(0x01) // start operation-attributes | operation-attributes-tag
                         . $this->meta->charset
                         . $this->meta->language
                         . $this->meta->printer_uri
                         . $this->meta->jobname
                         . $this->meta->username
                         . $this->meta->fidelity
                         . $this->meta->document_name
                         . $this->meta->document_uri
                         . $printerattributes
                         . chr(0x02) // start job-attributes | job-attributes-tag
                         . $this->meta->copies
                         . $this->meta->sides
                         . $this->meta->page_ranges
                         . $jobattributes
                         . chr(0x03); // end-of-attributes | end-of-attributes-tag
                         
        self::_putDebug( sprintf(_("String sent to the server is:\n%s\n"), $this->stringjob));
        return TRUE;
    }
    // }}}
    
    // {{{ _stringDocument ($job)
    protected function _stringDocument ($job,$is_last) {
    
        if ($is_last == false)
            $is_last = chr(0x00);
        else
            $is_last = chr(0x01);
    
        if (!isset($this->setup->charset))
            self::setCharset('us-ascii');
        if (!isset($this->setup->datatype))
            self::setBinary();

        if (!isset($this->setup->uri)) {
            $this->getPrinters();
            unset($this->jobs[count($this->jobs) - 1]);
            unset($this->jobs_uri[count($this->jobs_uri) - 1]);
            unset($this->status[count($this->status) - 1]);
            
            if (array_key_exists(0,$this->available_printers))
               self::setPrinterURI($this->available_printers[0]);
            else {
                trigger_error(_("_stringJob: Printer URI is not set: die"),E_USER_WARNING);
                self::_putDebug( _("_stringJob: Printer URI is not set: die\n"));
                self::_errorLog(" Printer URI is not set, die",2);
                return FALSE;
                }
            }
            
        if (!isset($this->setup->copies))
            $this->meta->copies = "";
        
        if (!isset($this->setup->language))
            self::setLanguage('en_us');

        if (!isset($this->setup->mime_media_type))
            $this->meta->mime_media_type = "";
        if ($this->setup->datatype != "TEXT")
        unset ($this->setup->mime_media_type);
            
        if (!isset($this->meta->fidelity))
            $this->meta->fidelity = '';
        
        if (!isset($this->meta->document_name))
            $this->meta->document_name = '';

        if (!isset($this->meta->sides))
            $this->meta->sides = '';
        
        if (!isset($this->meta->page_ranges))
            $this->meta->page_ranges = '';
       
        $operationattributes = '';
        foreach ($this->printer_tags as $key => $value) {
            if (array_key_exists('value',$value))
                $operationattributes .= $value['systag']
                                . self::_giveMeStringLength($key)
                                . $key
                                . self::_giveMeStringLength($value['value'])
                                . $value['value'];
        }
        reset ($this->printer_tags);
        
        self::_setOperationId();

       
        $this->stringjob = chr(0x01) . chr(0x01) // 1.1  | version-number
                         . chr(0x00) . chr (0x06) // Send-Document | operation-id
                         . $this->meta->operation_id //           request-id
                         . chr(0x01) // start operation-attributes | operation-attributes-tag
                         . $this->meta->charset
                         . $this->meta->language
                         . chr(0x45) // attribute-type: uri
                         . self::_giveMeStringLength("job-uri")
                         . "job-uri"
                         . self::_giveMeStringLength($job)
                         . $job
                         . $this->meta->username
                         . $this->meta->document_name
                         . $this->meta->fidelity
                         . $this->meta->mime_media_type
                         . $operationattributes
                         . chr(0x22) // boolean
                         . self::_giveMeStringLength("last-document")
                         . "last-document"
                         . self::_giveMeStringLength($is_last)
                         . $is_last
                         . chr(0x03); // end-of-attributes | end-of-attributes-tag
        

        self::_putDebug( sprintf(_("String sent to the server is:\n%s\n"), $this->stringjob));
        return TRUE;
    }
    // }}}
    
};

/*
 * Local variables:
 * mode: php
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
?>
