<?php
/*
 *Example of use of PrintIPP
 *
 * Copyright(C) 2005-2006 Thomas Harding
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Thomas Harding nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 *   mailto:thomas.harding@laposte.net
 *   Thomas Harding, 56 rue de la bourie rouge, 45 000 ORLEANS -- FRANCE
 *
 */

/**********************************************************
*
*   S E T U P
*
***********************************************************/

$host = "geekette.localdomain"; // set serve'rs host here
$printer_uri = "/printers/epson"; // set printer uri here
$language = "fr_fr";
$user = "test"; // valid user from lpadmin group
$password = "test"; // his password
$document_uri = "http://localhost/";

error_reporting(E_ALL);
/******************
*
* END OF SETUP
*
*******************/


function __autoload($class_name) {
   require_once $class_name . '.php';
}
   
//require_once("CupsPrintIPP.php"); // other files are loaded by it

echo "<html><head></head><body><h1>PHP PrintIPP example</h1>";

echo "Note that all options are not showed here<br />";

//$ipp = new PrintIPP(); // Basic PrintIPP
//$ipp = new ExtendedPrintIPP(); // extended IPP
$ipp = new CupsPrintIPP(); // extended IPP with CUPS specific stuff

$ipp->debug_level = 3; // Debugging very verbose

$ipp->setLog('/tmp/printipp','file',1); // logging almost quiet
$ipp->setLog('/tmp/printipp','file',2); // logging verbose
$ipp->setLog('/tmp/printipp','file',3); // logging very verbose

$ipp->setHost("localhost");
//$ipp->setHost("toto");// Resistance test
$ipp->setHost($host); //Put your printer IP or hostname/fqdn here

$ipp->setPrinterURI($printer_uri); // Set printer URI here
//$ipp->setPrinterURI("ipp://localhost:631/printers/epson"); // Set printer URI here
//$ipp->setPrinterURI("/printers/foo"); // => abort "client-error-not-found"

$ipp->setUserName("php IPP tester");

$ipp->setFidelity(); // printing abort if every attribute could not be set on printer. NOTE: CUPS do not abort :)

$ipp->setCharset('utf-8');
$ipp->setLanguage($language);

$ipp->setAuthentification($user,$password); // username & password 

$j = 0;
$test = 1;
/* getting printer's attributes */
echo "<br /><br /><br />TEST ".$test++."<br />";
echo "OPERATION  ".$j++."<br />";
echo "Getting Printer's attributes: ". $ipp->getPrinterAttributes() . "<br />";
printf('$ipp->status[0] = %s <br /><br />', $ipp->status[0]);
echo "Printer's attributes :<pre>\n"; print_r($ipp->printer_attributes); echo "</pre>";

/* getting printers (CUPS extention) */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ".$j++."<br />";
echo "Available printers [CUPS EXTENTION]:<pre>" ; 
echo $ipp->getPrinters() . "\n";
print_r($ipp->available_printers);
echo "</pre>";


for ($i = 0 ; $i < count($ipp->available_printers) ; $i ++) {
$ipp->setPrinterURI($ipp->available_printers[$i]);
echo "OPERATION ".$j ++."<br />";
$ipp->getPrinterAttributes();
echo "Printer attributes for printer $i:<pre>\n"; print_r($ipp->printer_attributes); echo "</pre>";
if (isset($ipp->printer_attributes->printer_type->_value2)
        && ($ipp->printer_attributes->printer_type->_value2) == 'print-black')
    echo "The printer can print black<br />\n";
if (isset($ipp->printer_attributes->printer_type->_value3)
        && ($ipp->printer_attributes->printer_type->_value3) == 'print-color')
    echo "The printer can print color<br />\n";

    echo "Printer State: ".$ipp->printer_attributes->printer_state->_value0."<br />";
    echo "Printer State message: ".$ipp->printer_attributes->printer_state_message->_value0."<br />";
    echo "Document formats supported:<br /><pre>";

    $pointer = "_value0";
    for ($k = 0 ; isset($ipp->printer_attributes->document_format_supported->$pointer); $k++) {
        echo $ipp->printer_attributes->document_format_supported->$pointer . "\n";
        $pointer = "_value" . ($k + 1);
        }
    echo "</pre>";

echo "------- END FOR PRINTER $i -------------<br /n>";
}


/* resetting printer uri to those configured */
$ipp->setPrinterURI($printer_uri);


/* printing a string */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setJobName("PHP Test: Text String",true); // default is false: number is automagically appended
$ipp->setData("This is a text string");
echo "Print String: ".$ipp->printJob()."</br />";
echo "Job Attributes:<pre>\n" ; print_r($ipp->job_attributes) ; echo "\n</pre>\n";

// for restart job operation
$first_job = $ipp->last_job;

/* printing a text file */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

        // HINT: you _must_ supply a charset or set output as raw text
        // note that mimeMediaType is resetted to octet-stream after each call of printJob (this is a feature).
echo "OPERATION ". $j ++ ."<br />";
$ipp->setCharset('us-ascii');
$ipp->setMimeMediaType('text/plain');
$ipp->setJobName("PHP Test: US ASCII file",true); // default is false: number is automagically appended

$ipp->setData("./testfiles/test.txt");//Path to file.
echo "US ASCII file Job status: ".$ipp->printJob("epson")."<br />";


/* printing a document by URI */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Job Print URI status: ".$ipp->printUri($document_uri)."<br />";



/* printing a text file in utf-8 */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setUserName("foo bar");
$ipp->setCharset('utf-8');
$ipp->setMimeMediaType('text/plain'); // if autodetection do not work
// attributes without dedicated function
$ipp->setAttribute('orientation-requested','landscape');
$ipp->setAttribute('number-up',2);
$ipp->setDocumentName("testfile with UTF-8 characters, gzipped");
$ipp->setJobName("testfile with UTF-8 characters, gzipped");
$ipp->setDocumentName("testfile with UTF-8 characters");
$ipp->setData("./testfiles/test-utf8.txt");//Path to file
echo "Printing testfile with UTF-8 characters: ".$ipp->printJob()."<br />";

/* printing a gzipped file */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setAttribute('compression','gzip');
$ipp->setData("./testfiles/test-utf8-compressed.txt.gz");//Path to file.
echo "Printing testfile with UTF-8 characters, gzipped: ".$ipp->printJob()."<br />";
$ipp->unsetAttribute('compression');


/* getting not-completed jobs */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Getting NOT PROCESSED Jobs: ".$ipp->getJobs(true,0,"")."<br />"; // defaults to $my_jobs=true,$limit=0 (no limit),$which_jobs=not-completed,$subset=false 

echo "Job 0 state: ".$ipp->jobs_attributes->job_0->job_state->_value0."<br />";
echo "Job 0 state-reasons: ".$ipp->jobs_attributes->job_0->job_state_reasons->_value0."<br />";
echo "<pre>";print_r($ipp->jobs_attributes); echo "</pre>";

/* getting all jobs (subset of attributes) */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Getting ALL Jobs: ".$ipp->getJobs(true,0,"completed",true)."<br />";

echo "Job 0 state: ".$ipp->jobs_attributes->job_0->job_state->_value0."<br />";
echo "Job 0 state-reasons: ".$ipp->jobs_attributes->job_0->job_state_reasons->_value0."<br />";
echo "<pre>";print_r($ipp->jobs_attributes); echo "</pre>";


/* getting a job's attributes */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Getting last job's attributes: ".$ipp->getJobAttributes($ipp->last_job,false,'job-template')."<br />";
                    
$job_state = $ipp->job_attributes->job_state->_value0;
echo "Job-State: $job_state<br />";

$job_state_reasons = $ipp->job_attributes->job_state_reasons->_value0;
echo "Job-State-Reasons: $job_state_reasons<br />";
 
echo "<pre>";print_r($ipp->job_attributes); echo "</pre>";



/* printing selected pages from a document */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setAttribute('media','A7');
$ipp->setAttribute('number-up',4);
$ipp->setData("./testfiles/COPYING");
$ipp->setPageRanges('1:2 5:6');
echo "Printing selected pages from document by 4 pages on a single A7 media: ". $ipp->printJob() ."<br />";
$ipp->setPageRanges('');

$ipp->unsetAttribute('media');
$ipp->unsetAttribute('number-up');

/* printing a postcript file */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setMimeMediaType(); // => autodetection
$ipp->setData("./testfiles/test.ps");
echo "Printing Postscript Job status: ".$ipp->printJob("epson")."<br />";


/* printing a png  file */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setData("./testfiles/test.png");
echo "Printing png Job status: ".$ipp->printJob("epson")."<br />";

/* printing and cancelling job */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "Printing and Cancelling a job<br />";
$ipp->setData("./testfiles/test.ps");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob()."<br />";
$job = $ipp->last_job;
$ipp->setMessage(sprintf(_("job %s cancelled"),$job));
echo "OPERATION ". $j ++ ."<br />";
echo "Cancel status: ".$ipp->cancelJob($job)."<br />";

/* printing strings, no form feed */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

$ipp->setRawText();
$ipp->unsetFormFeed();

echo "Printing RAW TEXT strings<br />";

$ipp->setData("This is a line\n");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is half a line ");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is a end of line\n");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";

// set copies to 2 (same sheet of paper: form feed is unset)
$ipp->setData("This lines must appeared twice\r\n");
$ipp->setCopies(2);
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";
$ipp->setCopies(1);

// printing string, then form feed
echo "OPERATION ". $j ++ ."<br />";
$ipp->setFormFeed();
$ipp->setData("End of test");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->unsetRawText();


/* printing a file to see if unsetRawText works */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setData("./testfiles/test.ps");
echo "Job status (text file after strings): ".$ipp->printJob()."<br />";


/* multiple document handling */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

$ipp->setUserName("test");
$ipp->setCopies(1);
echo "OPERATION ". $j ++ ."<br />";
echo "Create-Job: ".$ipp->createJob(). "<br />";
printf("Job is: %s<br />",$job = $ipp->last_job);

echo "<pre>";print_r($ipp->job_attributes);echo "</pre>\n";

$ipp->setDocumentName("test-utf8.txt");
$ipp->setData("./testfiles/test-utf8.txt");
echo "OPERATION ". $j ++ ."<br />";
echo "Sending document: " . $ipp->sendDocument($job) . "<br />\n";

echo "OPERATION ". $j ++ ."<br />";
echo "Sending URI: ".$ipp->sendURI('http://localhost',$job). "<br />\n";

$ipp->setDocumentName("text string");
$ipp->setData("This is the string of second document");
echo "OPERATION ". $j ++ ."<br />";
echo "Sending text string as _last_ document: " . $ipp->sendDocument($job,$last=true) . "<br />\n";

// must be refused. Hem: CUPS is very smart, it accepts :)
echo "OPERATION ". $j ++ ."<br />";
echo "Sending document (must be refused): " . $ipp->sendDocument($job,$last=true) . "<br />\n";


/* try to validate a job with filetype printer server can't handle */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

$ipp->setMimeMediaType("application/x-foobar");

echo "OPERATION ". $j ++ ."<br />";
echo "Validate-Job: ".$ipp->validateJob()."<br />";

foreach ($ipp->job_attributes as $name => $job_attribute) {
    if ($job_attribute->_range == 'unsupported-attributes')
        printf('%s "%s": unsupported attribute<br />',$name,$job_attribute->_value0);
}
reset($ipp->job_attributes);
echo "Details:<pre>"; print_r($ipp->job_attributes) ; echo "</pre>";


/* Printing then holding a job */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Printing a document :".$ipp->printJob()."<br />";
echo "Job is: ".$job = $ipp->last_job."<br />";
//sleep(1);
echo "OPERATION ". $j ++ ."<br />";
echo "Holding the job for an indefinite period: ".$ipp->holdJob($job,'indefinite')."<br />";
echo "OPERATION ". $j ++ ."<br />";
echo "Getting job state : ".$ipp->getJobAttributes($job)."<br />";
echo "Job State: ".$ipp->job_attributes->job_state->_value0."<br />";
echo "Job State Reason: ".$ipp->job_attributes->job_state_reasons->_value0."<br />";

/* releasing the job */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Releasing the job for: ".$ipp->releaseJob($job,'indefinite')."<br />";
echo "OPERATION ". $j ++ ."<br />";
echo "Getting job state : ".$ipp->getJobAttributes($job)."<br />";
echo "Job State: ".$ipp->job_attributes->job_state->_value0."<br />";
echo "Job State Reason: ".$ipp->job_attributes->job_state_reasons->_value0."<br />";


/* restarting a job */
echo "<br /><br /><br /> TEST ".$test ++."<br />";
echo "OPERATION ". $j ++ ."<br />";
echo "Restarting the job $first_job (if completed!): ".$ipp->restartJob($first_job)."<br />";
echo "OPERATION ". $j ++ ."<br />";
echo "Getting job state : ".$ipp->getJobAttributes($first_job)."<br />";
echo "Job State: ".$ipp->job_attributes->job_state->_value0."<br />";
echo "Job State Reason: ".$ipp->job_attributes->job_state_reasons->_value0."<br />";


/* purging jobs for a printer */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setUserName("test");
$ipp->setPrinterURI("ipp://localhost:631/printers/epson"); // Set printer URI here
echo "Purge-Jobs for printer $printer_uri: ". $ipp->purgeJobs() ."<br />";

/* purging jobs for all printers */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setPrinterURI("ipp://localhost:631/printers/"); // => all printers
echo "Purge-Jobs (all printers): ". $ipp->purgeJobs() ."<br />";


/* pausing printer */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setPrinterURI($printer_uri);
echo "Pausing Printer $printer_uri, then sleep 1 second: ".$ipp->pausePrinter()."<br />";
sleep(1);
echo "OPERATION ". $j ++ ."<br />";
echo "Getting printer's attributes: ".$ipp->getPrinterAttributes()."<br />";
echo "Printer State: ".$ipp->printer_attributes->printer_state->_value0."<br />";

/* Resuming printer */
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
echo "Resuming Printer $printer_uri, then sleep 1 second: ".$ipp->resumePrinter()."<br />";
sleep(1);
echo "OPERATION ". $j ++ ."<br />";
echo "Getting printer's attributes: ".$ipp->getPrinterAttributes()."<br />";
echo "Printer State: ".$ipp->printer_attributes->printer_state->_value0."<br />";


/* send a buggy request */

echo "<br /><br /><br /> TEST ".$test ++."<br />";
echo "OPERATION ". $j ++ ."<br />";
$ipp->setData("This is an error : nothing printed\n");
$ipp->generateError ("request_body_malformed");
echo "Sending a buggy request. status: ".$ipp->printJob()."<br />";

$ipp->resetError("request_body_malformed");


/**/

echo "END OF OPERATIONS <br /><br /><br />";

/* get informations about jobs and status */

echo "Available printers:<br />\n" ;
echo "<pre>\n";
print_r($ipp->available_printers);
echo "</pre>";

echo "Jobs:\n<br />" ; 
echo "<pre>\n";
print_r($ipp->jobs);
echo "</pre>";

echo "Jobs URIs:\n<br />\n";
echo "<pre>\n";
print_r($ipp->jobs_uri);
echo "</pre>";

echo "Printers URIs:\n" ; 
echo "<pre>\n";
print_r($ipp->printers_uri);
echo "</pre>";

echo "Operations status:\n" ; 
echo "<pre>\n";
print_r($ipp->status);
echo "</pre>";


/* get debugging informations */

echo "<h3>Debug</h3><pre>";
$ipp->printDebug();
echo "</pre>";


/* end of test */

echo "END OF TESTFILE</body></html>";
?>
