/* phc -- customizable proxy hunter
 * 
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions are declared in phc.h */
#include <phc.h>
/* these functions are defined in this file */
void INIT (void);
void THREAD (void);
void END (void);

int
main (int argc, char **argv)
{
  progname = argv[0];
  INIT ();
  THREAD ();
  END ();
  return 0;
}

/* init */
void
INIT ()
{
  int blen, dlen, slen, elen;
  struct hostent *h;

  mem_init ();
  READCONF ();

  if ((test.method != HTTP_CONNECT) && (test.method != HTTP_GET))
    {
      fprintf (stderr, "method %d is not supported now\n", test.method);
      exit (EXIT_FAILURE);
    }

  /* myproxy's ip,authenticate data,useragaent etc */
  if ((my.mytype == HTTP_CONNECT_AUTH))
    {
      blen = strlen (BASIC);
      /*
         if ((blen = strlen (BASIC)) >= sizeof (header_auth))
         {
         fprintf (stderr, "lame code:BASIC longer than header_auth\n");
         exit (EXIT_FAILURE);
         } */
      slen = strlen (my.myuserpass);
      elen = slen / 3 * 4 + ((slen % 3) ? 4 : 0);
      my.header_auth = xmalloc (blen + elen + 1);

      memmove (my.header_auth, BASIC, blen);
      dlen = base64en (my.header_auth + blen, elen,
		       (unsigned char *) my.myuserpass, slen);
      if (my.myuserpass)
	free (my.myuserpass);
      if (dlen == -1)
	{
	  fprintf (stderr, "error:base64encode\n");
	  exit (EXIT_FAILURE);
	}
      if (dlen != elen)
	{
	  fprintf (stderr, "base64en:This error is impossible,good news!\n");
	  exit (EXIT_FAILURE);
	}
      my.header_auth[blen + dlen] = '\0';
      /* debug */
      /* printf ("%s\n", header_auth); */
    }

  h = gethostbyname ((const char *) my.myhost);
  free (my.myhost);
  if (h == NULL)
    {
      herror ("gethostbyname");
      exit (EXIT_FAILURE);
    }
  else
    my.myip = *(struct in_addr *) (h->h_addr);
/* debug */
  printf ("addr=%s\n", inet_ntoa (my.myip));
  my.myaddr.sin_family = AF_INET;
  my.myaddr.sin_addr = my.myip;
  my.myaddr.sin_port = htons (my.myport);
  memset (&(my.myaddr.sin_zero), 0, sizeof (my.myaddr.sin_zero));

  if ((in = fopen (PHC_IN, "r")) == NULL)
    {
      perror ("fopen " PHC_IN);
      exit (EXIT_FAILURE);
    }
  if ((out = fopen (PHC_OUT, "w")) == NULL)
    {
      perror ("fopen " PHC_OUT);
      exit (EXIT_FAILURE);
    }
  setvbuf (out, (char *) NULL, _IONBF, 0);
  setvbuf (stdout, (char *) NULL, _IONBF, 0);
  setvbuf (stderr, (char *) NULL, _IONBF, 0);

}

/* setup loop */
enum
{ MAXTHREADS = 65535 };
void
THREAD ()
{
  int tidnum[MAXTHREADS], mainret, i;
  pthread_t tid[MAXTHREADS];
  void *status;

  if ((threads > MAXTHREADS) || (threads < 1))
    {
      fprintf (stderr, "threads between [1,%d] is permitted!"
	       "please modify \"thread=\" in .conf" "then  try again.\n",
	       MAXTHREADS);
      exit (EXIT_FAILURE);
    }
  for (i = 0; i < threads; i++)
    {
      tidnum[i] = i;
      if ((mainret = pthread_create (tid + i, NULL, loop, tidnum + i)) == 0)
	{
	  /*printf("thread %d create %d\n",i,tid[i]); */
	}
      else
	{
	  printf ("errno=%d\n", mainret);
	  errno = mainret;
	  perror ("pthread_create!!!");
	  exit (EXIT_FAILURE);
	}
    }
  for (i = 0; i < threads; i++)
    {
      if (pthread_join (tid[i], &status) == 0)
	{
	  /*printf("join thread %d\n",i,*(int *)status); */
	}
      else
	{
	  perror ("pthread_join");
	  exit (EXIT_FAILURE);
	}
    }

}

/* clean memory */
void
END ()
{
  fclose (in);
  fclose (out);
  pthread_mutex_destroy (&counter_mutex_in);
  pthread_mutex_destroy (&counter_mutex_out);
  pthread_mutex_destroy (&counter_mutex_create);
  pthread_mutex_destroy (&counter_mutex_malloc);
}
