/* checkaline.c - proxylist parsing routine
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all upper case */
#include <phc.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
/* Check a proxylistline  and extract one testproxy from it if have.
 
 * The proxylistline to be checked was in thread_mem->line.
   
 * Return value:
   0: success!
   -1: fail to find a valid testproxy!
 */


/* rules: 
   proxylistline should in format ip:port@protocol* or 
                                  ip:port without other trailling chars
 * example of valid list:
   1.2.3.5:8080@HTTPSxxxxx....
   1.2.3.5:8080@httpxxxxxxxxx..
   6.7.8.9:123
   
 * example of invalid list:
   1.2.3.8:12 HTTPS
   1.2.6.8:12xxxxx...
   xxx1.2.3.8:12...
   www.somsite.com...
   */
int
checkaline (struct thread_mem *thread_mem)
{
  char *p;
  size_t plen;
  int i, n, m;

    /**************deal with proxylistline************/
  p = strchr (thread_mem->line, '@');
  /* step 1 : protocol check : parse and remove @ if have */
  if (p == NULL)
    {
      fprintf (stderr,
	       "%s: checkaline:Type of testproxy is default to HTTP:%s\n",
	       progname, thread_mem->line);
      plen = strlen (thread_mem->line);
      thread_mem->queue.proto = HTTP;
    }
  else
    {
      p++;
      if ((strncmp (p, "HTTP", 4) == 0) || (strncmp (p, "http", 4) == 0))
	{
	  thread_mem->queue.proto = HTTP;
	}
      else if ((strncmp (p, "SOCKS5", 6) == 0)
	       || (strncmp (p, "socks5", 6) == 0))
	{
	  thread_mem->queue.proto = SOCKS5;
	}
      else if ((strncmp (p, "SOCKS4", 6) == 0)
	       || (strncmp (p, "socks4", 6) == 0))
	{
	  thread_mem->queue.proto = SOCKS4;
	}

      else
	{
	  fprintf (stderr,
		   "%s: checkaline:Protocol %s at ...%s is not implemented\n",
		   progname, p, thread_mem->line);
	  return -1;
	}
      p--;
      plen = p - thread_mem->line;
    }
  /* step2 : check length */
  if (plen < strlen ("1.2.3.4:8"))
    {
      fprintf (stderr, "%s: checkaline:Invalid testproxy:%s\n", progname,
	       thread_mem->line);
      return -1;
    }

  p = thread_mem->line;
  /* step3 : check data format  */
  /* 1.2.3.4:12345
     m 0 1 2 3 8 
   */
  i = 0;
  m = 0;
  for (n = 0; n < plen; n++)
    {
      if ((m <= 3) && (m >= 0))	/* ipv4 , m range [0,3] */
	{
	  if (*p == ':')
	    {
	      if (m != 3)
		{
		  fprintf (stderr,
			   "%s: checkaline:The ':' appeared too early\n",
			   progname);
		  return -1;	/* port should not appear in ip field */
		}
	      m = 8;
	      i = 0;
	      p++;
	      continue;
	    }
	  if (*p == '.')
	    {
	      if (i == 0)
		{
		  fprintf (stderr, "%s: checkaline: No digit before '.' \n",
			   progname);
		  return -1;	/* We need at least a digit before '.'. */
		}
	      if (m == 3)	/* so m>=3 will not created here */
		{
		  fprintf (stderr,
			   "%s: checkaline:Trailing '.' is not needed\n",
			   progname);
		  return -1;	/* We do not need trailling '.' . */
		}
	      i = 0;
	      m++;
	      p++;
	      continue;
	    }
	  if (!isdigit (*p))
	    {
	      fprintf (stderr, "%s: checkaline:Not a digit in host field\n",
		       progname);
	      return -1;	/* ip should be digit , domain is not implented now */
	    }
	  else
	    {			/* if( i >2 ) return -1 ; */
	      i++;
	    }
	}
      else if (m == 8)
	{
	  if (i >= 5)
	    {
	      fprintf (stderr, "%s: checkaline: Port width > 5\n", progname);
	      return -1;	/* 65535
				   i 012345        
				 */
	    }
	  if (!isdigit (*p))
	    {
	      fprintf (stderr,
		       "%s: checkaline:Port %s at %d:%dis not in digit format\n",
		       progname, p, plen, p - thread_mem->line);
	      return -1;	/* port should be a number */
	    }
	  i++;
	}
      else
	{
	  /* in fact,if m changed from 0, process will not reach here */
	  fprintf (stderr, "%s: checkaline:Invalid field at offset %d\n",
		   progname, p - thread_mem->line);
	  return -1;
	}
      p++;

    }
  thread_mem->queue.testproxy = pxmalloc (plen + 1, thread_mem);
  memmove (thread_mem->queue.testproxy, thread_mem->line, plen);
  /* though it is not necessay now */
  *(thread_mem->queue.testproxy + plen) = '\0';
  return 0;
}
