#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/bh/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_bh = 4

n = qnum_bh +1

question_bh = [0]*n
answer_bh = [0]*n
choice1_bh = [0]*n
choice2_bh = [0]*n
choice3_bh = [0]*n
choice4_bh = [0]*n
sound_bh = [0]*n


question_bh[0] = 'Charles Darwin wrote the "The Origin of Species by Means of Natural Selection" which popularized the theory of evolution in what year?'
choice1_bh[0] = "1763"
choice2_bh[0] = "1859"
choice3_bh[0] = "1567"
choice4_bh[0] = "1893"
answer_bh[0] = 2
sound_bh[0] = checksound("bh000.ogg")

question_bh[1] = 'Who is credited as the "father of genetics," having showed inheritance of traits of peas?'
choice1_bh[1] = "John Murray"
choice2_bh[1] = "Antoine Laurent de Jussieu"
choice3_bh[1] = "Hugo de Vries"
choice4_bh[1] = "Gregor Mendel"
answer_bh[1] = 4
sound_bh[1] = checksound("bh001.ogg")

question_bh[2] = 'James Watson, Francis Crick, and Maurice Wilkins shared a Nobel prize for discovering the structure of?'
choice1_bh[2] = "cells"
choice2_bh[2] = "chloroplasts"
choice3_bh[2] = "DNA"
choice4_bh[2] = "RNA"
answer_bh[2] = 3
sound_bh[2] = checksound("bh002.ogg")

question_bh[3] = 'Anton van Leeuwenhoek is best known for?'
choice1_bh[3] = "first to observe microorganisms"
choice2_bh[3] = "discovering XY chrosomes"
choice3_bh[3] = "discovering hormones"
choice4_bh[3] = "developing theory of natural selection"
answer_bh[3] = 1
sound_bh[3] = checksound("bh003.ogg")

question_bh[4] = 'Who is credited for having started the science of classifying biological species, taxonomy? '
choice1_bh[4] = "Claude Bernard"
choice2_bh[4] = "Carolus Linnaeus"
choice3_bh[4] = "Robert Brown"
choice4_bh[4] = "Charles Darwin"
answer_bh[4] = 2
sound_bh[4] = checksound("bh004.ogg")
