#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/esh/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_esh = 4
n = qnum_esh+1

question_esh = [0]*n
answer_esh = [0]*n
choice1_esh = [0]*n
choice2_esh = [0]*n
choice3_esh = [0]*n
choice4_esh = [0]*n
sound_esh = [0]*n


question_esh[0] = "The first weather sattelite, TIROS-1, was launched in what year?"
choice1_esh[0] = "1960"
choice2_esh[0] = "1950"
choice3_esh[0] = "1970"
choice4_esh[0] = "1975"
answer_esh[0] = 1
sound_esh[0] = checksound("esh000.ogg")

question_esh[1] = "Blaise Pascal helped discover that pressure decreased as height increased in the atmosphere in what year?"
choice1_esh[1] = "1600"
choice2_esh[1] = "1648"
choice3_esh[1] = "1700"
choice4_esh[1] = "1750"
answer_esh[1] = 2
sound_esh[1] = checksound("esh001.ogg")

question_esh[2] = "Francis Bacon is often credited for having first noticed what feature of the earth?"
choice1_esh[2] = "the earth is round"
choice2_esh[2] = "weather seems to form patterns"
choice3_esh[2] = "continents as a jigsaw puzzle"
choice4_esh[2] = "10% of the earth is inhabitable"
answer_esh[2] = 3
sound_esh[2] = checksound("esh002.ogg")

question_esh[3] = "Who is credited for first suggesting earthquakes are caused by pieces of the earth rubbing against eachother?"
choice1_esh[3] = "William Maclure"
choice2_esh[3] = "James Hutton"
choice3_esh[3] = "Edmond Halley"
choice4_esh[3] = "John Michell"
answer_esh[3] = 4
sound_esh[3] = checksound("esh003.ogg")

question_esh[4] = "The Richter scale was developed in what year?"
choice1_esh[4] = "1935"
choice2_esh[4] = "1985"
choice3_esh[4] = "1950"
choice4_esh[4] = "1900"
answer_esh[4] = 1
sound_esh[4] = checksound("esh004.ogg")
