#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/m/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0



qnum_m = 4

n = qnum_m+1
question_m = [0]*n
answer_m = [0]*n
choice1_m = [0]*n
choice2_m = [0]*n
choice3_m = [0]*n
choice4_m = [0]*n
sound_m = [0]*n


question_m[0] = "The area bounded by a curve and the horizontal axis is equivalent to the curve's?"
choice1_m[0] = "integral"
choice2_m[0] = "derivative"
choice3_m[0] = "second derivative"
choice4_m[0] = "average value"
answer_m[0] = 1
sound_m[0] = checksound('m000.ogg')

question_m[1] = u'Multplying A \u00D7 B, where B \u003E 1, can be thought of the same as which of the following?'
choice1_m[1] = 'repeated subtraction of A, B times'
choice2_m[1] = 'repeated addition of A, B times'
choice3_m[1] = u'B \u00F7 A'
choice4_m[1] = 'none of the above'
answer_m[1] = 2
sound_m[1] = checksound('m001.ogg')

question_m[2] = 'In trigonometry, the sine of an angle in a triangle is equal to the proportion of what sides?'
choice1_m[2] = "opposite / adjacent"
choice2_m[2] = "adjacent / opposite"
choice3_m[2] = "opposite / hypotenuse"
choice4_m[2] = "hypotenus / adjacent"
answer_m[2] = 3
sound_m[2] = checksound('m002.ogg')

question_m[3] = "With the Pythagorean theorem, we know that the hypotenuse of a triangle, side c, is equal to? (with a and b being the other 2 sides of the triangle)"
choice1_m[3] = 'a + b'
choice2_m[3] = u'a\u00B2 + b\u00B2'
choice3_m[3] = u'a \u00D7 b'
choice4_m[3] = u'\u221A(a\u00B2 + b\u00B2)'
answer_m[3] = 4
sound_m[3] = checksound('m003.ogg')

question_m[4] = 'The commutative rule of addition states:'
choice1_m[4] = u'a + b = a \u00D7 b'
choice2_m[4] = 'a + b = b + a'
choice3_m[4] = u'a + b \u2260 b + a'
choice4_m[4] = u'a + b = a \u00F7 b'
answer_m[4] = 2
sound_m[4] = checksound('m004.ogg')


