#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from pyscitrivia modules
from scale import res

#set some things according to resolution
titlefontsize = int(0.09*res[0])
itemfontsize =  int(0.03*res[0])
itemspacing =  int(0.0625*res[0])
verticalborder =  int(0.125*res[1])

#colors
black = (0,0,0)
white = (255,255,255)
yellow = (252,255,0)

#initialize pygame
pygame.init()

class MakeHow:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#set fonts
		self.titlefont = pygame.font.Font('data/fonts/FreeSansBold.ttf', titlefontsize)
		self.itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)
		#create surfaces
		self.title = self.titlefont.render("How To Play", 1, yellow)
		self.item1 = self.itemfont.render("Bind your keys in the input settings screen, you can also use", 1, white)
		self.item2 = self.itemfont.render("left shift for player 1, spacebar for player 2,", 1, white)
		self.item3 = self.itemfont.render("and right shift for player 3.  Select a category with the", 1, white)
		self.item4 = self.itemfont.render("mouse or corresponding number or the keyboard.", 1, white)
		self.item5 = self.itemfont.render("Buzz in, and select an answer with a number key of mouse.", 1, white)
		
		#title rect
		self.titlerect = self.title.get_rect()
		self.titlerect.centerx = screen.get_rect().centerx
		self.titlerect.top += verticalborder
		#item rects
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		self.item4rect = self.item4.get_rect()
		self.item5rect = self.item5.get_rect()
		
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = self.item4rect.centerx = self.item5rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		self.item4rect.top = self.item3rect.top + itemspacing
		self.item5rect.top = self.item4rect.top + itemspacing
		
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.item4, self.item4rect)
		self.screen.blit(self.item5, self.item5rect)
		
class LoopHow:
	def __init__(self, screen, background):
		
		background.fill(black)
		screen.blit(background, (0,0))
		blah = MakeHow(screen, background)
		blah.drawscreen()
		pygame.display.flip()
		
		running = 1
		while (running == 1):
			for event in pygame.event.get():
				if event.type is KEYDOWN and event.key == K_ESCAPE:
					running = 0
				if event.type is QUIT:
					sys.exit()
	
			pygame.time.wait(10)