#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from local module scale
from scale import res

#colors
white = (255,255,255)
yellow = (251,254,0)
green = (0,254,17)
blue = (0,160,255)

#set some things according to resolution
titlefontsize = int(0.0825*res[0])
itemfontsize = int(0.0375*res[0])
title2fontsize = int(0.024*res[0])
titlespacing = int(0.03125*res[1])
itemspacing = int(0.0625*res[0])
deltax = int(.0625*res[0])

#initialize pygame
pygame.init()

#class that constructs the input settings screen
class MakeInputsettings:
	def __init__(self, screen, background):
		self.screen = screen; self.background = background
		
		#set fonts
		self.titlefont= pygame.font.Font('data/fonts/FreeSansBold.ttf', titlefontsize)
		self.title2font = pygame.font.Font('data/fonts/FreeSansBold.ttf', title2fontsize)
		self.itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)
		#create surfaces
		self.title = self.titlefont.render("Input Settings", 1, yellow)
		self.title2 = self.title2font.render("bind normal keys, like letters or punctuation, don't use shift, control etc", 1, (255,255,255))
		self.item1 = self.itemfont.render("Player 1 Buzzer", 1, white)
		self.item2 = self.itemfont.render("Player 2 Buzzer", 1, white)
		self.item3 = self.itemfont.render("Player 3 Buzzer", 1, white)
		#create the rects
		self.titlerect = self.title.get_rect()
		self.titlerect.centerx = screen.get_rect().centerx
		self.title2rect = self.title2.get_rect()
		self.title2rect.centerx = screen.get_rect().centerx
		self.title2rect.top = self.titlerect.bottom + titlespacing
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		#move the item rects to their proper spots
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
	
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.title2, self.title2rect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
	
	def drawselectionbox(self, boxcounter):
		self.selectionrect = self.item1rect
		self.selectionrect = self.selectionrect.move(0,0)
		background2 = pygame.Surface((self.item1rect.width, self.item1rect.height))
		background2.set_alpha(100)
		background2.fill(blue)
		self.selectionrect.y = self.selectionrect.y + itemspacing*(boxcounter - 1)
		self.screen.blit(background2, self.selectionrect)
		
	def drawsbind(self, boxcounter):
		#create selection rect
		self.selectionrect2 = self.item1rect.union(self.bind1rect)
		self.selectionrect2.width = self.selectionrect2.width + 24
		self.selectionrect2 = self.selectionrect2.move(0,0)
		#create surface to fill
		background3 = pygame.Surface((self.selectionrect2.width, self.selectionrect2.height))
		background3.set_alpha(100)
		background3.fill(yellow)
		#move selection rect and blit
		self.selectionrect2.top += itemspacing*(boxcounter - 1)
		self.screen.blit(background3, self.selectionrect2)
		
	def drawsettings(self, key1, key2, key3):
		#make surfaces
		self.bind1 = self.itemfont.render(key1, 1, green)
		self.bind2 = self.itemfont.render(key2, 1, green)
		self.bind3 = self.itemfont.render(key3, 1, green)
		#make rects
		self.bind1rect = self.bind1.get_rect()
		self.bind2rect = self.bind2.get_rect()
		self.bind3rect = self.bind3.get_rect()
		#set rect positions
		self.bind1rect.top = self.item1rect.top
		self.bind2rect.top = self.item2rect.top
		self.bind3rect.top = self.item3rect.top
		self.bind1rect.left = self.bind2rect.left = self.bind3rect.left = self.item1rect.right + deltax
		#blit 
		self.screen.blit(self.bind1, self.bind1rect)
		self.screen.blit(self.bind2, self.bind2rect)
		self.screen.blit(self.bind3, self.bind3rect)
		
class LoopInputsettings:
	def __init__(self, screen, background):
		
		mi = MakeInputsettings(screen, background)
		#mi.drawselectionbox(position)
		
		isfile = open('settings/input.txt', 'r')
		isfile .seek(0); a = isfile .readline(1)
		isfile .seek(1); b = isfile .readline(1)
		isfile .seek(2); c = isfile .readline(1)
		isfile .close()

		position = 1
		running= 1
		while (running == 1):
			screen.blit(background, (0,0))
			mi.drawselectionbox(position)
			mi.drawsettings(a, b, c)
			mi.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			#set mouse position
			mousepos = pygame.mouse.get_pos()
			if mousepos[0] > mi.item1rect.left and mousepos[0] < mi.item1rect.right:
				if mousepos[1] > mi.item1rect.y and  mousepos[1] < mi.item2rect.y:
					position = 1
				elif mousepos[1] > mi.item2rect.y and  mousepos[1] < mi.item3rect.y:
					position = 2
				elif mousepos[1] > mi.item3rect.y and  mousepos[1] < mi.item3rect.y + itemspacing:
					position = 3

			for event in pygame.event.get():
				if event.type is MOUSEBUTTONDOWN and mi.item1rect.left and mousepos[0] < mi.item1rect.right :
					screen.blit(background, (0,0))
					mi.drawsbind(position)
					mi.drawsettings(a, b, c)
					mi.drawscreen()
					pygame.display.flip()
					if position == 1:
						bindrunning = 1
						while bindrunning == 1:
							for event in pygame.event.get():
								if event.type is KEYUP:
									if event.key == K_ESCAPE: bindrunning = 0
								elif event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(0); isfile.write(newbind)
											
											isfile.seek(0); a = isfile.readline(1)
											isfile.seek(1); b = isfile.readline(1)
											isfile.seek(2); c = isfile.readline(1)
											if a == b:
												isfile.seek(1); isfile.write(" ")
											if a == c:
												isfile.seek(2); isfile.write(" ")
											isfile.close()
											bindrunning = 0
							pygame.time.delay(10)
							
					elif position == 2:
						bindrunning = 1
						while bindrunning == 1:
							for event in pygame.event.get():
								if event.type is KEYUP:
									if event.key == K_ESCAPE: bindrunning = 0
								elif event.type is KEYDOWN:
									newbind = pygame.key.name(event.key)
									if len(newbind) == 1:
										isfile = open('settings/input.txt', 'r+w')
										isfile.seek(1); isfile.write(newbind)
										
										isfile.seek(0); a = isfile.readline(1)
										isfile.seek(1); b = isfile.readline(1)
										isfile.seek(2); c = isfile.readline(1)		
										if b == a:
											isfile.seek(0); isfile.write(" ")
										if b == c:
											isfile.seek(2); isfile.write(" ")
										isfile.close()
										bindrunning = 0
							pygame.time.delay(10)
							
					elif position == 3:
							bindrunning = 1
							while bindrunning == 1:
								for event in pygame.event.get():
									if event.type is KEYUP:
										if event.key == K_ESCAPE:
											bindrunning = 0
									elif event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(2); isfile.write(newbind)
											
											isfile.seek(0); a = isfile.readline(1)
											isfile.seek(1); b = isfile.readline(1)
											isfile.seek(2); c = isfile.readline(1)
											if c == a:
												isfile.seek(0)
												isfile.write(" ")
											if c == b:
												isfile.seek(1)
												isfile.write(" ")
											isfile.close()
											bindrunning = 0
								pygame.time.delay(10)
								
				if event.type is KEYDOWN:
					if event.key == K_ESCAPE: running =  0
					elif event.key == K_UP:
						position -= 1
						if position < 1: position = 3
						else: pass
					elif event.key == K_DOWN:
						position += 1
						if position > 3: position = 1
						else: pass
					
					elif event.key == K_RETURN:
						screen.blit(background, (0,0))
						mi.drawsbind(position)
						mi.drawsettings(a, b, c)
						mi.drawscreen()
						pygame.display.flip()
						if position == 1:
							bindrunning = 1
							while bindrunning == 1:
								for event in pygame.event.get():
									if event.type is KEYUP:
										if event.key == K_ESCAPE:
											bindrunning = 0
									elif event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(0); isfile.write(newbind)
											
											isfile.seek(0); a = isfile.readline(1)
											isfile.seek(1); b = isfile.readline(1)
											isfile.seek(2); c = isfile.readline(1)
											if a == b:
												isfile.seek(1)
												isfile.write(" ")
											if a == c:
												isfile.seek(2)
												isfile.write(" ")
											isfile.close()
											bindrunning = 0
								pygame.time.wait(10)
								
						elif position == 2:
							bindrunning = 1
							while bindrunning == 1:
								for event in pygame.event.get():
									if event.type is KEYUP:
										if event.key == K_ESCAPE:
											bindrunning = 0
									elif event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(1); isfile.write(newbind)
											
											isfile.seek(0); a = isfile.readline(1)
											isfile.seek(1); b = isfile.readline(1)
											isfile.seek(2); c = isfile.readline(1)
											if b == a:
												isfile.seek(0)
												isfile.write(" ")
											if b == c:
												isfile.seek(2)
												isfile.write(" ")
											isfile.close()
											bindrunning = 0
								pygame.time.wait(10)
								
						elif position == 3:
							bindrunning = 1
							while bindrunning== 1:
								for event in pygame.event.get():
									if event.type is KEYUP:
										if event.key == K_ESCAPE:
											mehmeh = 0
									if event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(2); isfile.write(newbind)
											
											isfile.seek(0); a = isfile.readline(1)
											isfile.seek(1); b = isfile.readline(1)
											isfile.seek(2); c = isfile.readline(1)
											if c == a:
												isfile.seek(0)
												isfile.write(" ")
											if c == b:
												isfile.seek(1)
												isfile.write(" ")			
											isfile.close()
											bindrunning = 0
								pygame.time.wait(10)
						
				if event.type is QUIT:
					sys.exit()
					
				isfile = open('settings/input.txt', 'r')
				isfile.seek(0); a = isfile.readline(1)
				isfile.seek(1); b = isfile.readline(1)
				isfile.seek(2); c = isfile.readline(1)
				isfile.close()