#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import python modules
import os, sys, pygame, random, math
from pygame.locals import *

#import PySciTriv modules
from scale import res, menupic
from settings import LoopSettings
from how import MakeHow, LoopHow
from play import LoopPlay

#set some things according to resolution
menufontsize = int(0.0375*res[0])
verticalborder = int(0.03125*res[1])
itemspacing = int(0.1*res[1])

#colors
white = (255,255,255)
black = (0,0,0)
blue = (0,160,255)

#initialize pygame
pygame.init()

class MakeMenu:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#set font
		menufont = pygame.font.Font('data/fonts/FreeSansBold.ttf', menufontsize)
		#surfaces
		self.item1 = menufont.render("Start Game", 1, white)
		self.item2 = menufont.render("Settings", 1, white)
		self.item3 = menufont.render("How to Play", 1, white)
		self.item4 = menufont.render("Quit", 1, white)
		#rects
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		self.item4rect = self.item4.get_rect()
		#rect positions
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = self.item4rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		self.item4rect.top = self.item3rect.top + itemspacing
		#rect for logo
		self.menupicrect = menupic.get_rect()
		self.menupicrect.centerx = self.screen.get_rect().centerx
		self.menupicrect.top = self.menupicrect.top + verticalborder

	def drawscreen(self):
		self.screen.blit(menupic, self.menupicrect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.item4, self.item4rect)
		
	def drawselection(self, pos):
		self.selectionrect = self.item3.get_rect()
		self.selectionrect.top = self.item1rect.top
		self.selectionrect.left = self.item3rect.left
		background2 = pygame.Surface((self.selectionrect.width, self.selectionrect.height))
		background2.set_alpha(100)
		background2.fill(blue)
		#(pos - 1) because I'll have pos start at 1, not 0
		self.selectionrect.top += itemspacing*(pos - 1)
		self.screen.blit(background2, self.selectionrect)

class LoopMenu:
	def __init__(self, screen, background):
	
		mm = MakeMenu(screen, background)
		position = 1
		running = 1
		while (running == 1):
			background.fill(black)
			screen.blit(background, (0,0))
			mm.drawselection(position)
			mm.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[0] > mm.item3rect.left and mousepos[0] < mm.item3rect.right:
				if mousepos[1] > mm.item1rect.top and mousepos[1] < mm.item1rect.bottom:
					position = 1
				elif mousepos[1] > mm.item2rect.top and mousepos[1] < mm.item2rect.bottom:
					position = 2
				elif mousepos[1] > mm.item3rect.top and mousepos[1] < mm.item3rect.bottom:
					position = 3
				elif mousepos[1] > mm.item4rect.top and mousepos[1] < mm.item4rect.bottom:
					position = 4
				
			for event in pygame.event.get():
				if event.type is MOUSEBUTTONDOWN and mousepos[0] > mm.item3rect.left and mousepos[0] < mm.item3rect.right :
						if    position == 1: LoopPlay(screen,background)
						elif position == 2: LoopSettings(screen, background)
						elif position == 3: LoopHow(screen, background)
						elif position == 4: sys.exit()
							
				elif event.type is KEYDOWN:
					if event.key == K_ESCAPE: sys.exit()
					elif event.key == K_UP:
						position = position - 1
						if position < 1: position = 4
						else: pass
					elif event.key == K_DOWN:
						position = position + 1
						if position > 4: position = 1
						else: pass
					
					elif event.key == K_RETURN:
						if position == 1: LoopPlay(screen, background)
						elif position ==2: LoopSettings(screen, background)
						elif position ==3: LoopHow(screen, background)
						elif position == 4: sys.exit()
				elif event.type is QUIT: sys.exit()