#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import python modules
import os, sys, pygame, random, math
from pygame.locals import *

#add the PySciTrivia modules folder to be searched for modules
sys.path.append('data/questions/question_modules')

#import the question modules
from physics import question_p, choice1_p, choice2_p, choice3_p, choice4_p, answer_p, sound_p, qnum_p
from physics_history import question_ph, choice1_ph, choice2_ph, choice3_ph, choice4_ph, answer_ph, sound_ph, qnum_ph
from mathematics import question_m, choice1_m, choice2_m, choice3_m, choice4_m, answer_m, sound_m, qnum_m
from math_history import question_mh, choice1_mh, choice2_mh, choice3_mh, choice4_mh, answer_mh, sound_mh, qnum_mh
from chemistry import question_c, choice1_c, choice2_c, choice3_c, choice4_c, answer_c, sound_c, qnum_c
from chemistry_history import question_ch, choice1_ch, choice2_ch, choice3_ch, choice4_ch, answer_ch, sound_ch, qnum_ch
from astronomy import question_a, choice1_a, choice2_a, choice3_a, choice4_a, answer_a, sound_a, qnum_a
from astronomy_history import question_ah, choice1_ah, choice2_ah, choice3_ah, choice4_ah, answer_ah, sound_ah, qnum_ah
from biology import question_b, choice1_b, choice2_b, choice3_b, choice4_b, answer_b, sound_b, qnum_b
from biology_history import question_bh, choice1_bh, choice2_bh, choice3_bh, choice4_bh, answer_bh, sound_bh, qnum_bh
from compsci import question_cs, choice1_cs, choice2_cs, choice3_cs, choice4_cs, answer_cs, sound_cs, qnum_cs
from compsci_history import question_csh, choice1_csh, choice2_csh, choice3_csh, choice4_csh, answer_csh, sound_csh, qnum_csh
from techeng import question_te, choice1_te, choice2_te, choice3_te, choice4_te, answer_te, sound_te, qnum_te
from techeng_history import question_teh, choice1_teh, choice2_teh, choice3_teh, choice4_teh, answer_teh, sound_teh, qnum_teh
from earthsci import question_es, choice1_es, choice2_es, choice3_es, choice4_es, answer_es, sound_es, qnum_es
from earthsci_history import question_esh, 	choice1_esh, choice2_esh, choice3_esh, choice4_esh, answer_esh, sound_esh, qnum_esh
#medicine is going with technology and engineering for now
#from medicine import question_med, choice1_med, choice2_med, choice3_med, choice4_med, answer_med, sound_med, qnum_med
#from medicine_history import question_medh, choice1_medh, choice2_medh, choice3_medh, choice4_medh, answer_medh, sound_medh, qnum_medh

#initialize pygame
pygame.init()

#set the question depending on choice from category screen
class SetCategory:
	def __init__(self, choice):
		
		if choice == 0:
			self.question = question_p
			self.choice1 = choice1_p
			self.choice2 = choice2_p
			self.choice3 = choice3_p
			self.choice4 = choice4_p
			self.answer = answer_p
			self.qnum = qnum_p
			self.sound = sound_p
			
		elif choice == 1:
			self.question = question_ph
			self.choice1 = choice1_ph
			self.choice2 = choice2_ph
			self.choice3 = choice3_ph
			self.choice4 = choice4_ph
			self.answer = answer_ph
			self.qnum = qnum_ph
			self.sound = sound_ph
			
		elif choice == 2:
			self.question = question_m
			self.choice1 = choice1_m
			self.choice2 = choice2_m
			self.choice3 = choice3_m
			self.choice4 = choice4_m
			self.answer = answer_m
			self.qnum = qnum_m
			self.sound = sound_m
			
		elif choice == 3:
			self.question = question_mh
			self.choice1 = choice1_mh
			self.choice2 = choice2_mh
			self.choice3 = choice3_mh
			self.choice4 = choice4_mh
			self.answer = answer_mh
			self.qnum = qnum_mh
			self.sound = sound_mh
		
		elif choice == 4:
			self.question = question_c
			self.choice1 = choice1_c
			self.choice2 = choice2_c
			self.choice3 = choice3_c
			self.choice4 = choice4_c
			self.answer = answer_c
			self.qnum = qnum_c
			self.sound = sound_c
			
		elif choice == 5:
			self.question = question_ch
			self.choice1 = choice1_ch
			self.choice2 = choice2_ch
			self.choice3 = choice3_ch
			self.choice4 = choice4_ch
			self.answer = answer_ch
			self.qnum = qnum_ch
			self.sound = sound_ch
		
		elif choice == 6:
			self.question = question_a
			self.choice1 = choice1_a
			self.choice2 = choice2_a
			self.choice3 = choice3_a
			self.choice4 = choice4_a
			self.answer = answer_a
			self.qnum = qnum_a
			self.sound = sound_a
			
		elif choice == 7:
			self.question = question_ah
			self.choice1 = choice1_ah
			self.choice2 = choice2_ah
			self.choice3 = choice3_ah
			self.choice4 = choice4_ah
			self.answer = answer_ah
			self.qnum = qnum_ah
			self.sound = sound_ah
			
		elif choice == 8:
			self.question = question_b
			self.choice1 = choice1_b
			self.choice2 = choice2_b
			self.choice3 = choice3_b
			self.choice4 = choice4_b
			self.answer = answer_b
			self.qnum = qnum_b
			self.sound = sound_b
			
		elif choice == 9:
			self.question = question_bh
			self.choice1 = choice1_bh
			self.choice2 = choice2_bh
			self.choice3 = choice3_bh
			self.choice4 = choice4_bh
			self.answer = answer_bh
			self.qnum = qnum_bh
			self.sound = sound_bh
			
		elif choice == 10:
			self.question = question_cs
			self.choice1 = choice1_cs
			self.choice2 = choice2_cs
			self.choice3 = choice3_cs
			self.choice4 = choice4_cs
			self.answer = answer_cs
			self.qnum = qnum_cs
			self.sound = sound_cs
			
		elif choice == 11:
			self.question = question_csh
			self.choice1 = choice1_csh
			self.choice2 = choice2_csh
			self.choice3 = choice3_csh
			self.choice4 = choice4_csh
			self.answer = answer_csh
			self.qnum = qnum_csh
			self.sound = sound_csh
			
		elif choice == 12:
			self.question = question_te
			self.choice1 = choice1_te
			self.choice2 = choice2_te
			self.choice3 = choice3_te
			self.choice4 = choice4_te
			self.answer = answer_te
			self.qnum = qnum_te
			self.sound = sound_te
			
		elif choice == 13:
			self.question = question_teh
			self.choice1 = choice1_teh
			self.choice2 = choice2_teh
			self.choice3 = choice3_teh
			self.choice4 = choice4_teh
			self.answer = answer_teh
			self.qnum = qnum_teh
			self.sound = sound_teh
			
		elif choice == 14:
			self.question = question_es
			self.choice1 = choice1_es
			self.choice2 = choice2_es
			self.choice3 = choice3_es
			self.choice4 = choice4_es
			self.answer = answer_es
			self.qnum = qnum_es
			self.sound = sound_es
			
		elif choice == 15:
			self.question = question_esh
			self.choice1 = choice1_esh
			self.choice2 = choice2_esh
			self.choice3 = choice3_esh
			self.choice4 = choice4_esh
			self.answer = answer_esh
			self.qnum = qnum_esh
			self.sound = sound_esh
			
		#elif choice == 16:
			#self.question = question_med
			#self.choice1 = choice1_med
			#self.choice2 = choice2_med
			#self.choice3 = choice3_med
			#self.choice4 = choice4_med
			#self.answer = answer_med
			#self.qnum = qnum_med
			#self.sound = sound_med
			
		#elif choice == 17:
			#self.question = question_medh
			#self.choice1 = choice1_medh
			#self.choice2 = choice2_medh
			#self.choice3 = choice3_medh
			#self.choice4 = choice4_medh
			#self.answer = answer_medh
			#self.qnum = qnum_medh
			#self.sound = sound_medh
				
class SetQuestion:
	def __init__(self, choice):
		
		sc = SetCategory(choice)
		rq = random.randint(0, sc.qnum)
		self.question = sc.question[rq]
		self.choice1 = sc.choice1[rq]
		self.choice2 = sc.choice2[rq]
		self.choice3 = sc.choice3[rq]
		self.choice4 = sc.choice4[rq]
		self.answer = sc.answer[rq]
		self.sound = sc.sound[rq]
		
		
		