#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/ah/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_ah = 9

n = qnum_ah + 1 
question_ah = [0]*n
answer_ah = [0]*n
choice1_ah = [0]*n
choice2_ah = [0]*n
choice3_ah = [0]*n
choice4_ah = [0]*n
sound_ah = [0]*n


question_ah[0] = "Galileo Galilei was one of the first to study the stars with a telescope, in what year did he discover 4 of Jupiter's Moons?"
choice1_ah[0] = '1610'
choice2_ah[0] = '1510'
choice3_ah[0] = '1790'
choice4_ah[0] = '1490'
answer_ah[0] = 1
sound_ah[0] = checksound('ah000.ogg')

question_ah[1] = 'The Hubble Space Telescope was put into orbit during what year?'
choice1_ah[1] = '1975'
choice2_ah[1] = '1980'
choice3_ah[1] = '1990'
choice4_ah[1] = '1995'
answer_ah[1] = 3
sound_ah[1] = checksound('ah001.ogg')


question_ah[2] = 'Nicolaus Copenicus popularized the heliocentric system of our solar system in his book, "On the Revolutions of the Heavenly Spheres," also known as "De revolutionibus orbium coelestium" in latin, in what year?'
choice1_ah[2] = "1276"
choice2_ah[2] = "1444"
choice3_ah[2] = "1607"
choice4_ah[2] = "1543"
answer_ah[2] = 4
sound_ah[2] = checksound('ah002.ogg')

question_ah[3] = 'Who is credited for discovering the Crab Nebula in 1731?'
choice1_ah[3] = 'John Bevis'
choice2_ah[3] = 'Nicolaus Copernicus'
choice3_ah[3] = 'Tycho Brahe'
choice4_ah[3] = 'Thomas Digges'
answer_ah[3] = 1
sound_ah[3] = checksound('ah003.ogg')

question_ah[4] = 'Who co-discovered the first Kuiper belt object along with David Jewitt?'
choice1_ah[4] = 'Karen Jean Meech'
choice2_ah[4] = 'David Rabinowitz'
choice3_ah[4] = 'Jane Luu'
choice4_ah[4] = 'Neil DeGrasse Tyson'
answer_ah[4] = 3
sound_ah[4] = checksound('ah004.ogg')

question_ah[5] = 'Galileo observed this planet on multiple occasions, but merely believed it to be a distant star.  It was formally discovered about 200 years after this?  What planet is this?'
choice1_ah[5] = 'Jupiter'
choice2_ah[5] = 'Neptune'
choice3_ah[5] = 'Saturn'
choice4_ah[5] = 'Pluto'
answer_ah[5] = 2
sound_ah[5] = checksound('ah005.ogg')

question_ah[6] = 'Who is credited for having discovered Uranus?'
choice1_ah[6] = 'Galilei Gallileo'
choice2_ah[6] = 'Urbain Le Verriere'
choice3_ah[6] = 'Clyde W. Tombaugh'
choice4_ah[6] = 'William Herschel'
answer_ah[6] = 4
sound_ah[6] = checksound('ah006.ogg')

question_ah[7] = 'John Michell, an English scientist, is known mostly because of his paper published in 1784 about what? (the paper was discovered only recently in the 1970s)'
choice1_ah[7] = 'light affected by gravity'
choice2_ah[7] = 'universe expanding'
choice3_ah[7] = 'big bang'
choice4_ah[7] = 'heat death'
answer_ah[7] = 1
sound_ah[7] = checksound('ah007.ogg')

question_ah[8] = 'What German mathematician used the observations of Tycho Brahe to derive 3 famous laws of planetary montion?'
choice1_ah[8] = 'Maria Mitchell'
choice2_ah[8] = 'Issac Newton'
choice3_ah[8] = 'Johannes Kepler'
choice4_ah[8] = 'William Herschel'
answer_ah[8] = 3
sound_ah[8] = checksound('ah008.ogg')

question_ah[9] = 'Who is credited for having discover the aberration of light?'
choice1_ah[9] = 'Tycho Brahe'
choice2_ah[9] = 'James Bradley'
choice3_ah[9] = 'Robert Hooke'
choice4_ah[9] = 'Giovanni Cassini'
answer_ah[9] = 2
sound_ah[9] = checksound('ah009.ogg')

