#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

#unicode
sub_0 = u'\u2080'
sub_1 = u'\u2081'
sub_2 = u'\u2082'
sub_3 = u'\u2083'
sub_4 = u'\u2084'
sub_5 = u'\u2085'
sub_6 = u'\u2086'
sub_7 = u'\u2087'
sub_8 = u'\u2088'
sub_9 = u'\u2089'

path = "data/questions/voice/b/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_b = 9

n = qnum_b + 1
question_b = [0]*n
answer_b = [0]*n
choice1_b = [0]*n
choice2_b = [0]*n
choice3_b = [0]*n
choice4_b = [0]*n
sound_b = [0]*n

question_b[0] = 'What is often referred to as the "bulding block of life," the simpliest independant functioning organism.'
choice1_b[0] = "a cell"
choice2_b[0] = "a block"
choice3_b[0] = "a grid"
choice4_b[0] = "a protein"
answer_b[0] = 1
sound_b[0] = checksound("b000.ogg")

question_b[1] = "The process which uses light for energy for an organism, and in turn produces oxygen is called?"
choice1_b[1] = "epistasis"
choice2_b[1] = "catalysis"
choice3_b[1] = "dehydration synthesis"
choice4_b[1] = "photosynthesis"
answer_b[1] = 4
sound_b[1] = checksound("b001.ogg")

question_b[2] = "An enzyme is a/an?"
choice1_b[2] = "inhibitor"
choice2_b[2] = "catalyst"
choice3_b[2] = "substrate"
choice4_b[2] = "activator"
answer_b[2] = 2
sound_b[2] = checksound("b002.ogg")

question_b[3] = "Osmotic pressure exists when there is a different in what on both sides of a differentially permeable membrane?"
choice1_b[3] = "velocities of liquid"
choice2_b[3] = "depth"
choice3_b[3] = "solute concentration"
choice4_b[3] = "surface area"
answer_b[3] = 3
sound_b[3] = checksound("b003.ogg")

question_b[4] = "DNA stands for?"
choice1_b[4] = "DNA Not Acid"
choice2_b[4] = "Deoxyribonucleic acid"
choice3_b[4] = "Diverse Nature Arrangement"
choice4_b[4] = "it doesn't stand for anything"
answer_b[4] = 2
sound_b[4] = checksound("b004.ogg")

question_b[5] = "What is the process called when bacteria exchange genetic material through cell to cell contact?"
choice1_b[5] = "conjugation"
choice2_b[5] = "transpiration"
choice3_b[5] = "krebs cycle"
choice4_b[5] = "polymerization"
answer_b[5] = 1
sound_b[5] = checksound("b005.ogg")

question_b[6] = "What substance is the primary determinant in hair color?"
choice1_b[6] = "osteoblast"
choice2_b[6] = "melanin"
choice3_b[6] = "melanocyte"
choice4_b[6] = "trichomes"
answer_b[6] = 2
sound_b[6] = checksound("b006.ogg")

question_b[7] = "Stomach acid consists mostly of what?"
choice1_b[7] = "HNO" + sub_3
choice2_b[7] = "HI"
choice3_b[7] = "HCL"
choice4_b[7] = "HF"
answer_b[7] = 3
sound_b[7] = checksound("b007.ogg")

question_b[8] = "Fat has about how much energy per gram?"
choice1_b[8] = "38 kJ"
choice2_b[8] = "17 kJ"
choice3_b[8] = "20 kJ"
choice4_b[8] = "450 kJ"
answer_b[8] = 1
sound_b[8] = checksound("b008.ogg")

question_b[9] = "Fungus digest their food where?"
choice1_b[9] = "externally"
choice2_b[9] = "internally"
choice3_b[9] = "by an animal"
choice4_b[9] = "by another plant"
answer_b[9] = 1
sound_b[9] = checksound("b009.ogg")
