#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/cs/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_cs = 9

n = qnum_cs+1
question_cs = [0]*n
answer_cs = [0]*n
choice1_cs = [0]*n
choice2_cs = [0]*n
choice3_cs = [0]*n
choice4_cs = [0]*n
sound_cs = [0]*n


question_cs[0] = "A compiler usually does what?"
choice1_cs[0] = "sums a series of numbers"
choice2_cs[0] = "puts small files together"
choice3_cs[0] = "turns source code into machine code"
choice4_cs[0] = "none of the above"
answer_cs[0] = 3
sound_cs[0] = checksound("cs000.ogg")

question_cs[1] = "Linux is a?"
choice1_cs[1] = "operating system"
choice2_cs[1] = "kernel"
choice3_cs[1] = "desktop environment"
choice4_cs[1] = "all of the above"
answer_cs[1] = 2
sound_cs[1] = checksound("cs001.ogg")

question_cs[2] = "The most popular free operating system for desktop users currently is?"
choice1_cs[2] = "GNU/Linux"
choice2_cs[2] = "FreeBSD"
choice3_cs[2] = "GNU/Darwin"
choice4_cs[2] = "GNU/Hurd"
answer_cs[2] = 1
sound_cs[2] = checksound("cs002.ogg")

question_cs[3] = "In computer sciece, a string is usually?"
choice1_cs[3] = "a set of printable objects"
choice2_cs[3] = "a floating point value"
choice3_cs[3] = "an integer value"
choice4_cs[3] = "a boolean value"
answer_cs[3] = 1
sound_cs[3] = checksound("cs003.ogg")

question_cs[4] = "Statically typed programming languages require:"
choice1_cs[4] = "no object oriented programming"
choice2_cs[4] = "no user interaction"
choice3_cs[4] = "only integer calculations"
choice4_cs[4] = "datatypes to be specified"
answer_cs[4] = 4
sound_cs[4] = checksound("cs004.ogg")

question_cs[5] = "The dominant processor architecture created in use in desktop computers today created by Intel, is referred to as?"
choice1_cs[5] = "SPARC"
choice2_cs[5] = "PowerPC"
choice3_cs[5] = "x86"
choice4_cs[5] = "MIPS"
answer_cs[5] = 3
sound_cs[5] = checksound("cs005.ogg")

question_cs[6] = "In programming, a pointer is usually which of the following?"
choice1_cs[6] = "memory address"
choice2_cs[6] = "string"
choice3_cs[6] = "method"
choice4_cs[6] = "variable"
answer_cs[6] = 1
sound_cs[6] = checksound("cs006.ogg")

question_cs[7] = "At the start of every C/C++ program, this function must be called:"
choice1_cs[7] = "start()"
choice2_cs[7] = "main()"
choice3_cs[7] = "initialize()"
choice4_cs[7] = "run()"
answer_cs[7] = 2
sound_cs[7] = checksound("cs007.ogg")

question_cs[8] = "Binary code is often referred to as?"
choice1_cs[8] = "machine code"
choice2_cs[8] = "assembly"
choice3_cs[8] = "high level language"
choice4_cs[8] = "human code"
answer_cs[8] = 1
sound_cs[8] = checksound("cs008.ogg")

question_cs[9] = "Functions that are part of a class are usually referred to as a?"
choice1_cs[9] = "method"
choice2_cs[9] = "type"
choice3_cs[9] = "array"
choice4_cs[9] = "pointer"
answer_cs[9] = 1
sound_cs[9] = checksound("cs009.ogg")

