#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

pygame.init()

#unicode
sup_0 = u'\u2070'
sup_1 = u'\u00B9'
sup_2 = u'\u00B2'
sup_3 = u'\u00B3'
sup_4 = u'\u2074'
sup_5 = u'\u2075'
sup_6 = u'\u2076'
sup_7 = u'\u2077'
sup_8 = u'\u2078'
sup_9 = u'\u2079'
sup_plus = u'\u207A'
sup_minus = u'\u207B'

#function to check if soundfile exists
path = "data/questions/voice/p/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_p = 9

n = qnum_p + 1

question_p = [0]*n
answer_p = [0]*n
choice1_p = [0]*n
choice2_p = [0]*n
choice3_p = [0]*n
choice4_p = [0]*n
sound_p = [0]*n

question_p[0] = 'In classical mechanics, force is directly proportional to mass and?'
choice1_p[0] = 'energy'
choice2_p[0] = 'velocity'
choice3_p[0] = 'power'
choice4_p[0] = 'acceleration'
answer_p[0] = 4
sound_p[0] = checksound('p000.ogg')

question_p[1] = 'In thermodynamics, for an adiabatic process, which of the following is true?'
choice1_p[1] = 'pressure is constant'
choice2_p[1] = 'there is no change in heat'
choice3_p[1] = 'temperature is constant'
choice4_p[1] = 'volume doubles'
answer_p[1] = 2
sound_p[1] = checksound("p001.ogg")

question_p[2] = "Ohm's law shows that voltage is directly proportional to what?  Or other words, as voltage increases or decreases, what other quantity increases or decreases along with it?"
choice1_p[2] = 'only current'
choice2_p[2] = 'only resistance'
choice3_p[2] = 'current and resistance'
choice4_p[2] = 'nothing'
answer_p[2] = 3
sound_p[2] = checksound('p002.ogg')

question_p[3] = 'An elastic collision is a collision in which what is conserved?  Or in other words, what quantity is measured to be the same before and after the collision takes place?'
choice1_p[3] = 'kinetic energy'
choice2_p[3] = 'velocity'
choice3_p[3] = 'potential energy'
choice4_p[3] = 'momentum'
answer_p[3] = 1
sound_p[3] = checksound('p003.ogg')

question_p[4] = 'The universal gravitational constant, abbreviated G, is approximately equal to?'
choice1_p[4] = u'6.67 x 10' + sup_1 +sup_1 + ' Nm' + sup_2 + 'kg' + sup_minus + sup_2
choice2_p[4] = u'6.00 x 10'+ sup_1 +sup_1 + ' Nm' + sup_2 + 'kg' + sup_minus + sup_2
choice3_p[4] = u'2.67 x 10'+ sup_1 +sup_1 + ' Nm' + sup_2 + 'kg' + sup_minus + sup_2
choice4_p[4] = u'9.81' + ' Nm' + sup_2 + 'kg' + sup_minus + sup_2
answer_p[4] = 1
sound_p[4] = checksound("p004.ogg")

question_p[5] = "The speed of light is a constant, what is it's value?"
choice1_p[5] = '6 x 10' + sup_2 + sup_3 + ' m/s'
choice2_p[5] = '3 x 10' + sup_8 + ' m/s'
choice3_p[5] = '9.81 m/s'
choice4_p[5] = '4.2 x 10' + sup_8 + sup_5 + ' m/s'
answer_p[5] = 2
sound_p[5] = checksound('p005.ogg')

question_p[6] = "Consider these two postulates: 1) The laws of physics are the same in all inertial reference frames, and 2) the speed of light is constant.  They are the basis for what theory?"
choice1_p[6] = 'String Theory'
choice2_p[6] = 'Classical Electromagnetism'
choice3_p[6] = 'Quantum Mechanics'
choice4_p[6] = 'Special Relativity'
answer_p[6] = 4
sound_p[6] = checksound('p006.ogg')

question_p[7] = 'Torque is the cross product of what 2 vectors?'
choice1_p[7] = 'force and acceleration'
choice2_p[7] = 'force and velocity'
choice3_p[7] = 'force and radius from center'
choice4_p[7] = 'not a cross product'
answer_p[7] = 2
sound_p[7] = checksound('p007.ogg')

question_p[8] = 'If you push on a object with a mass of 100 kg, with a force of 5 N, how much work is done  on the object if it does not move? (ignore non-conservative things such as heat given off)'
choice1_p[8] = '500 J'
choice2_p[8] = '20 J'
choice3_p[8] = '0 J'
choice4_p[8] = 'infinite amount'
answer_p[8] = 3
sound_p[8] = checksound('p008.ogg')

question_p[9] = 'The gravitational constant for the earth near the surface: g, is the rate at which falling bodies accelerate towards the earth (ignoring air resistance).  What is its approximate value?'
choice1_p[9] = '9.81 m/s' + sup_2
choice2_p[9] = '1.5 m/s' + sup_2
choice3_p[9] = '50 m/s' + sup_2
choice4_p[9] = '3 x 10' + sup_8 + ' m/s' + sup_2
answer_p[9] = 1
sound_p[9] = checksound('p009.ogg')




