#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/te/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_te = 9
n = qnum_te+1

question_te = [0]*n
answer_te = [0]*n
choice1_te = [0]*n
choice2_te = [0]*n
choice3_te = [0]*n
choice4_te = [0]*n
sound_te = [0]*n

question_te[0] = "What is the name of the simple device that was used for navigation based upon the stars before the sextant?"
choice1_te[0] = "astrolabe"
choice2_te[0] = "astronomical compass"
choice3_te[0] = "planisphere"
choice4_te[0] = "antikythera mechanism"
answer_te[0] = 1
sound_te[0] = checksound("te000.ogg")

question_te[1] = "The Mach Number is equal to?"
choice1_te[1] = "medium's speed of sound / object's speed"
choice2_te[1] = "object's speed / medium's speed of sound"
choice3_te[1] = "object's speed / speed of light"
choice4_te[1] = "object's speed / 330 meters per second"
answer_te[1] = 2
sound_te[1] = checksound("te001.ogg")

question_te[2] = "Modern consumer destktop processor (as of 2005) have what magnitude of transistors?"
choice1_te[2] = "thousands"
choice2_te[2] = "hundreds"
choice3_te[2] = "millions"
choice4_te[2] = "tens"
answer_te[2] = 3
sound_te[2] = checksound("te002.ogg")

question_te[3] = "Microwave ovens use what type of device to create microwaves?"
choice1_te[3] = "transformer"
choice2_te[3] = "resistors"
choice3_te[3] = "cyclotron"
choice4_te[3] = "magentron"
answer_te[3] = 4
sound_te[3] = checksound("te003.ogg")

question_te[4] = "LCD displays take advantage of which of the following?"
choice1_te[4] = "light polarization"
choice2_te[4] = "humidity"
choice3_te[4] = "heat of vaporization"
choice4_te[4] = "vacuum tubes"
answer_te[4] = 1
sound_te[4] = checksound("te004.ogg")

question_te[5] = "The most efficient type of heat engine cycle possible is the:"
choice1_te[5] = "Brayton cycle"
choice2_te[5] = "Carnot cycle"
choice3_te[5] = "Otto cycle"
choice4_te[5] = "Ericsson cycle"
answer_te[5] = 2
sound_te[5] = checksound("te005.ogg")

question_te[6] = "What is the coefficient which tells you how much a material will compress with a given pressure applied to it?"
choice1_te[6] = "Poisson's ratio"
choice2_te[6] = "Young's modulus"
choice3_te[6] = "shear modulus"
choice4_te[6] = "bulk modulus"
answer_te[6] = 4
sound_te[6] = checksound("te006.ogg")

question_te[7] = "If you want to increase voltage using multiple batteries, how should you arrange them?"
choice1_te[7] = "in series"
choice2_te[7] = "in parallel"
choice3_te[7] = "add a resistor"
choice4_te[7] = "impossible"
answer_te[7] = 1
sound_te[7] = checksound("te007.ogg")

question_te[8] = "Seperating substances based on different in vapor pressures is known as?"
choice1_te[8] = "filtration"
choice2_te[8] = "transforming"
choice3_te[8] = "distillation"
choice4_te[8] = "diffusion"
answer_te[8] = 1
sound_te[8] = checksound("te008.ogg")

question_te[9] = "The SI unit of capacitance is the?"
choice1_te[9] = "cap"
choice2_te[9] = "farad"
choice3_te[9] = "ohm"
choice4_te[9] = "weber"
answer_te[9] = 2
sound_te[9] = checksound("te009.ogg")