#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/teh/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_teh = 9

n = qnum_teh+1
question_teh = [0]*n
answer_teh = [0]*n
choice1_teh = [0]*n
choice2_teh = [0]*n
choice3_teh = [0]*n
choice4_teh = [0]*n
sound_teh = [0]*n


question_teh[0] = 'Who developed 2 fundamental laws of circuit analysis, one being usually referred to as "junction rule" and the other "loop rule."'
choice1_teh[0] = "Gustav Kirchhoff"
choice2_teh[0] = "Georg Ohm"
choice3_teh[0] = "Michael Faraday"
choice4_teh[0] = "James Clerk Maxwell"
answer_teh[0] = 1
sound_teh[0] = checksound("teh000.ogg")

question_teh[1] = "The first Turing-Complete computer that used relays, called the Z3 was completed in Germany in what year?"
choice1_teh[1] = "1965"
choice2_teh[1] = "1955"
choice3_teh[1] = "1931"
choice4_teh[1] = "1941"
answer_teh[1] = 2
sound_teh[1] = checksound("teh001.ogg")

question_teh[2] = "In what year did the Wright Flyer sucessfully fly for a distance of about 35 meters?"
choice1_teh[2] = "1893"
choice2_teh[2] = "1920"
choice3_teh[2] = "1903"
choice4_teh[2] = "1880"
answer_teh[2] = 3
sound_teh[2] = checksound("teh002.ogg")

question_teh[3] = "The first reflecting telescope was designed by?"
choice1_teh[3] = "Galilei Galileo"
choice2_teh[3] = "Johannes Kepler"
choice3_teh[3] = "Issac Newton"
choice4_teh[3] = "James Gregory"
answer_teh[3] = 4
sound_teh[3] = checksound("teh003.ogg")

question_teh[4] = "John Bardeen, Walter H. Brattain, and William Shockley were awarded a Nobel prize in physics in 1956 for their discovery of?"
choice1_teh[4] = "the transistor effect"
choice2_teh[4] = "the photoelectric effect"
choice3_teh[4] = "doppler effect"
choice4_teh[4] = "Mossbauer effect"
answer_teh[4] = 1
sound_teh[4] = checksound("teh004.ogg")

question_teh[5] = "Boeing was founded in what year?"
choice1_teh[5] = "1930"
choice2_teh[5] = "1916"
choice3_teh[5] = "1945"
choice4_teh[5] = "1970"
answer_teh[5] = 2
sound_teh[5] = checksound("teh005.ogg")

question_teh[6] = "What state did the Star Dust probe land in?"
choice1_teh[6] = "Florida"
choice2_teh[6] = "Texas"
choice3_teh[6] = "California"
choice4_teh[6] = "Utah"
answer_teh[6] = 4
sound_teh[6] = checksound("teh006.ogg")

question_teh[7] = "Penicillin was discovered observed to be useful by Alexander Fleming in what year?"
choice1_teh[7] = "1903"
choice2_teh[7] = "1954"
choice3_teh[7] = "1928"
choice4_teh[7] = "1912"
answer_teh[7] = 3
sound_teh[7] = checksound("teh007.ogg")

question_teh[8] = "The first successful heart surgery was done in what year?"
choice1_teh[8] = "1896"
choice2_teh[8] = "1923"
choice3_teh[8] = "1768"
choice4_teh[8] = "1957"
answer_teh[8] = 1
sound_teh[8] = checksound("teh008.ogg")

question_teh[9] = "The first practical LED was developed by General Electric in what year?"
choice1_teh[9] = "1920"
choice2_teh[9] = "1962"
choice3_teh[9] = "1993"
choice4_teh[9] = "1975"
answer_teh[9] = 2
sound_teh[9] = checksound("teh009.ogg")