#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, cs, titlecolor, bgcolor, itemcolor, item2color, boxcolor, alpha, titlefont, itemfont, titleborder, itemspacing
import scale

class MakeGamesettings:
	def __init__(self, screen, background, pnum, numr, nums, cr):
		self.screen = screen; self.background = background
		
		if numr == "0":
			rounds = "No Limit"
		else:
			rounds = str(int(numr)*5)
			
		if nums == "0":
			score = "No Limit"
		else:
			score = str(int(nums)*6)
		
		#make surfaces
		if cs == 2:
			self.title = scale.gs_header
		else:
			self.title = titlefont.render("Game Settings", 1, titlecolor)
		self.item1 = itemfont.render("Number of Players", 1, item2color)
		self.item2 = itemfont.render(pnum, 1, itemcolor)
		
		self.item3 = itemfont.render("Round Limit", 1, item2color)
		self.item4 = itemfont.render(rounds, 1, itemcolor)
		
		self.item5 = itemfont.render("Score Limit", 1, item2color)
		self.item6 = itemfont.render(score, 1, itemcolor)
		
		#self.item7 = itemfont.render("Color Theme (restart game to take effect)", 1, item2color)
		#self.item8 = itemfont.render(color, 1, itemcolor)
		
		#make rects
		self.titlerect = self.title.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		self.item4rect = self.item4.get_rect()
		self.item5rect = self.item5.get_rect()
		self.item6rect = self.item6.get_rect()
		#self.item7rect = self.item7.get_rect()
		#self.item8rect = self.item8.get_rect()
		#move rects
		self.titlerect.centerx = self.screen.get_rect().centerx
		
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = self.item4rect.centerx = self.screen.get_rect().centerx
		self.item5rect.centerx = self.item6rect.centerx = self.screen.get_rect().centerx
		#self.item7rect.centerx = self.item8rect.centerx = self.screen.get_rect().centerx
		self.item1rect.top = self.titlerect.top + titleborder*25
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		self.item4rect.top = self.item3rect.top + itemspacing
		self.item5rect.top = self.item4rect.top + itemspacing
		self.item6rect.top = self.item5rect.top + itemspacing
		#self.item7rect.top = self.item6rect.top + itemspacing
		#self.item8rect.top = self.item7rect.top + itemspacing
	
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.item4, self.item4rect)
		self.screen.blit(self.item5, self.item5rect)
		self.screen.blit(self.item6, self.item6rect)
		#self.screen.blit(self.item7, self.item7rect)
		#self.screen.blit(self.item8, self.item8rect)
	
	def drawselection(self, pos):

		self.selectionbox = self.item2.get_rect()
		self.selectionbox.width *= 10
		background2 = pygame.Surface((self.selectionbox.width, self.selectionbox.height))
		background2.set_alpha(alpha)
		background2.fill(boxcolor)
		self.selectionbox.center = self.item2rect.center
		self.selectionbox.top += itemspacing*(pos-2)
		
		self.screen.blit(background2, self.selectionbox)
		
class LoopGamesettings:
	def __init__(self, screen, background):
		
		gsfile = open('settings/game.txt', 'r')
		gsfile.seek(0)
		numplayers = gsfile.readline(1)
		
		gsfile.seek(1)
		numrounds = gsfile.readline(1)
		
		gsfile.seek(2)
		numscore = gsfile.readline(1)
		
		gsfile.seek(3)
		colortheme = gsfile.readline(1)
		gsfile.close()
		
		mg = MakeGamesettings(screen, background, numplayers, numrounds, numscore, colortheme)
		
		pos = 2
		running = 1
		while running == 1:
			background.fill(bgcolor)
			screen.blit(background, (0,0))
			mg.drawselection(pos)
			mg.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[0] > mg.item1rect.left and mousepos[0] < mg.item1rect.right:
				if mousepos[1] > mg.item2rect.top and mousepos[1] < mg.item2rect.bottom:
					pos = 2
				if mousepos[1] > mg.item3rect.top and mousepos[1] < mg.item4rect.bottom:
					pos = 4
				if mousepos[1] > mg.item5rect.top and mousepos[1] < mg.item6rect.bottom:
					pos = 6
				#if mousepos[1] > mg.item7rect.top and mousepos[1] < mg.item8rect.bottom:
					#position = 8
				
			for event in pygame.event.get():
				if event.type is MOUSEBUTTONDOWN:
					if pos == 2:
						gsfile = open('settings/game.txt', 'r+w')
						gsfile.seek(0)
						if numplayers == "1": gsfile.write("2")
						elif numplayers == "2": gsfile.write("3")
						elif numplayers == "3": gsfile.write("1")
						gsfile.close()
						
					if pos == 4:
						gsfile = open('settings/game.txt', 'r+w')
						gsfile.seek(1)
						if numrounds == "1": gsfile.write("2")
						elif numrounds == "2": gsfile.write("3")
						elif numrounds == "3": gsfile.write("4")
						elif numrounds == "4": gsfile.write("5")
						elif numrounds == "5": gsfile.write("6")
						elif numrounds == "6": gsfile.write("0")
						elif numrounds == "0": gsfile.write("1")
						gsfile.close()
						
					if pos == 6:
						gsfile = open('settings/game.txt', 'r+w')
						gsfile.seek(2)
						if numscore == "1": gsfile.write("2")
						elif numscore == "2": gsfile.write("3")
						elif numscore== "3": gsfile.write("4")
						elif numscore == "4": gsfile.write("5")
						elif numscore == "5": gsfile.write("6")
						elif numscore == "6": gsfile.write("0")
						elif numscore == "0": gsfile.write("1")
						gsfile.close()
						
					if pos == 8:
						gsfile = open('settings/game.txt', 'r+w')
						gsfile.seek(3)
						if colortheme == "1": gsfile.write("2")
						elif colortheme == "2": gsfile.write("3")
						elif colortheme == "3": gsfile.write("1")
						gsfile.close()
				
				if event.type is KEYDOWN :

					if event.key == K_ESCAPE:
						running = 0
				
				if event.type is QUIT:
					sys.exit()
				
			gsfile = open('settings/game.txt', 'r')
			gsfile.seek(0)
			numplayers = gsfile.readline(1)
			
			gsfile.seek(1)
			numrounds = gsfile.readline(1)
			
			gsfile.seek(2)
			numscore = gsfile.readline(1)
			
			gsfile.seek(3)
			colortheme = gsfile.readline(1)
			
			gsfile.close()
			mg = MakeGamesettings(screen, background, numplayers, numrounds, numscore, colortheme)