#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, cs, bgcolor, titlecolor, itemcolor, titlefont, itemfont, itemspacing, titleborder
import scale

class MakeHow:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#create surfaces
		
		if cs == 2:
			self.title = scale.how_header
		else:
			self.title = titlefont.render("How To Play", 1, titlecolor)
		self.item1 = itemfont.render("You can bind custom buzzers, and/or", 1, itemcolor)
		self.item2 = itemfont.render("use these default buzzers:", 1, itemcolor)
		self.item3 = itemfont.render("Player 1: Left Shift", 1, itemcolor)
		self.item4 = itemfont.render("Player 2: Space Bar", 1, itemcolor)
		self.item5 = itemfont.render("Player 3: Right Shift", 1, itemcolor)
		
		#title rect
		self.titlerect = self.title.get_rect()
		self.titlerect.centerx = screen.get_rect().centerx

		#item rects
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		self.item4rect = self.item4.get_rect()
		self.item5rect = self.item5.get_rect()
		
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = self.item4rect.centerx = self.item5rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery - itemspacing
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		self.item4rect.top = self.item3rect.top + itemspacing
		self.item5rect.top = self.item4rect.top + itemspacing
		
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.item4, self.item4rect)
		self.screen.blit(self.item5, self.item5rect)
		
class LoopHow:
	def __init__(self, screen, background):
		
		background.fill(bgcolor)
		screen.blit(background, (0,0))
		blah = MakeHow(screen, background)
		blah.drawscreen()
		pygame.display.flip()
		
		running = 1
		while (running == 1):
			for event in pygame.event.get():
				if event.type is KEYDOWN and event.key == K_ESCAPE:
					running = 0
				if event.type is QUIT:
					sys.exit()
	
			pygame.time.wait(10)