#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, cs, logo, bgcolor, boxcolor, itemcolor, alpha, itemfont, verticalborder, itemspacing
from settings import LoopSettings
from how import MakeHow, LoopHow
from play import LoopPlay

class MakeMenu:
	def __init__(self, screen, background):
		self.screen = screen; self.background = background
	
		#create surfaces
		self.item1 = itemfont.render("Start Game", 1, itemcolor)
		self.item2 = itemfont.render("Settings", 1, itemcolor)
		self.item3 = itemfont.render("How to Play", 1, itemcolor)
		self.item4 = itemfont.render("Quit", 1, itemcolor)
		#create rects
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		self.item4rect = self.item4.get_rect()
		self.menupicrect = logo.get_rect()
		#move rects
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = self.item4rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		self.item4rect.top = self.item3rect.top + itemspacing
		self.menupicrect.centerx = self.screen.get_rect().centerx
		self.menupicrect.top = self.menupicrect.top + verticalborder

	def drawscreen(self):
		self.screen.blit(logo, self.menupicrect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.item4, self.item4rect)
		
	def drawselection(self, pos):
		self.srect = self.item3.get_rect()
		self.srect.width *= 1.2
		self.srect.top = self.item1rect.top
		self.srect.centerx = self.item3rect.centerx
		self.srect.top += itemspacing*(pos - 1)
		
		background2 = pygame.Surface((self.srect.w, self.srect.h))
		background2.set_alpha(alpha)
		background2.fill(boxcolor)

		self.screen.blit(background2, self.srect)

class LoopMenu:
	def __init__(self, screen, background):
	
		mm = MakeMenu(screen, background)
		pos = 1
		running = 1
		while (running == 1):
			background.fill(bgcolor)
			screen.blit(background, (0,0))
			mm.drawselection(pos)
			mm.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > mm.item1rect.top and mousepos[1] < mm.item1rect.bottom:
				pos = 1
			elif mousepos[1] > mm.item2rect.top and mousepos[1] < mm.item2rect.bottom:
				pos = 2
			elif mousepos[1] > mm.item3rect.top and mousepos[1] < mm.item3rect.bottom:
				pos = 3
			elif mousepos[1] > mm.item4rect.top and mousepos[1] < mm.item4rect.bottom:
				pos = 4
				
			for event in pygame.event.get():
				if event.type is MOUSEBUTTONDOWN:
					if pos == 1: LoopPlay(screen,background)
					elif pos == 2: LoopSettings(screen, background)
					elif pos == 3: LoopHow(screen, background)
					elif pos == 4: sys.exit()
							
				elif event.type is KEYDOWN:
					if event.key == K_ESCAPE: 
						sys.exit()
						
				elif event.type is QUIT: 
					sys.exit()