#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

#needed for font initialization
pygame.init()

vidfile = open('settings/video.txt', 'r')
vidfile.seek(0)
a = int(vidfile.readline(1))
vidfile.seek(1)
b = int(vidfile.readline(1))
vidfile.seek(2)
cs = int(vidfile.readline(1))
vidfile.close()	

#PST dark color theme
if cs == 1:
	fontpath = 'data/fonts/freesansbold/FreeSansBold.ttf'
	
	bgcolor = (0,0,0)
	titlecolor = (251,254,0)
	title2color = (0,254,17)
	boxcolor = (0,160,255)
	itemcolor = (255,255,255)
	item2color = (0,254,17)
	box2color = (0,254,17)
	correctcolor = (0,255,255)
	wrongcolor = (255,0,0)
	numcolor = (0,254,17)
	shcolor = (251,254,0)
	alpha = 100
	whocolor = (0,254,17)
	
	if a == 1:
		logo = pygame.image.load('data/graphics/pst_dark/logo_800x600_border.png')
		res = (800, 600)
	elif a == 2:
		logo = pygame.image.load('data/graphics/pst_dark/logo_1024x768_border.png')
		res = (1024, 768)
	else:
		logo = pygame.image.load('data/graphics/pst_dark/logo_640x480_border.png')
		res = (640, 480)
	itemfontsize = int(0.0375*res[0])
	itemfont = pygame.font.Font(fontpath, itemfontsize)
	titlefontsize = int(0.09*res[0])
	titlefont = pygame.font.Font(fontpath, titlefontsize)
	winfontsize = int(0.075*res[0])
	winfont = pygame.font.Font(fontpath, winfontsize)
	numfontsize = int(0.04*res[0])
	numfont = pygame.font.Font(fontpath, numfontsize)
	title2fontsize = int(0.024*res[0])
	title2font = pygame.font.Font(fontpath, title2fontsize)
	scorefontsize = int(0.03*res[0])
	scorefont = pygame.font.Font(fontpath, scorefontsize)
	questionfontsize = int(.0325*res[0])
	questionfont = pygame.font.Font(fontpath, questionfontsize)
	
	titleborder =  int(0.0125*res[1])
	verticalborder = int(0.03125*res[1])
	itemspacing = int(0.1*res[1])

#PST light color theme
elif cs == 2:
	fontpath = 'data/fonts/freesansbold/FreeSansBold.ttf'
	bgcolor = (0,204,255)
	titlecolor = (255,251,0)
	title2color = (255,255,255)
	boxcolor = (255,251,0)
	itemcolor = (0,0,0)
	item2color = (255,255,255)
	box2color = (255,255,255)
	correctcolor = (0,255,255)
	wrongcolor = (255,0,0)
	numcolor = (0,254,17)
	shcolor = (255,255,255)
	alpha = 255
	whocolor = (255,255,255)
	
	
	
	if a == 1:
		logo = pygame.image.load('data/graphics/pst_light/logo_800x600.png')
		res = (800, 600)
		settings_header = pygame.image.load('data/graphics/pst_light/settings_med.png')
		gs_header = pygame.image.load('data/graphics/pst_light/gs_med.png')
		vs_header = pygame.image.load('data/graphics/pst_light/vs_med.png')
		is_header = pygame.image.load('data/graphics/pst_light/is_med.png')
		how_header = pygame.image.load('data/graphics/pst_light/how_med.png')
		pick_header = pygame.image.load('data/graphics/pst_light/pick_med.png')
		
		
	elif a == 2:
		logo = pygame.image.load('data/graphics/pst_light/logo_1024x768.png')
		res = (1024, 768)
		settings_header = pygame.image.load('data/graphics/pst_light/settings_big.png')
		gs_header = pygame.image.load('data/graphics/pst_light/gs_big.png')
		vs_header = pygame.image.load('data/graphics/pst_light/vs_big.png')
		is_header = pygame.image.load('data/graphics/pst_light/is_big.png')
		how_header = pygame.image.load('data/graphics/pst_light/how_big.png')
		pick_header = pygame.image.load('data/graphics/pst_light/pick_big.png')
		
	else:
		logo = pygame.image.load('data/graphics/pst_light/logo_640x480.png')
		res = (640, 480)
		
		settings_header = pygame.image.load('data/graphics/pst_light/settings_small.png')
		gs_header = pygame.image.load('data/graphics/pst_light/gs_small.png')
		vs_header = pygame.image.load('data/graphics/pst_light/vs_small.png')
		is_header = pygame.image.load('data/graphics/pst_light/is_small.png')
		how_header = pygame.image.load('data/graphics/pst_light/how_small.png')
		pick_header = pygame.image.load('data/graphics/pst_light/pick_small.png')
	itemfontsize = int(0.0375*res[0])
	itemfont = pygame.font.Font(fontpath, itemfontsize)
	titlefontsize = int(0.09*res[0])
	titlefont = pygame.font.Font(fontpath, titlefontsize)
	winfontsize = int(0.075*res[0])
	winfont = pygame.font.Font(fontpath, winfontsize)
	numfontsize = int(0.04*res[0])
	numfont = pygame.font.Font(fontpath, numfontsize)
	title2fontsize = int(0.024*res[0])
	title2font = pygame.font.Font(fontpath, title2fontsize)
	scorefontsize = int(0.03*res[0])
	scorefont = pygame.font.Font(fontpath, scorefontsize)
	questionfontsize = int(.0325*res[0])
	questionfont = pygame.font.Font(fontpath, questionfontsize)
	
	titleborder =  int(0.0125*res[1])
	verticalborder = int(0.03125*res[1])
	itemspacing = int(0.1*res[1])
	
#FSF color theme	
elif cs == 3:
	fontpath = 'data/fonts/freesans/FreeSans_negexp.ttf'
	titlecolor = (115,0,0)
	title2color = (0,0,0)
	boxcolor = (115,115,115)
	itemcolor = (0,0,0)
	item2color = (115,0,0)
	box2color = (115,0,0)
	correctcolor = (0,255,0)
	wrongcolor = (200,0,0)
	numcolor = (115,0,0)
	shcolor = (115,0,0)
	alpha = 150
	whocolor = (100,100,100)
	bgcolor = (255,255,255)
	
	if a == 1:
		res = (800, 600)
	elif a == 2:
		res = (1024, 768)
	else:
		res = (640, 480)
	logocolor = (115,0,0)
	logofontsize = int(res[0]*.15)
	logofont = pygame.font.Font(fontpath, logofontsize)
	logo = logofont.render("PySciTrivia", 1, logocolor)
	
	itemfontsize = int(0.04*res[0])
	itemfont = pygame.font.Font(fontpath, itemfontsize)
	titlefontsize = int(0.12*res[0])
	titlefont = pygame.font.Font(fontpath, titlefontsize)
	winfontsize = int(0.09*res[0])
	winfont = pygame.font.Font(fontpath, winfontsize)
	numfontsize = int(0.04*res[0])
	numfont = pygame.font.Font(fontpath, numfontsize)
	title2fontsize = int(0.024*res[0])
	title2font = pygame.font.Font(fontpath, title2fontsize)
	scorefontsize = int(0.03*res[0])
	scorefont = pygame.font.Font(fontpath, scorefontsize)
	questionfontsize = int(.0325*res[0])
	questionfont = pygame.font.Font(fontpath, questionfontsize)
	
	titleborder =  int(0.0125*res[1])
	verticalborder = int(0.03125*res[1])
	itemspacing = int(0.1*res[1])
	
#FSF Europe color theme	
else:
	#fontpath = 'data/fonts/dejavu/DejaVuSans.ttf'
	fontpath = 'data/fonts/freesans/FreeSans_negexp.ttf'
	bgcolor = (255,255,255)
	titlecolor = (0,56,154)
	title2color = (0,0,0)
	boxcolor = (0,56,154)
	itemcolor = (0,0,0)
	item2color = (0,56,154)
	box2color = (155,155,155)
	correctcolor = (0,255,0)
	wrongcolor = (200,0,0)
	numcolor = (0,56,154)
	shcolor = (0,56,154)
	alpha = 100
	whocolor = (0,0,0)
	
	if a == 1:
		res = (800, 600)
	elif a == 2:
		res = (1024, 768)
	else:
		res = (640, 480)
	logocolor = (0,56,154)
	logofontsize = int(res[0]*.15)
	logofont = pygame.font.Font(fontpath, logofontsize)
	logo = logofont.render("PySciTrivia", 1, logocolor)
	
	itemfontsize = int(0.04*res[0])
	itemfont = pygame.font.Font(fontpath, itemfontsize)
	titlefontsize = int(0.12*res[0])
	titlefont = pygame.font.Font(fontpath, titlefontsize)
	winfontsize = int(0.08*res[0])
	winfont = pygame.font.Font(fontpath, winfontsize)
	numfontsize = int(0.04*res[0])
	numfont = pygame.font.Font(fontpath, numfontsize)
	title2fontsize = int(0.024*res[0])
	title2font = pygame.font.Font(fontpath, title2fontsize)
	scorefontsize = int(0.03*res[0])
	scorefont = pygame.font.Font(fontpath, scorefontsize)
	questionfontsize = int(.0325*res[0])
	questionfont = pygame.font.Font(fontpath, questionfontsize)
	
	titleborder =  int(0.0125*res[1])
	verticalborder = int(0.03125*res[1])
	itemspacing = int(0.1*res[1])
	
		
#sets windowed or fullscreen
if b == 1:
	windowset = pygame.display.set_mode(res, FULLSCREEN)
else:
	windowset = pygame.display.set_mode(res)