#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, cs, titleborder, itemfont, itemspacing
from scale import titlefont
from scale import bgcolor, titlecolor, boxcolor, itemcolor, alpha
import scale
from inputsettings import MakeInputsettings, LoopInputsettings
from videosettings import MakeVideosettings, LoopVideosettings
from gamesettings import MakeGamesettings, LoopGamesettings

class MakeSettings:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
	
		#create surfaces
		if cs == 2:
			self.title = scale.settings_header
		else:
			self.title = titlefont.render("Settings", 1, titlecolor)	
		self.item1 = itemfont.render("Video Settings", 1, itemcolor)
		self.item2 = itemfont.render("Game Settings", 1, itemcolor)
		self.item3 = itemfont.render("Input Settings", 1, itemcolor)
		
		#create rects
		self.titlerect = self.title.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect= self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		#move rects
		self.titlerect.centerx = screen.get_rect().centerx
		self.titlerect.top += titleborder
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx =  screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top= self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		
	def drawselection(self, pos):
		self.selectionrect = self.item2.get_rect()
		self.selectionrect.width *= 1.2
		self.selectionrect.centerx = self.screen.get_rect().centerx
		self.selectionrect.top = self.item1rect.top
		background2 = pygame.Surface((self.selectionrect.width, self.selectionrect.height))
		background2.set_alpha(alpha)
		background2.fill(boxcolor)
		self.selectionrect.top += itemspacing*(pos-1)
		self.screen.blit(background2, self.selectionrect)
		
class LoopSettings:
	def __init__(self, screen, background):
		pos = 1
		ms = MakeSettings(screen, background)
		
		running= 1
		while (running == 1):
			background.fill(bgcolor)
			screen.blit(background, (0,0))
			ms.drawselection(pos)
			ms.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > ms.item1rect.y and mousepos[1] < ms.item2rect.y:
				pos = 1
			elif mousepos[1] > ms.item2rect.y and mousepos[1] < ms.item3rect.y:
				pos = 2
			elif mousepos[1] > ms.item3rect.top and mousepos[1] < ms.item3rect.bottom:
				pos  = 3
					
			for event in pygame.event.get():
				if event.type is QUIT:
					sys.exit()
				elif event.type is MOUSEBUTTONDOWN:
						if pos == 1: LoopVideosettings(screen, background)
						elif pos ==2: LoopGamesettings(screen, background)
						elif pos ==3: LoopInputsettings(screen, background)
							
				elif event.type is KEYDOWN:
					if event.key == K_ESCAPE: 
						running = 0