#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, itemcolor

#set things according to resolution
maxwidth = res[0] - (.0625*res[0])

class TextWrap:
	def __init__(self, screen, background, q1, qfont):
		space = " "
		self.screen = screen
		self.background = background
		self.q1 = q1
		self.qfont = qfont
		
		#make empty lists of length 0 for lines above 1, so I can test whether or not
		#if more lines are needed, max 6 lines for now
		self.q2 = []
		self.q3 = []
		self.q4 = []
		self.q5 = []
		self.q6 = []
		
		#the split() breaks the string up at every space, I then count the number of pieces
		#that are in the list split() made with len(), then I test the rect width corresponding to the string
		#to see if it's width is bigger than the max width I want, if so, subtract one piece from the list
		#the split makes each time in the loop, I do this by using join(), which joins at every space, if string's rect width
		#becomes smaller than the max width, the loop will stop, and we move on to test the left over
		#parts that were cut off from the string already, we repeat this as we need to get the text to wrap
		#I feel like this is a crappy way to do it, but it works for now, sorry for this huge ass comment
		self.line1 = self.qfont.render(self.q1, 1, itemcolor)
		self.line1rect = self.line1.get_rect()
		self.q1split = self.q1.split()
		self.line1len = len(self.q1split)
		while self.line1rect.width > maxwidth:
			self.q1 = space.join(self.q1split[:self.line1len])
			self.q2 = space.join(self.q1split[self.line1len:])
			self.line1len = self.line1len - 1
			self.line1 = self.qfont.render(self.q1, 1, itemcolor)
			self.line1rect = self.line1.get_rect()
		
		#test if line 2 is needed
		if len(self.q2) >= 1:
			self.line2 = self.qfont.render(self.q2, 1, itemcolor)
			self.line2rect =  self.line2.get_rect()
			self.q2split = self.q2.split()
			self.line2len = len(self.q2split)
			while self.line2rect.width > maxwidth:
				self.q2 = space.join(self.q2split[:self.line2len])
				self.q3 = space.join(self.q2split[self.line2len:])
				self.line2len = self.line2len - 1
				self.line2 = self.qfont.render(self.q2, 1, itemcolor)
				self.line2rect = self.line2.get_rect()
		else: pass
	
		#test if line 3 is needed
		if len(self.q3) >= 1:
			self.line3 = self.qfont.render(self.q3, 1, itemcolor)
			self.line3rect =  self.line3.get_rect()
			self.q3split = self.q3.split()
			self.line3len = len(self.q3split)
			while self.line3rect.width > maxwidth:
				self.q3 = space.join(self.q3split[:self.line3len])
				self.q4 = space.join(self.q3split[self.line3len:])
				self.line3len = self.line3len - 1
				self.line3 = self.qfont.render(self.q3, 1, itemcolor)
				self.line3rect = self.line3.get_rect()
		else: pass
	
		#test if line 4 is needed
		if len(self.q4) >= 1:
			self.line4 = self.qfont.render(self.q4, 1, itemcolor)
			self.line4rect =  self.line4.get_rect()
			self.q4split = self.q4.split()
			self.line4len = len(self.q4split)
			while self.line4rect.width > maxwidth:
				self.q4 = space.join(self.q4split[:self.line4len])
				self.q5 = space.join(self.q4split[self.line4len:])
				self.line4len = self.line4len - 1
				self.line4 = self.qfont.render(self.q4, 1, itemcolor)
				self.line4rect = self.line4.get_rect()
		else: pass
	
		#test if line 5 is needed
		if len(self.q5) >= 1:
			self.line5 = self.qfont.render(self.q5, 1, itemcolor)
			self.line5rect =  self.line5.get_rect()
			self.q5split = self.q5.split()
			self.line5len = len(self.q5split)
			while self.line5rect.width > maxwidth:
				self.q5 = space.join(self.q5split[:self.line5len])
				self.q6 = space.join(self.q5split[self.line5len:])
				self.line5len = self.line5len - 1
				self.line5 = self.qfont.render(self.q5, 1, itemcolor)
				self.line5rect = self.line5.get_rect()
		else: pass
	
		#test if line 6 is needed, right now might run into other text
		if len(self.q6) >= 1:
			self.line6 = self.qfont.render(self.q6, 1, itemcolor)
			self.line6rect =  self.line6.get_rect()
			self.q6split = self.q6.split()
			self.line6len = len(self.q6split)
			while self.line6rect.width > maxwidth:
				self.q6 = space.join(self.q6split[:self.line6len])
				self.q7 = space.join(self.q6split[self.line6len:])
				self.line6len = self.line6len - 1
				self.line6 = self.qfont.render(self.q6, 1, itemcolor)
				self.line6rect = self.line6.get_rect()
		else: pass
		
		
		