#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, cs, bgcolor, titlecolor, itemcolor, boxcolor, item2color, alpha, title2color, titlefont, itemfont, title2font, itemspacing, titleborder
import scale

#set some things according to resolution
delta = int(res[1]*.1)

class MakeVideosettings:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#make surfaces
		if cs == 2:
			self.title = scale.vs_header
		else:
			self.title = titlefont.render("Video Settings", 1, titlecolor)
		self.item1 = itemfont.render("Resolution", 1, item2color)
		self.item2 = itemfont.render("Fullscreen", 1, item2color)
		self.item3 = itemfont.render("Color Theme", 1, item2color)
		
		self.title2 = title2font.render("Restart PySciTrivia for changes to take effect", 1, title2color)
		#make rects
		self.titlerect = self.title.get_rect()
		self.title2rect = self.title2.get_rect()
		self.item1rect 	= self.item1.get_rect()
		self.item2rect 	= self.item2.get_rect()
		self.item3rect 	= self.item3.get_rect()
		#move rects
		self.titlerect.centerx = self.title2rect.centerx = screen.get_rect().centerx
		self.title2rect.top = self.titlerect.bottom + titleborder
		
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = screen.get_rect().centerx
		#elf.item1rect.centery = screen.get_rect().centery
		self.item1rect.top = self.title2rect.top + delta
		self.item2rect.top = self.item1rect.top + 2*itemspacing
		self.item3rect.top = self.item1rect.top + 4*itemspacing
	
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.title2, self.title2rect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		
	def drawsettings(self, res, fs, cr):
		self.res = res
		self.fs = fs
		
		if self.res == 0: self.res_str = "640 x 480"
		elif self.res == 1: self.res_str = "800 x 600"
		elif self.res == 2: self.res_str = "1024 x 768"
		
		if self.fs == 0: self.fs_str = "no"
		else: self.fs_str = "yes"
		
		if cr == 1: color = "PySciTrivia Dark"
		elif cr == 2: color = "PySciTrivia Light"
		elif cr == 3: color = "FSF"
		else: color = "FSF E"
		
		#make surfaces
		self.itemset1 = itemfont.render(self.res_str, 1, itemcolor)
		self.itemset2 = itemfont.render(self.fs_str, 1, itemcolor)
		self.itemset3 = itemfont.render(color, 1, itemcolor)
		#make rects
		self.itemset1rect = self.itemset1.get_rect()
		self.itemset2rect = self.itemset2.get_rect()
		self.itemset3rect = self.itemset3.get_rect()
		#move rects
		self.itemset1rect.centerx = self.itemset2rect.centerx = self.itemset3rect.centerx = self.screen.get_rect().centerx
		self.itemset1rect.top = self.item1rect.top + itemspacing
		self.itemset2rect.top = self.item2rect.top + itemspacing
		self.itemset3rect.top = self.item3rect.top + itemspacing
		#draw
		self.screen.blit(self.itemset1, self.itemset1rect)
		self.screen.blit(self.itemset2, self.itemset2rect)
		self.screen.blit(self.itemset3, self.itemset3rect)
		
	def drawselection(self, pos):
		self.selectionbox = self.item1.get_rect()
		self.selectionbox.width *= 2
		self.selectionbox.centerx = self.screen.get_rect().centerx
		self.selectionbox.top = self.item1rect.top + itemspacing
		background2 = pygame.Surface((self.selectionbox.width, self.selectionbox.height))
		background2.set_alpha(alpha)
		background2.fill(boxcolor)
		self.selectionbox.top += 2*itemspacing*(pos - 1)
			
		self.screen.blit(background2, self.selectionbox)
			
class LoopVideosettings:
	def __init__(self, screen, background):
		pos = 1
		mv = MakeVideosettings(screen, background)
		
		vsfile = open('settings/video.txt', 'r')
		vsfile.seek(0)
		a = int(vsfile.readline(1))
		vsfile.seek(1)
		b = int(vsfile.readline(1))
		vsfile.seek(2)
		cr = int(vsfile.readline(1))
		vsfile.close()
		
		running = 1
		while (running == 1):
			background.fill(bgcolor)
			screen.blit(background, (0,0))
			mv.drawscreen()
			mv.drawselection(pos)
			mv.drawsettings(a, b, cr)
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > mv.item1rect.y+itemspacing and mousepos[1] < mv.item1rect.y +2*itemspacing:
				pos = 1
			elif mousepos[1] > mv.item2rect.y+itemspacing and mousepos[1] < mv.item2rect.y +2*itemspacing:
				pos = 2
			elif mousepos[1] > mv.item3rect.y+itemspacing and mousepos[1] < mv.item3rect.y +4*itemspacing:
				pos = 3
					
			for event in pygame.event.get():
				if event.type is KEYDOWN:
					
					if event.key == K_ESCAPE:
						running = 0
									
				if event.type is MOUSEBUTTONDOWN:
					vsfile = open('settings/video.txt', 'r+w')
					if pos == 1:
						if a == 0: vsfile.seek(0); vsfile.write("1")
						elif a == 1: vsfile.seek(0); vsfile.write("2")
						else: vsfile.seek(0); vsfile.write("0")
					elif pos == 2: 
						if b == 0: vsfile.seek(1); vsfile.write("1")
						else: vsfile.seek(1); vsfile.write("0")
					elif pos == 3:
						if cr == 1: vsfile.seek(2); vsfile.write("2")
						elif cr == 2: vsfile.seek(2); vsfile.write("3")
						elif cr == 3: vsfile.seek(2); vsfile.write("4")
						else: vsfile.seek(2); vsfile.write("1")
					vsfile.close()
				if event.type is QUIT:
					sys.exit()
			
			vsfile = open('settings/video.txt', 'r')
			vsfile.seek(0)
			a = int(vsfile.readline(1))
			vsfile.seek(1)
			b = int(vsfile.readline(1))
			vsfile.seek(2)
			cr = int(vsfile.readline(1))
			vsfile.close()		