#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, itemcolor, boxcolor, cs, bgcolor, alpha, itemfont, winfont, titlecolor, scorefont
from scale import title2font

winsound =  pygame.mixer.Sound("data/sounds/effects/win.ogg")

class WinScreen:
	def __init__(self, screen, background, winner, p1s, p2s, p3s, numplayers):
		self.screen = screen
		self.background = background
		
		if winner == 1 or numplayers == 1:
			thewinner = "Player 1"
		elif winner == 2 and numplayers >= 2:
			thewinner = "Player 2"
		elif winner == 3 and numplayers >= 3:
			thewinner = "Player 3"
		elif winner == 12 and numplayers >= 2:
			thewinner = "Player 1 and Player 2"
		elif winner == 13 and numplayers >= 3:
			thewinner = "Player 1 and Player 3"
		elif winner == 23 and numplayers >= 3:
			thewinner = "Player 2 and Player 3"
		elif winner == 123 and numplayers >= 3:
			thewinner = "Everyone"
			
		string1 = "Congratulations"
		string2 = thewinner
		string3 = "Results:"
		#surfaces
		self.esc1 = winfont.render(string1, 1, itemcolor)
		self.esc2 = winfont.render(string2, 1, titlecolor)
		self.title3 = itemfont.render(string3, 1, itemcolor)
		#make and move rects
		self.esc1rect = self.esc1.get_rect()		
		self.esc2rect = self.esc2.get_rect()
		self.title3rect = self.title3.get_rect()
		
		self.esc1rect.top = self.esc1rect.h*(.5)
		self.esc2rect.top += self.esc2rect.h*(1.5)
		self.esc1rect.centerx = self.esc2rect.centerx = self.screen.get_rect().centerx
		self.title3rect.centerx = self.screen.get_rect().centerx
		self.title3rect.top += self.esc2rect.h*(3)
		
		#results stuff
		p1header = scorefont.render("Player 1 Score", 1, itemcolor)
		p2header = scorefont.render("Player 2 Score", 1, itemcolor)
		p3header = scorefont.render("Player 3 Score", 1, itemcolor)
		p1rect = p1header.get_rect()
		p2rect = p2header.get_rect()
		p3rect = p3header.get_rect()
		p1rect.top = p2rect.top = p3rect.top = self.title3rect.top + self.esc1rect.h
		p2rect.centerx = self.screen.get_rect().centerx
		p1rect.centerx = self.screen.get_rect().centerx - (.25)*self.screen.get_rect().w
		p3rect.centerx = self.screen.get_rect().centerx + (.25)*self.screen.get_rect().w
		
		p1score = scorefont.render(str(p1s), 1, itemcolor)
		p2score = scorefont.render(str(p2s), 1, itemcolor)
		p3score = scorefont.render(str(p3s), 1, itemcolor)
		p1scorerect = p1score.get_rect()
		p2scorerect = p2score.get_rect()
		p3scorerect = p3score.get_rect()
		p1scorerect.centerx = p1rect.centerx
		p2scorerect.centerx = p2rect.centerx
		p3scorerect.centerx = p3rect.centerx
		p1scorerect.top = p2scorerect.top = p3scorerect.top = p1rect.top + p1rect.h
		
		con = title2font.render("press any button or key to return to the menu", 1, itemcolor)
		conrect = con.get_rect()
		conrect.centerx = self.screen.get_rect().centerx
		conrect.bottom = self.screen.get_rect().bottom - conrect.h*(.1)
		
		self.background.fill(bgcolor)
		self.screen.blit(self.background, (0,0))
		
		self.screen.blit(self.esc1, self.esc1rect)
		self.screen.blit(self.esc2, self.esc2rect)
		self.screen.blit(self.title3, self.title3rect)
		self.screen.blit(con, conrect)
		
		if numplayers == 3:
			self.screen.blit(p1header, p1rect)
			self.screen.blit(p2header, p2rect)
			self.screen.blit(p3header, p3rect)
			self.screen.blit(p1score, p1scorerect)
			self.screen.blit(p2score, p2scorerect)
			self.screen.blit(p3score, p3scorerect)
		elif numplayers == 2:
			self.screen.blit(p1header, p1rect)
			self.screen.blit(p2header, p2rect)
			self.screen.blit(p1score, p1scorerect)
			self.screen.blit(p2score, p2scorerect)
		else:
			self.screen.blit(p1header, p1rect)
			self.screen.blit(p1score, p1scorerect)


		pygame.display.flip()
		pygame.event.clear()
		pygame.time.wait(250)
		escrunning = 1
		
		winsound.play(0,0)
		
		while escrunning == 1:
			for event in pygame.event.get():
				if event.type is QUIT:
					sys.exit()
				elif event.type is KEYDOWN:
					escrunning = 0
				elif event.type is MOUSEBUTTONDOWN:
					escrunning = 0
			pygame.time.wait(10)
		
