#!$PYTHON
#  runbaby - A GUI program that let's you run other programs without opening a
#  shell or using the mouse.
#  Copyright (C) 2006 Rafael Cunha de Almeida
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import sys
import os
try:
    import pygtk
    pygtk.require('2.0')
except:
    pass
try:
    import gtk
    import gtk.glade
    import gobject
except:
    print "You need to install PyGTK and GTK2 in order to run this program."
    print "Or maybe you need to set PYTHONPATH correctly if you already have"
    print "those libraries installed."
    print "Sorry for the inconvenience :-("
    sys.exit(1)

GLADE_FILE = "$GLADE_PATH/runbaby.glade"
ETC_CONF = "/etc/runbaby.conf"
HOME_CONF = ".runbaby"
HISTORY_FILE = ".lastbaby"
DEFAULT_TERM = "xterm"

class ConfigHandler:
    """Class for handling configure files"""
    def __init__(self):
        """__init__() -> None
        
        The configure file name is setted by constants, so no parameters are
        necessary"""
        self.file = None
        self.config = {}
        try:
            self.file = open(ETC_CONF, 'r')
        except:
            pass
        try:
            home = os.getenv("HOME")
            if home:
                self.file = open(os.path.join(home, HOME_CONF), 'r')
        except:
            pass
        self.__process_config()
        if self.file:
            self.file.close()

    def __process_config(self):
        """__process_config() -> None

        Process the configuration file"""
        if self.file:
            for line in self.file:
                if '#' in line:
                    line = line[:line.index('#')] # remove comments
                line = line.strip()
                item = tuple(line.split('='))
                self.config.update((item,))

    def get_config(self, key):
        """get_config(string) -> string

        returns the requested config key's value"""
        return self.config[key]


def run(program):
    """run(string) -> None
    
    This funcion gets a program string as a parameter, makes it run with
    the appropriated parameters and then quits runBABY"""
    cmdopts = program.split()
    os.spawnlp(os.P_NOWAIT, cmdopts[0], *cmdopts)
    gtk.main_quit()

def accessed_files(dir, mode):
    files = os.listdir(dir)
    return [file for file in files if os.access(os.path.join(dir, file), mode)]

def path_files():
    dirs = os.getenv('PATH').split(os.pathsep)
    files = []
    for dir in dirs:
        if os.path.exists(dir):
            files.extend(accessed_files(dir, os.X_OK))
    return files

    
def run_button_clicked(widget):
    """run_button_clicked(widget_object) -> None
    
    This function gets the last text selected or typed by the user and uses
    it as the program to be run. This is supposed to be a callback function for
    when the 'Run!' button is pressed."""
    program = window_tree.get_widget('program_name').get_text()
    if program:
        open(os.path.join(os.getenv('HOME'), HISTORY_FILE), 'w').write(program)
        run(program)
    else:
        try:
            f = open(os.path.join(os.getenv('HOME'), HISTORY_FILE), 'r')
            program = f.readline()
            f.close()
            run(program)
        except IOError:
            pass

    
# terminal run stuff
def run_term_clicked(widget):
    """run_term_clicked(widget_object) -> None
    
    This function calls the class for handling the config file and tries to
    get the term setted by the user. This is the callback function for when the
    'Run Terminal' button is pressed."""
    conf = ConfigHandler()
    try:
        term = conf.get_config('term')
    except:
        print >> sys.stderr, "Config file not found, using default terminal"
        term = DEFAULT_TERM
    run(term)


def on_main_window_destroy(widget):
    gtk.main_quit()


def main():
    connections = {"on_run_button_clicked"    : run_button_clicked,
                   "on_run_term_clicked"      : run_term_clicked,
                   "on_main_window_destroy"   : on_main_window_destroy}

    entry = window_tree.get_widget('program_name')
    compl = gtk.EntryCompletion()
    entry.set_completion(compl)
    liststore = gtk.ListStore(gobject.TYPE_STRING)
    compl.set_model(liststore)
    compl.set_text_column(0)
    compl.set_inline_completion(True)

    all_progs = path_files()
    for x in all_progs:
        liststore.append([x])

    window_tree.signal_autoconnect(connections)
    gtk.main()


if __name__ == "__main__":
    window_tree = gtk.glade.XML(GLADE_FILE) # window tree made global
    main()
