#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_register_discard.pl,v 1.9 2004/01/31 00:56:17 yeupou Exp $
#
#
#
#  Copyright 2002-2003 (c) Mathieu Roy <yeupou@gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
#
#

##
## This script should be used by administrators to remove projects
## from the database (saving space, freeing unique ids)
##

use Savannah;
use Getopt::Long;
use Term::ANSIColor qw(:constants);
use POSIX qw(strftime);

my $logfile = "/var/log/sv_register_discard.log";
my $getopt;
my $help;
my $comment;
my $whoami;

# get options
eval {
    $getopt = GetOptions("comment=s" => \$comment,
			 "user=s" => \$whoami,
			 "help" => \$help);
};

if($help) {
    print STDERR <<EOF;
Usage: $0 [project] [OPTIONS] 

Remove a project from the database, saving space and freeing
non-numeric unique ids.

  -h, --help                 Show this help and exit

  -c, --comment comment      Explanation for deletion
  -u, --user                 Whoami?

Examples:
  sv_register_discard popol # Remove project popol
  sv_register_discard       # Search for projects marked as D
                            # in the database. Delete via web
                            # interface mark projects as D
  sv_register_discard popol -u me --comment=\"because\"

Author: yeupou\@gnu.org
EOF
exit(1);
}


# Functions

sub RemoveItem {
    my $project = $_[0];

    # Get missing infos
    unless ($project) {
	print "Type the project system name:\n";
	chomp($project = <STDIN>);
    }    
    unless ($comment) {
	print "Type a short comment explaining why the project * $project * is discarded:\n";
	chomp($comment = <STDIN>);
    }
    $whoami = "[by $whoami] " if $whoami;

    # Do the job, redirecting informations to the LOGFILE
    print LOG strftime "%c: ", localtime;
    print LOG "% $project % removed, $comment $whoami\n";
    $success = DeleteGroup($project);
    die "Error during database update\nStopped " unless $success;
}

# to remove all the project marked as D in the SQL DB
sub RemoveAllItem {
    unless ($whoami) {
	print "Please, tell me who are you :) (write your login or type enter)\n";
	chomp($whoami = <STDIN>);
    }

    print "We are looking for any project marked as D in the SQL DB...\n";

    for (GetGroupList("status='D'", "unix_group_name")) {
	RemoveItem($_);
    }

    print "Everything is done, logged in $logfile\n";
}


open(LOG, ">> $logfile");

if (@ARGV) {
    for (@ARGV) {
	RemoveItem($_);
    }
} else {
    RemoveAllItem();
}
    

close(LOG);

# END
