#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: mailing_lists_create.pl,v 1.2 2004/01/31 00:56:17 yeupou Exp $
# -w
#
# mailing_lists_create.pl - Creates mailing lists based off of the file dump
# Written by Guillaume Morin <gmorin@gnu.org>

use strict; # I am a nice boy
use XML::DOM;

my $identity = "/root/.ssh/identity.savannah";
my $remote = "savannah.gnu.org";
my $file = "list.xml";

my $mailman_dir = "/com/mailer/mailman";
my $ngmailman_dir = "/com/mailer/freesoftware/mailman";
my $mailman_alias = "/com/mailer/aliases-savannah.gnu.org";
my $ngmailman_alias = "/com/mailer/aliases-freesoftware";
#my $mailman_alias = "test_ml";
my @alias = ("/com/mailer/aliases",$mailman_alias);

my $rsync = "rsync --rsh=\"ssh -1 -i $identity\" xmlbase\@$remote: .";
my $mailto = "savannah-hackers\@gnu.org";


sub dom_field {
    my($node, $field) = @_;
	 
    my($child) = $node->getElementsByTagName($field)->[0]->getFirstChild();
    return $child ? $child->getData() : "";
}

sub mail {
	exit if (scalar(@_) < 2);
	my $listname = $_[0];
	my $listadmin = $_[1]; 
	open(MAIL,"|mail -s \"$listname name clash\" $mailto");
	print MAIL <<EOF;
	
The fencepost cronjob has detected that $listname
already exists on fencepost but $listadmin seems to have
requested its creation
	
Please fix this asap.
EOF
	
}

sub main {

	my $verbose = 0;
	$verbose = 1 if ( scalar(@ARGV) >= 1 &&$ARGV[0] eq "-v" );
	
	# We get the latest dump on savannah
	system($rsync) && die("`hostname`: $0 Can't retrieve xml dump\n");

	my $parser = new XML::DOM::Parser;
	my $doc = $parser->parsefile ($file);

	die("Cannot parse $file: $!\n") if (! $doc);

	my $list;

	die ("Cannot execute newlist: $!\n") if ( ! -x "$mailman_dir/bin/newlist");
	die ("Cannot execute newlist: $!\n") if ( ! -x "$ngmailman_dir/bin/newlist");


	# We will update the savannah alias files
	open(ALIAS,">>$mailman_alias") or die("$mailman_alias: $!\n");
	open(NGALIAS,">>$ngmailman_alias") or die("$ngmailman_alias: $!\n");

	foreach $list ($doc->getElementsByTagName("list")) {
		my $gnu = $list->getAttribute("gnu");
		my $listname = &dom_field($list, "name");
		my $listadmin = &dom_field($list, "admin");
		my $listpassword = &dom_field($list, "password");
		my $exist = 0;
		my @output;
		my $file;
		my $dir;

		if ( $gnu eq "Y" ) {
			$dir = $mailman_dir;
		} else {
			$dir = $ngmailman_dir;
		}
		
		# We check if this Mailman ml has been alread created
		$exist = 1 if ( -d "$dir/lists/$listname");
	
		if ( $exist == 0 and $gnu eq "Y")	{
			# We check aliases file to avoid name clashes
			foreach $file (@alias)	{
				@output = `grep -c \"^\[[:space:]]*$listname\[[:space:]]*:\" $file`;
				die("grep does not work") if ( scalar(@output) < 1 );
				$output[0] =~ s/\D//g;
				if ($output[0] ne "0") {
					$exist = 1;
					&mail($listname,$listadmin);
					last;
				}
			}
		}
		
		if ( $exist == 0 ) {
			print ("Creating Mailing List: $listname\n") if ($verbose);
			die ("Cannot execute newlist: $!\n") if ( ! -x "$dir/bin/newlist");
			system("su - -c \"$dir/bin/newlist -q $listname $listadmin $listpassword >/dev/null 2>&1\" mailman") && die("$listname cannot be created\n");
		
			# We update the alias file
			my $wrapper;
			$wrapper = "$dir/mail/wrapper";
			my $now;
			$now = localtime;

			if ( $gnu eq "Y") {
				print ALIAS "## $listname mailing list\n";
				print ALIAS "## created: $now\n"; 
				print ALIAS "$listname: |$wrapper post $listname\n";
				print ALIAS "$listname-admin: |$wrapper mailowner $listname\n";
				print ALIAS "$listname-request: |$wrapper mailcmd $listname\n";
				print ALIAS "$listname-owner: $listname-admin\n\n";
			} else {
				print NGALIAS "## $listname mailing list\n";
				print NGALIAS "## created: $now\n"; 
				print NGALIAS "$listname: |$wrapper post $listname\n";
				print NGALIAS "$listname-admin: |$wrapper mailowner $listname\n";
				print NGALIAS "$listname-request: |$wrapper mailcmd $listname\n";
				print NGALIAS "$listname-owner: $listname-admin\n\n";
			}
		
		} else {
			print("$listname exists\n") if ($verbose);
		}
	}	

	close(ALIAS);
	close(NGALIAS);

	$doc->dispose; #nice boy again
}

&main();

###### EOF
