<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: index.php,v 1.25 2004/03/06 16:53:35 toddy Exp $
//
//
//  Copyright 1999-2000 (c) The SourceForge Crew
//  Copyright 2000-2003 (c) Free Software Foundation
//                          Laurent Julliard, CodeX Team, Xerox
//
//  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at-gna.org>
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

if ($item_id && !$group_id)
{
  // If the group information is missing, try to guess it
  // from the item_id given
  $group_id = trackers_data_get_item_group($item_id);
}

if ($group_id)
{
  // Initialize the global data structure before anything else
  trackers_init($group_id);

  $project=project_get_object($group_id);
  $changed = false;
  $changes = array();

  switch ($func)
    {

    case 'search' :
      {
	// Form to do a search on the item database

	include '../include/trackers_run/search.php';
	break;
      }

    case 'browse' :
      {
	// Browse thru the bug database
	// (it also the Default)

	include '../include/trackers_run/browse.php';
	break;
      }

    case 'additem' :
      {
	// Form to add new item

	include '../include/trackers_run/add.php';
	break;
      }

    case 'detailitem' :
      {
	// Show a bug already in the database, permitting to add comment
	// or even modify.

	if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2'))
	  {
	    dbg("Management/Technician rights, include mod.php");
	    include '../include/trackers_run/mod.php';
	  }
	else
	  {
	    dbg("No specific rights, include detail.php");
	    include '../include/trackers_run/detail.php';
	  }
	break;
      }

    case 'postadditem' :
      {
	// Actually add in the database what was filled in the form

	// Get the list of bug fields used in the form
	$vfl = trackers_extract_field_list();

	// Data control layer
	$item_id=trackers_data_create_item($group_id,$vfl);

	if ($item_id)
	  {

	    // Attach new file if there is one
	    if ($input_file != "none" && $input_file)
	      {
		trackers_attach_file($item_id,
				     $group_id,
				     $input_file,
				     $input_file_name,
				     $input_file_type,
				     $input_file_size,
				     $file_description);
	      }
	    // Add new cc if any
	    if ($add_cc && user_isloggedin())
	      {
		trackers_add_cc($item_id,
				$group_id,
				$add_cc,
				$cc_comment);
	      }


	    // send an email to notify the user of the bug update
	    list($address, $sendall) = trackers_data_get_item_notification_info($item_id, ARTIFACT, 0);
	    trackers_mail_followup($item_id, $address);

	  }
	else
	  {
	    // Some error occurred
	    fb(_("Missing parameters, nothing added."), 0);
	  }

	// show browse item page
	include '../include/trackers_run/browse.php';


	break;
      }

    case 'postmoditem' :
      {

	// Update a bug already in the database, reserved to item techn.
	// or manager.

	if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2'))
	  {
	    dbg("Techn. or Manager rights, make an update on almost every fields.");

	    // Special case: we may be searching for an item, in that case
	    // reprint the same page, plus search results.
	    if ($depends_search || $reassign_change_project_search)
	      {
		if ($depends_search)
		  {
		    fb(_("You provided search words to get a list of items this one may depends on. Below, in the section \"Dependencies\", you can now select the appropriate one(s) and submit the form."));
		  }
		if ($reassign_change_project_search)
		  {
		    if ($feedback)
		      { '<br>'; }
		    fb(_("You provided search words to get a list of project this item should maybe reassigned to. Below, in the section \"Reassign this item\", you can now select the appropriate project and submit the form."));
		  }

		include '../include/trackers_run/mod.php';
		break;
	      }

	    // Get the list of bug fields used in the form
	    $vfl = trackers_extract_field_list();

	    //data control layer
	    $additional_addresses = "";
	    $changed = trackers_data_handle_update($group_id,
						   $item_id,
						   $dependent_on_task,
						   $dependent_on_bugs,
						   $dependent_on_support,
						   $dependent_on_patch,
						   $canned_response,
						   $vfl,
						   $changes,
						   $additional_addresses);


	    // Attach new file if there is one
	    if ($input_file != "none" && $input_file)
	      {
		$changed |= trackers_attach_file($item_id,
						 $group_id,
						 $input_file,
						 $input_file_name,
						 $input_file_type,
						 $input_file_size,
						 $file_description,
						 $changes);
	      }

	    // Add new cc if any
	    if ($add_cc)
	      {
		$changed |= trackers_add_cc($item_id,
					    $group_id,
					    $add_cc,
					    $cc_comment,
					    $changes);
	      }

	    if ($changed)
	      {
		// Check if we're supposed to send all modifications to an address
		list($address, $sendall) = trackers_data_get_item_notification_info($item_id, ARTIFACT, 1);
		if ($sendall == 1)
		  {
	          if (trim($additional_addresses) != "")
		    {
                      $address .= ", ".$additional_addresses;
		    }
		    trackers_mail_followup($item_id, $address,$changes);
		  }

	      }

	    // Finally handle reassignation of an entry. Why so late?
	    // Because all the information entered by someone reassigning
	    // the bug must be in the original report, and will be duplicated
	    // in the new one.
	    if ($reassign_change_project || ($reassign_change_artifact && ($reassign_change_artifact != ARTIFACT)))
	      {
		dbg("reassign item: reassign_change_project:$reassign_change_project, reassign_change_artifact:$reassign_change_artifact, ARTIFACT:".ARTIFACT);
		trackers_data_reassign_item ($item_id,
					     $reassign_change_project,
					     $reassign_change_artifact);
	      }
	  }
	else
	  {  fb(_("Invalid parameters, please contact administrators."), 0); }
	include '../include/trackers_run/browse.php';
	break;
      }

    case 'postaddcomment' :
      {
	// Add a comment to a bug already in the database,
	// these are the only changes an non member can make

	// Add a new comment if there is one
	if ($details != '')
	  {
	    // For none project members force the comment type to None (100)
	    trackers_data_add_history('details',htmlspecialchars($details),'',$item_id,100);

            // YPE fix to trigger notifications in case of non member
            $changes['details']['add'] = stripslashes($details);
            $changes['details']['type'] = 'None';
            $changed = true;

	    fb(_("Comment added to item."));
	  }

	// Attach new file if there is one
	if ($input_file != "none")
	  {
	    trackers_attach_file($item_id,
				 $group_id,
				 $input_file,
				 $input_file_name,
				 $input_file_type,
				 $input_file_size,
				 $file_description);
	  }
	    // Add new cc if any, only accepted from logged in users.
	if ($add_cc && user_isloggedin())
	  {
	    trackers_add_cc($item_id,
			    $group_id,
			    $add_cc,
			    $cc_comment);
	  }

	list($address, $sendall) = trackers_data_get_item_notification_info($item_id, ARTIFACT, 1);
	if (($changed) && ($sendall == 1))
	  {
	    trackers_mail_followup($item_id,$address,$changes);
	  }

	include '../include/trackers_run/browse.php';
	break;
      }

    case 'delete_file' :
      {
	// Remove an attached file

	if (member_check(0,$group_id, member_create_tracker_flag(ARTIFACT).'2'))
	  {
	    trackers_data_delete_file($group_id,$item_id,$item_file_id);

	    // unset item_id var to make sure that it doesn;t
	    // impact the next bug query.
	    unset($item_id);
	    unset($HTTP_GET_VARS['item_id']);
	    include '../include/trackers_run/browse.php';
	  }
	else
	  {
	    exit_permission_denied();
	  }
	break;
      }

    case 'delete_cc' :
      {
	// Remove a person from the Cc: list of a bug

	$changed = trackers_delete_cc($group_id,$item_id,$item_cc_id,$changes);

	if ($changed)
	  {
	    /*
	      see if we're supposed to send all modifications to an address
	    */
	    list($address, $sendall) = trackers_data_get_item_notification_info($item_id, ARTIFACT, 1);
	    if ($sendall == 1)
	      {
	        trackers_mail_followup($item_id, $address,$changes);
	      }
	  }

	// unset trackers_id var to make sure that it doesn;t
	// impact the next bug query.
	unset($item_id);
	unset($HTTP_GET_VARS['item_id']);
	include '../include/trackers_run/browse.php';

	break;
      }

    case 'delete_dependancy' :
      {
	// Remove a dependancy

	$changed = trackers_delete_dependancy($group_id,
					      $item_id,
					      $item_depends_on,
					      $item_depends_on_artifact);

	if ($changed)
	  {
	    // check if we're supposed to send all modifications to an address
	    list($address, $sendall) = trackers_data_get_item_notification_info($item_id, ARTIFACT, 1);
	    if ($sendall == 1)
	      {
	        trackers_mail_followup($item_id, $address,$changes);
	      }
	  }

	// unset trackers_id var to make sure that it doesn;t
	// impact the next bug query.
	unset($item_id);
	unset($HTTP_GET_VARS['item_id']);
	include '../include/trackers_run/browse.php';

	break;
      }

      /*
         Follow the code of filters (query form) modification.
         This is currently broken, due to the separation of personal
         and project-wide configuration.

         It will be reactivate, but maybe not in this index page.

    case 'modfilters' :
      {
      // Modification of the filters (query form)

	if (user_isloggedin())
	  {
	    include '../include/trackers_run/mod_filters.php';
	    break;
	  }
	else
	  { exit_not_logged_in(); }
      }

    case 'postmodfilters' :
      {
	if (user_isloggedin())
	  {
	    include '../include/trackers_run/postmod_filters.php';
	    include '../include/trackers_run/mod_filters.php';
	    break;
	  }
	else
	  { exit_not_logged_in(); }
      }
      */

    default :
      {
	// Browse thru the bug database

	include '../include/trackers_run/browse.php';
	break;
      }

    }

}
else
{

  exit_no_group();

}
?>
