<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: index.php,v 1.42 2004/01/31 00:56:19 yeupou Exp $
//
//
// 
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2003 (c) Free Software Foundation
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//

require '../include/pre.php';

if ($group_id) 
{  

  exit_test_usesmail($group_id);

  site_project_header(array('group'=>$group_id, 'toptab'=>'mail'));

  
  if (user_isloggedin() && user_ismember($group_id)) 
    { $public_flag='0,1'; } 
  else 
    { $public_flag='1'; }
  
  $sql="SELECT * FROM mail_group_list WHERE group_id='$group_id' AND is_public IN ($public_flag)";
  $result = db_query ($sql);
  $rows = db_numrows($result); 
  
  if (!$result || $rows < 1) 
    {
      printf ('<h2>'._("No Lists found for %s").'</h2>',$project->getName());
      print '<p>'._("Project administrators can add mailing lists using the admin interface.").'</p>';
      $HTML->footer(array());
      exit;
    }
  
  for ($j = 0; $j < $rows; $j++) 
    {
      $is_public = db_result($result,$j,'is_public');
      $pass = db_result($result,$j,'password');

      $list = db_result($result, $j, 'list_name');

      // Pointer to listinfo or to the mailing list address, if no listinfo is found
      if ($project->getTypeMailingListListinfoUrl($list) && $project->getTypeMailingListListinfoUrl($list) != "http://")
	{ $default_pointer = $project->getTypeMailingListListinfoUrl($list); }
      else
	{ $default_pointer = "mailto:".$project->getTypeMailingListAddress($list); }

      print '<p><a href="'.$default_pointer.'"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/mail.png" border="0" alt=""></a>&nbsp;<a href="'.$default_pointer.'">'.$list.'</a> ';
      
      // Description
      print '&nbsp;&nbsp;<i>'.db_result($result, $j, 'description').'</i>';

      if ($project->getTypeMailingListArchivesUrl($list) && $project->getTypeMailingListArchivesUrl($list) != "http://")
	{
	  // Pointer to archives
	  print '<dd>'.sprintf(_("To see the collection of prior posting to the list, visit the %s%s archives%s"),'<a href="'.$project->getTypeMailingListArchivesUrl($list).'">', $list, '</a>.');
	}
	 
      if ($project->getTypeMailingListAddress($list))
	{
	  // Address
	  print '<br>'.sprintf(_("To post a message to all the list members, send email to %s"),'<a href="mailto:'.$project->getTypeMailingListAddress($list).'">'.$project->getTypeMailingListAddress($list).'</a>');
	}
      else 
	{
	  print '<br><font class="error">'._("No mailing-list address was found, the configuration of the server is probably broken, contact the admins!").'</font>';
	}

      // Subscribe, unsubscribe:
      // if these fields are empty, go back on the listinfo page
      if ($project->getTypeMailingListSubscribeUrl($list) && 
	  $project->getTypeMailingListSubscribeUrl($list) != "http://" && 
	  $project->getTypeMailingListUnsubscribeUrl($list) && 
	  $project->getTypeMailingListUnsubscribeUrl($list) != "http://")
	{
	  if ($project->getTypeMailingListSubscribeUrl($list) && $project->getTypeMailingListSubscribeUrl($list) != "http://") {
	    print '<br>'.sprintf(_("You can subscribe to the list by submitting %sthis message%s"),'<a href="'.$project->getTypeMailingListSubscribeUrl($list).'">','</a>.');
	  }
	  if ($project->getTypeMailingListUnsubscribeUrl($list) && $project->getTypeMailingListUnsubscribeUrl($list) != "http://") {
	    print '<br>'.sprintf(_("You can unsubscribe to the list by submitting %sthis message%s"),'<a href="'.$project->getTypeMailingListUnsubscribeUrl($list).'">','</a>.');
	  }
	}
      else if ($project->getTypeMailingListListinfoUrl($list) && $project->getTypeMailingListListinfoUrl($list) != "http://")
	{
	  print '<br>'.sprintf(_("You can (un)subscribe to the list by following instructions on the %slist information page%s"),'<a href="'.$project->getTypeMailingListListinfoUrl($list).'">','</a>.');
	}
      
      if ($project->getTypeMailingListAdminUrl($list) && $project->getTypeMailingListAdminUrl($list) != "http://")
	{
	  // Admin interface
	  print '<br>'.sprintf(_("Project administrators could use the %sadministrative interface%s to manage the list."),'<a href="'.$project->getTypeMailingListAdminUrl($list).'">','</a>').'</dd>';
	  
	}
      print '</p>';
    }
  
  site_project_footer(array()); 
  
} 
else 
{
  exit_no_group();
}

?>
