<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: export_texinfo.php,v 1.5 2004/03/13 18:22:05 yeupou Exp $
#
#  Copyright 2002-2003 (c) Mathieu Roy <yeupou@gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";

$group_id = $GLOBALS[sys_group_id];

$project=project_get_object($group_id);
$FAQ_DIR = $GLOBALS['sys_incdir'].'/faq';


function readFileIntoBuffer($filename)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':readFileIntoBuffer($filename)';    
  @$fp = fopen($filename, "r");
  if ($fp)
    {
      $val = fread($fp, filesize($filename));
      fclose ($fp);
      return $val;
    }
  return false;
} 
?>
\input texinfo                @c -*- Texinfo -*-
@c %**start of header
@setfilename <?php print $GLOBALS[sys_name]." FAQ"; ?>
@settitle @code{<?php print $GLOBALS[sys_name]." FAQ"; ?>}
@setchapternewpage odd
@c %**end of header

@titlepage
@title <?php print $GLOBALS[sys_name]." Frequently Asked Questions"; ?>

@subtitle <?php print $project->getDescription(); ?>
@subtitle @code{<?php print $GLOBALS[sys_name]." FAQ"; ?>} Version @value{VERSION}
@subtitle @value{UPDATED}
@author the <?php print $project->getPublicName()."'s project author(s)"; ?>
@page
@vskip 0pt plus 1filll

 Permission is granted to make and distribute verbatim copies of
 this manual provided the copyright notice and this permission notice
 are preserved on all copies.

 Permission is granted to copy and distribute modified versions of this
 manual under the conditions for verbatim copying, provided that the entire
 resulting derived work is distributed under the terms of a permission
 notice identical to this one.

 Permission is granted to copy and distribute translations of this manual
 into another language, under the above conditions for modified versions,
 except that this permission notice may be stated in a translation approved
 by the Free Software Foundation.
@end titlepage
@page

@menu
<?php
     $dir = opendir($FAQ_DIR);
     while ($file = readdir($dir)) {
      if ($file != "." && $file != ".." && $file != "index.php" && $file != "CVS") {     
        $question = ereg_replace(".txt", "", $file);	
        $question = ereg_replace("_", " ", $question);
        echo $question."?::\n"; }
     } 
     closedir($dir);            
?>
@end menu

<?php
     $dir = opendir($FAQ_DIR);
     while ($file = readdir($dir)) {
      if ($file != "." && $file != ".." && $file != "index.php" && $file != "CVS") {    
        $question = ereg_replace(".txt", "", $file);	
        $question = ereg_replace("_", " ", $question);
	echo "@node ".$question."?\n";
	echo "@chapter ".$question."?\n";
	
	$content = readFileIntoBuffer($FAQ_DIR."/".$file);
	# remove HTML tags
	$content = eregi_replace("<[^>]*>", "", $content);
	# put a link for emails
	$content = eregi_replace("([_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)+)", "@email{\\1,\\1}", $content);
	# put a link for urls
	echo eregi_replace("([[:alnum:]]+)://([^[:space:]]*)([[:alnum:]#?/&=])", "@uref{\\1://\\2\\3,,\\1://\\2\\3}", $content);
	}
     } 
     closedir($dir);
              
?>

@summarycontents
@contents
@bye
