#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_dead_projects.pl,v 1.7 2004/09/22 08:11:50 yeupou Exp $
#
#
# This script is part of GNU Savannah 
#
#
# Copyright (C)  Mathieu Roy <yeupou@gnu.org>, 2003
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

# FIXME: use obsolete conf options.

print "Not ready, bugs need to be fixed.\n";
exit;

#use strict;
#use warnings;

use Getopt::Long;
use Savannah;
use POSIX qw(strftime);

my $logfile = "/var/log/sv_hide_dead_projects.log";
my $cron;
my $getopt;
my $help;
my $debug;

my $only_list;
my $only_typeid;

my $message = $sys_incdir."/predefined_mails/project_apparently_dead.txt";
my $tmpmail = "/tmp/svdeadprojectsmail";
my $delay = "124";
my $kill_delay = "184";

my $nocheck_cvs = "0";
my $nocheck_description = "0";
my $nocheck_download = "0";
my $nocheck_homepage = "0";
my $nocheck_mail = "0";

eval {
    $getopt = GetOptions("help" => \$help,
			 "cron" => \$cron,
			 "debug" => \$debug,
			 "list-only" => \$only_list,
			 "only-typeid=s" => \$only_typeid,
			 "delay=s" => \$delay,
			 "kill-delay=s" => \$kill_delay,
			 "message=s" => \$message,
			 "ignore-cvs" => \$nocheck_cvs,
			 "ignore-description" => \$nocheck_description,
			 "ignore-download" => \$nocheck_download,
			 "ignore-homepage" => \$nocheck_homepage,
			 "ignore-mail" => \$nocheck_mail);
};

if($help || !$getopt) {
    print STDERR <<EOF;
Usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]

Identify project that seems to be dead, set them as private, and eventually
remove them if nothing change after a delay.

      --help                 Show this help and exit
      --cron                 Option to set when including this script
                             in a crontab. It means that it will run
			     only if it\'s asked in the Savannah conf
      --list-only            Only list project that seems to be dead,
      --message=/file        Select a default mail content

    Test conditions: 
      --delay=[n]            Delay in days (default: 124, almost 4 months)
                             Every project that do not satisfy the tests
                             and was registered more than n month ago are
			     considered as dead.
      --kill-delay=[n]       Delay in days for complete deletion
                             (default: 184, 2 months after delay)
			     It won\'t delete any project, it will only
			     send to message to sysadmins!
      --only-typeid=[n]      Check only project of group type n
      --ignore-cvs           Not checking if the CVS tree is empty
      --ignore-description   Not checking if the description is not filled 
      --ignore-download      Not checking if the download area is empty      
      --ignore-homepage      Not checking if the homepage area is empty     
      --ignore-mail          Not checking if mailing-list exists

    Mail message:
      In the file defined as default mail content, the following strings
      will be converted.

      \%project              Project name
      \%admins               Project admins mails
      \# comments ignored

      According to your configuration, the default file is
      $message

Important: if you ignore to much test conditions, results may be
very unaccurate.

Author: yeupou\@gnu.org
EOF
 exit(1);
}

# If running by cron, check if the configuration tell to continue.
#exit if ($cron && ! $sys_cron_mail);

open(LOG, ">> $logfile");
print LOG strftime "%c: \n", localtime;

# If the default message do not exists, stop here.
unless (-e $message) {    
    print LOG "$message does not exist, exiting.\n";
    print "$message does not exist, exiting.\n" unless $cron;
    exit;
}

# If no test condition are asked, we stop here.
if ($nocheck_cvs &&
    $nocheck_description &&
    $nocheck_download &&
    $nocheck_homepage &&
    $nocheck_mail) {
    print LOG "No test selected, exiting.\n";
    print "No test selected, exiting.\n" unless $cron;
    exit;
}

# Define epoch date of today
my $epoch_now = localtime;

# We'll begin by storing project name in list
my @maybe_dead;
my @surely_dead;

# We may have several groups to deal with
my $typeid;
unless ($only_typeid) {
    @typeid = GetDBList("group_type", 0 , "type_id");
} else {
    @typeid = ($only_typeid);
}
foreach my $type (@typeid) {
    # Get group type settings.
    # We'll base our tests on these values.
    # Some projects may not respect group type defaults settings, but
    # it's surely better in this case to skip the test by using a command
    # line option than having this scripts make 6 SQL requests per project
    # more.
    #
    # We can also add more test as if group_type allow download area or not
    # but it's surely better to tell people to use relevant command line.
    my $type_name =GetGroupTypeName($type);
    my $cvs_dir = GetGroupTypeSettings($type_name, "cvs_dir")
	unless $nocheck_cvs;
    my $download_dir = GetGroupTypeSettings($type_name, "download_dir")
	unless $nocheck_download;
    my $homepage_dir = GetGroupTypeSettings($type_name, "homepage_dir").GetGroupTypeSettings($type_name, "homepage_cvs_module_prefix")
	unless $nocheck_homepage;


    # Get a list of good candidates
    my $criterion;
    $criterion .= "(short_description='' OR short_description IS NULL) AND "
	unless $nocheck_description;
    $criterion .= "type='$type'";
    my @candidates = GetDBList("groups",
			       $criterion,
			       "unix_group_name");
      
    foreach my $project (@candidates) {
	my $epoch_project = GetGroupSettings($project, "register_time");
	my $diff = $epoch_project - $now_epoch;
	
	my $sec, $min, $hour, $day;
	$sec = $diff % 60;
	$diff = ($diff - $sec) / 60;
	$min = $diff % 60;
	$diff = ($diff - $min) / 60;
	$hour = $diff % 24;
	$diff = ($diff - $hour) / 24;
	$day = $diff % 7;

	print LOG "DEBUG: $project, delay $day\n" if $debug;  
	
	if ($day > $delay) {
	    # Assuming that delay test will skip most projects, we do 
	    # other tests
	    my $cvs_succeed, $download_succeed, $homepage_succeed, $mail_succeed;

	    unless ($nocheck_cvs) {
		$cvs_succeed = 1 if `ls --color=never $cvs_dir/$project/$project 2> /dev/null | tail -n 1` ne '';
	    } else {
		$cvs_succeed = 1;
	    }

	    unless ($nocheck_download) {
		$download_succeed = 1 if `ls --color=never $download_dir/$project 2> /dev/null | tail -n 1` ne '';
	    } else {
		$download_succeed = 1;
	    }

	    unless ($nocheck_homepage) {
		# Hum, this test is very dependant on the www.gnu.org CVS
		$homepage_succeed = 1 if `ls --color=never $homepage_dir/$project 2> /dev/null | tail -n 1` ne '';
	    } else {
		$homepage_succeed = 1;
	    }
	    
	    unless ($nocheck_mail) {
		$mail_succeed = 1 if GetDBList("mail_group_list", GetGroupSettings($project, "group_id")) > 0;
	    } else {
		$mail_succeed = 1;
	    }
	    
	    # Finally, push project in the appropriate list
	    unless ($cvs_succeed &&
		    $download_succeed &&
		    $homepage_succeed &&
		    $mail_succeed) {
		if ($day > $kill_delay &&
		    GetGroupSettings($project, "is_public") eq '0') {
		    push(@surely_dead, $project);
		    print LOG "DEBUG: push $project in \@surely_dead\n" if $debug;
		} else {
		    push(@maybe_dead, $project);
		    print LOG "DEBUG: push $project in \@maybe_dead\n" if $debug;
		}
	    } else {
		print LOG "DEBUG: $project, cvs $cvs_succeed, download $download_succeed, homepage $homepage_succeed, mail $mail_succeed\n" if $debug; 
	    }
	}
    }
    
}


# Finally take action if asked
if ($only_list) {

    foreach my $project (@maybe_dead) {
	print LOG "$project seems to be dead.\n";
	print "$project seems to be dead.\n" unless $cron;
    }
    foreach my $project (@surely_dead) {	
	print LOG "$project is surely dead.\n";
	print "$project is surely dead.\n" unless $cron;
    }

} else {
    
# Set to private maybe dead projects and send a mail to his admins
    foreach my $project (@maybe_dead) {

	my $mailto_admins, $admins;
	for (GetGroupAdminsMail($project)){
	    $admins .= $_." ";	 
  
	}

	open(MESSAGE, "< $message");
	while (<MESSAGE>) {
	    next if /^\#(.*)/;
	    s/\%project/$project/;
	    s/\%admins/$admins/;	    
	    $mailto_admins .= $_;
	}
	close(MESSAGE);

	open(TMPMAIL, "> $tmpmail");
	print TMPMAIL "$mailto_admins";
	# we do not use -c option... in case there is no $admins
	system("mail $admins $sys_admin_list\@$sys_nglists_domain -s \"$project at $sys_default_domain\" < $tmpmail");
	close(TMPMAIL);

	print LOG "A mail about $project, maybe dead project was sent to $admins\n";

	my $success = SetGroupSettings($project, "is_public", "0");
	print LOG "$project is now private\n" if $success;

    }
    

# Send a mail to sysadmin about surely dead project
    my $mailto_sysadmins;
    foreach my $project (@surely_dead) {	
	$mailto_sysadmins .= "$project is surely dead.\n";
    }
    if ($mailto_sysadmins) {

	open(TMPMAIL, "> $tmpmail");
	print TMPMAIL "The following projects seem to be dead at $sys_default_domain

They are already set as private
The kill delay is $kill_delay days
nocheck_cvs          = $nocheck_cvs
nocheck_description  = $nocheck_description
nocheck_download     = $nocheck_download
nocheck_homepage     = $nocheck_homepage
nocheck_mail         = $nocheck_mail

Projects:
$mailto_sysadmins

This message was sent by sv_dead_projects";
	close(TMPMAIL);
	system("mail $sys_admin_list\@$sys_nglists_domain -s \"Project apparently dead at $sys_default_domain\" < $tmpmail");
	print LOG "A mail about surely dead project was sent to $sys_admin_list\@$sys_nglists_domain\n";

    }

    unlink($tmpmail) if -e $tmpmail;

}


close(LOG);

# End

