#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_register_still_pending.pl,v 1.5 2004/09/22 08:11:50 yeupou Exp $
#
#
#
#  Copyright 2003 (c) Mathieu Roy <yeupou@gnu.org> 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


# FIXME: use obsolete conf options.

print "Not ready, bugs need to be fixed.\n";
exit;

##
## This script send a mail to the admins to tell them that registration
## is pending since more than 2 days - it should avoid too big delays.
## 

use strict;
use Savannah;
use Getopt::Long;
use Term::ANSIColor qw(:constants);
use Time::localtime;
use Date::Calc qw(Delta_Days);

# Import
our $sys_incdir;
our $sys_admin_list;
our $sys_nglists_domain;
our $sys_default_domain;
our $sys_default_dir;

my $script = "sv_register_still_pending";
my $tmpmail = "/tmp/svpendingprojectsmail";
my $getopt;
my $cron;
my $help;
my $delay = 3;
my $list_only;
my $message = $sys_incdir."/predefined_mails/project_still_pending.txt";
my $mail = $sys_admin_list."@".$sys_nglists_domain;

my @candidates;

eval {
    $getopt = GetOptions("help" => \$help,
			 "list-only" => \$list_only,
			 "delay=s" => \$delay,
			 "message=s" => \$message);
};

if($help || !$getopt) {
    print STDERR <<EOF;
Usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]

Identify project register since a long time to avoid unacceptable delays.

      --help                 Show this help and exit
      --cron                 Option to set when including this script
                             in a crontab. It means that it will run
			     only if it\'s asked in the Savannah conf
			     (not implemented for now)
      --list-only            Only list projects
      --message=/file        Select a default mail content

    Test conditions: 
      --delay=[n]            Delay in days (default: 3).

    Mail message:
      In the file defined as default mail content, the following strings
      will be converted.

      \%projects             Formatted list of pending projects
      \# comments ignored

      According to your configuration, the default file is
      $message


Author: yeupou\@gnu.org
EOF
 exit(1);
}


# If running by cron, check if the configuration tell to continue.
#exit if ($cron && ! $sys_cron_);


# If the default message do not exists, stop here.
unless (-e $message) {    
    print "$message does not exist, exiting.\n" unless $cron;
    exit;
}


#######################################################################
##
## Find projects registered since more than 2 days (default)
##
#######################################################################
 
my $tm_now = localtime();
my $day_now = $tm_now->mday;
my $month_now = $tm_now->mon+1;
my $year_now = $tm_now->year+1900;

foreach my $line (GetDB("groups",
			"status='P'",
			"unix_group_name,register_time")) {
    chomp($line);

    my ($group, $epoch_project) = split(",", $line);

    my $tm = localtime($epoch_project);
    my $day = $tm->mday;
    my $month = $tm->mon+1;
    my $year = $tm->year+1900;

    my $diff = Delta_Days($year, $month, $day,
			  $year_now, $month_now, $day_now)-1;
    

    if ($diff > $delay) {
	push(@candidates, $group);
    }
}


#######################################################################
##
## Send a mail to admins
##
#######################################################################
 
if (@candidates) {

    # How do we list projects ?
    my $list;
    foreach my $group (@candidates) {
	$list .= "  $group <http://$sys_default_domain/$sys_default_dir/admin/groupedit.php?group=$group>\n";
    }

    if ($list_only) {

	print $list;

    } else {
    
	# Get the content of the mail
	my $mail_content;
	open(MESSAGE, "< $message");
	while (<MESSAGE>) {
	    next if /^\#(.*)/;
	    s/\%projects/$list/;	    
	    $mail_content .= $_;
	}
	close(MESSAGE);
	open(TMPMAIL, "> $tmpmail");
	print TMPMAIL $mail_content;
	close(TMPMAIL);

	# Send the mail
	system("mail $mail -s \"Pending projects\" < $tmpmail");
	unlink($tmpmail) if -e $tmpmail;

    }

}



### END
