#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_aliases.pl,v 1.9 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001
#               Mathieu Roy <yeupou@gnu.org>, 2003
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

use strict;
use Getopt::Long;
use Savannah;

# Imports (needed for strict)
our $sys_miscdir;
our $sys_mail_list;
our $sys_mail_aliases;
our $sys_cron_mail;

# Preconfigure
my $prefix = "$sys_miscdir";
my $temp = "$prefix/etc/temp$<";
my $emails = "$prefix/etc/email-addresses";
my $sysemails =  "$sys_mail_list";
my $sysaliases = "$sys_mail_aliases";
my $verbose = 0;
my $cron;
my $getopt;
my $help;

eval {
    $getopt = GetOptions("verbose+" => \$verbose,
			 "cron" => \$cron,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
Usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]

Include a list of Savannah users in /etc/email-addresses and
/etc/aliases.

      --help                   Show this help and exit
      --cron                   Option to set when including this script
                               in a crontab
      --verbose		       Increase verbosity level
      --help		       Print this help

Author: loic\@gnu.org
EOF
 exit(1);
}

# Test if we should run, according to conffile
exit if ($cron && ! $sys_cron_mail);

# Run
system("mkdir -p $prefix/etc");

open(OUT, ">$emails") or die "cannot open $emails for writing : $!";
print OUT "# Savannah include start\n";
print OUT "################################################################\n";
print OUT "#  Please DO NOT MODIFY the section in between                 #\n";
print OUT "#  'Savannah include start' and 'Savannah include end'.        #\n";
print OUT "#  It is generated automatically by sv_aliases                 #\n";
print OUT "###############################################################\n";
PrintAliasesList("OUT");
print OUT "# Savannah include end\n";
close(OUT);

open(OUT, ">$temp") or die "cannot open $temp for writing : $!";
open(IN, "<$sysemails");
while(<IN>)
{
    next if(/^\# Savannah include start/ .. /^\# Savannah include end/);
    print OUT $_;
}
close(IN); 
close(OUT);

system("cat $emails >>$temp; mv $temp $sysemails") if $sysemails;


open(OUT, ">$temp") or die "cannot open $temp for writing : $!";
open(IN, "<$sysaliases");
while(<IN>)
{
    next if(/^\# Savannah include start/ .. /^\# Savannah include end/);
    print OUT $_;
}
close(IN); 
close(OUT);

system("cat $emails >>$temp; mv $temp $sysaliases; if [ -e /usr/bin/newaliases ]; then /usr/bin/newaliases; fi") if $sysaliases;

# END

