<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.74 2004/06/23 19:46:15 beuc Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../../include/pre.php";

if ($group_id && user_ismember($group_id,'A'))
{

  exit_test_usesmail($group_id);

  $grp=project_get_object($group_id);

  # FIXME: GNU specific
  if ($project->getTypeName() == 'GNU' || $project->getTypeName() == 'www.gnu.org' && $GLOBALS[sys_default_domain] == "savannah.gnu.org")
    { $isgnu = true; }
  else
    { $isgnu=false; }


  if ($post_changes)
    {
      /***********************************************************
	Update the DB to reflect the changes
      ***********************************************************/

      # Add a new list
      if ($add_list)
	{
	  # Generates a password
	  $list_password = substr(md5($GLOBALS['session_hash'] . time() . rand(0,40000)),0,16);

	  # Defines the list name
	  if ($type != "0" && $type!="1" && $type!="2" && $type!="3" && $isgnu==true)
	    { exit_error('Error','Radio button not checked'); }

	  if ($type=="0" && ($list_name=="help" || $list_name=="info" || $list_name=="bug") && $isgnu==true)
	    { exit_error('Error','Invalid list name'); }

	  if ((($isgnu == true && $type == "0") || $isgnu == false) && (!$list_name || strlen($list_name) < 2))
	    { exit_error('Error','Must Provide List Name That Is 2 or More Characters Long'); }

	  if ( $isgnu == true )
	    {
	      switch ($type)
		{
		case "0":
		  $new_list_name=strtolower(group_getunixname($group_id).'-'.$list_name);
		break;

		case "1":
		  $new_list_name=strtolower('bug-'.group_getunixname($group_id));
		break;

		case "2":
		  $new_list_name=strtolower('help-'.group_getunixname($group_id));
		break;

		case "3":
		  $new_list_name=strtolower('info-'.group_getunixname($group_id));
		}

	    }
	  else
	    {
	      # FIXME name convention
	      $new_list_name=strtolower(group_getunixname($group_id).'-'.$list_name);
	    }

	  # Check on the list_name: must not be equal to a user account,
	  # otherwise it can mess up the mail develivery for the list/user
	  if (db_numrows(db_query("SELECT user_id FROM user WHERE "
				  . "user_name LIKE '".addslashes($list_name)."'")) > 0)
	    {
	      exit_error('Error', _("That list name is reserved, to avoid conflicts with user accounts."));
	    }


	  # If no host is available, we do not have to interfere with
	  # another host for list create, we do not nothing
	  # Currently, it only handles GNU mailman.
	  # If this part needs to be changed, please write to
	  # savannah-dev@gnu.org first.
	  if ($project->getTypeMailingListHost())
	    {
	      $site = "http://".$project->getTypeMailingListHost().
		 '/mailman/sfverify?list='.
		 urlencode($new_list_name).
		 '&password=p';

	      $file = fopen("$site","r");
	      if (!$file)
		{
		  print "<p>Unable to open remote file, try again later.\n";
		  site_project_footer(array());
		  exit;
		}
	      $next = 0;
	      $result = "";

	      while (!feof ($file))
		{
		  $line = fgets ($file, 1024);
		  if ($next == 1)
		    { break; }
		  elseif (eregi("\<BODY\>",$line,$void))
		    { $next = 1; }
			}

	      fclose($file);
	      $parse = explode(" ",$line);
	      $parse[0] = substr($parse[0],0,1);
	      if ($parse[0] != "0")
		{
		  # The validation ignores the domain
		  "Sorry, $new_list_name already exists";
		}
	      elseif (validate_email($project->getTypeMailingListAddress($new_list_name)))
		{
		  # FIXME name convention
		  $new_list_name=strtolower(group_getunixname($group_id).'-'.$list_name);

		}

	      if (validate_email($project->getTypeMailingListAddress($new_list_name)))
		{

		  $result=db_query("SELECT * FROM mail_group_list WHERE lower(list_name)='$new_list_name'");


		  if (db_numrows($result) > 0)
		    {
		      " ERROR - List Already Exists ";
		    }
		  else
		    {
		      $sql = "INSERT INTO mail_group_list "
			 . "(group_id,list_name,is_public,password,list_admin,status,description) VALUES ("
			 . "$group_id,"
			 . "'$new_list_name',"
			 . "'$is_public',"
			 . "'$list_password',"
			 . "'".user_getid()."',"
			 . "1,"
			 . "'". htmlspecialchars($description) ."')";

		      $result=db_query($sql);

		      if (!$result)
			{
			  " Error Adding List ";
			  print db_error();
			}
		      else
			{
			  " List Added ";
			}

		      # Send confirmation mail (only if we now the host)

		      $res_email = db_query("SELECT email FROM user WHERE user_id='".user_getid()."'");

		      if (db_numrows($res_email) < 1)
			{
			  exit_error("Invalid userid","Does not compute.");
			}
		      $row_email = db_fetch_array($res_email);

		      $mlhost=$project->getTypeMailingListHost();

		      # mail password to admin
		      $message = "A mailing list will be created on fencepost in less than 2 hours \n"
			 . "and you are the list administrator.\n\n"
			 . "This list is: $new_list_name" .$mldomain ."\n\n"
			 . "Your mailing list info is at:\n"
			 . "".$project->getTypeMailingListListinfoUrl($new_list_name)."\n\n"
			 . "List administration can be found at:\n"
			 . "".$project->getTypeMailingListAdminUrl($new_list_name)."\n\n"
			 . "Your list password is: $list_password\n"
			 . "You are encouraged to change this password as soon as possible.\n\n"
			 . "Thank you for registering your project with Savannah.\n\n"
			 . " -- the Savannah volunteers\n";

		      sendmail_mail ($GLOBALS[sys_replyto],
				     $row_email['email'],
				     "Savannah New Mailing List",
				     $message);

		      " Email sent with details to: $row_email[email] ";

		    }
		}
	      else
		{ " Invalid List Name: ".$new_list_name; }

	    }
	  else
	    {
	      # No mail host defined, just update the database
	      $result=db_query("SELECT * FROM mail_group_list WHERE lower(list_name)='$new_list_name'");


	      if (db_numrows($result) > 0)
		{
		  " ERROR - List Already Exists ";
		}
	      else
		{
		  $sql = "INSERT INTO mail_group_list "
		     . "(group_id,list_name,is_public,password,list_admin,status,description) VALUES ("
		     . "$group_id,"
		     . "'$new_list_name',"
		     . "'$is_public',"
		     . "'$list_password',"
		     . "'".user_getid()."',"
		     . "1,"
		     . "'". htmlspecialchars($description) ."')";

		  $result=db_query($sql);

		  if (!$result)
		    {
		      " Error Adding List ";
		      print db_error();
		    }
		  else
		    {
		      " List Added ";
		    }
		}
	    }

	} else if ($change_status) {
	  # list name is fixed
	  $sql="UPDATE mail_group_list SET is_public='$is_public', ".
	     "description='". htmlspecialchars($description) ."' ".
	     "WHERE group_list_id='$group_list_id' AND group_id='$group_id'";
	  $result=db_query($sql);
	  if (!$result || db_affected_rows($result) < 1)
	    {
	      " Error Updating Status ";
	      print db_error();
	    }
	  else
	    {
	      " Status Updated Successfully ";
	    }
	}

    }

  /***********************************************************
	Show forms to make changes
  ***********************************************************/

  # Show the form for adding lists
  if ($add_list)
    {

      site_project_header(array('title'=>_("Add a Mailing List"),'group'=>$group_id,'toptab'=>'amail'));

      utils_get_content("mail/about_list_creation");

      $result = db_query("SELECT list_name,group_list_id FROM mail_group_list WHERE group_id='$group_id'");
      $rows=db_numrows($result);

      print '<h3>Mailing Lists already in use</h3>';
      for ($k=0; $k < $rows; $k++)
	{
	  echo '<div class="'.utils_get_alt_row_color($k).'">'.db_result($result, $k, "list_name").'</div>';
	}

      print '
			<p>
			<form method="post" action="'.$PHP_SELF.'">
			<input type="hidden" name="post_changes" value="y">
			<input type="hidden" name="add_list" value="y">
			<input type="hidden" name="group_id" value="'.$group_id.'">
			<h3>Mailing List Name:</h3> ';

      if ($isgnu == true)
	{ print '<INPUT TYPE="radio" NAME="type" VALUE="0" CHECKED>'; }

      print $project->getTypeMailingListAddress($project->getTypeMailingListFormat('<input type="text" name="list_name" value="" size="25" maxlenght="70">'));

      if ($isgnu == true)
	{
	  print '
			<BR>
			<INPUT TYPE="radio" NAME="type" VALUE="1">bug-'.group_getunixname($group_id).'<BR>
			<INPUT TYPE="radio" NAME="type" VALUE="2">help-'.group_getunixname($group_id).'<BR>
			<INPUT TYPE="radio" NAME="type" VALUE="3">info-'.group_getunixname($group_id).'<BR>';
	}


      print '
			<P></P>
			<h3>Is Public ?</h3> (visible for non-developers)<BR>
			<INPUT TYPE="RADIO" NAME="is_public" VALUE="1" CHECKED> Yes<BR>
			<INPUT TYPE="RADIO" NAME="is_public" VALUE="0"> No<P></P>
			<B>Description:</B><BR>
			<INPUT TYPE="TEXT" NAME="description" VALUE="" SIZE="40" MAXLENGTH="80"><BR>
			<P></P>
			<INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Add This List">
			</FORM>';

      site_project_footer(array());

    }
  else if ($change_status)
    {
      # Show the form to modify lists status

    site_project_header(array('title'=>_("Update Mailing List"),'group'=>$group_id,'toptab'=>'amail'));

    $sql="SELECT list_name,group_list_id,is_public,description ".
       "FROM mail_group_list ".
       "WHERE group_id='$group_id'";
    $result=db_query($sql);
    $rows=db_numrows($result);

    if (!$result || $rows < 1)
      {
	print '
				<H2>No Lists Found</H2>
				<P>
				None found for this project';
	print db_error();
      }
    else
      {
	print '<p>';
	print _("You can administrate list information from here. Please note that private lists are only displayed for members of your project, but not for visitors who are not logged in.")."<br />\n";
	print _("Note that if you change the status of the mailing list to \"Deleted\", it will have no other effect than the list is no longer displayed to the developers and visitors.");
	print "</p>\n";

	$title_arr=array();
	$title_arr[]=_("List");
	$title_arr[]=_("Description");
	$title_arr[]=_("Is Public?");
	$title_arr[]=_("Update");
	if ($project->getTypeMailingListAdminUrl())
	  { $title_arr[]=_("List Admin"); }

	print html_build_list_table_top ($title_arr);

	for ($i=0; $i<$rows; $i++)
	  {
	    print '<tr class="'. utils_get_alt_row_color($i) .'">';
	    print '
					<FORM ACTION="'.$PHP_SELF.'" METHOD="POST">
                                        <TD><BR>'.db_result($result,$i,'list_name').'</TD>
<td>
<INPUT TYPE="TEXT" NAME="description" VALUE="'.db_result($result,$i,'description') .'" SIZE="40" MAXLENGTH="80">
</td>
<td>
<INPUT TYPE="HIDDEN" NAME="post_changes" VALUE="y">
<INPUT TYPE="HIDDEN" NAME="change_status" VALUE="y">
<INPUT TYPE="HIDDEN" NAME="group_list_id" VALUE="'.db_result($result,$i,'group_list_id').'">
<INPUT TYPE="HIDDEN" NAME="group_id" VALUE="'.$group_id.'">
<INPUT TYPE="RADIO" NAME="is_public" VALUE="1"'.((db_result($result,$i,'is_public')=='1')?' CHECKED':'').'> '._("Yes").'<BR>
<INPUT TYPE="RADIO" NAME="is_public" VALUE="0"'.((db_result($result,$i,'is_public')=='0')?' CHECKED':'').'> '._("No").'<BR>
<INPUT TYPE="RADIO" NAME="is_public" VALUE="9"'.((db_result($result,$i,'is_public')=='9')?' CHECKED':'').'> '._("Deleted").'<BR>
					</TD><TD>
						<FONT SIZE="-1">
			<INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="'._("Update").'">
					</TD>
					<TD>';
	    if ($project->getTypeMailingListAdminUrl())
	      {
		print '<A href="'.$project->getTypeMailingListAdminUrl(db_result($result,$i,'list_name')).'">['._("Administrate this list").']</a>';

		print '
				       </TD></TR></FORM>';
	      }
	  }
	print '</TABLE>';
      }

    site_project_footer(array());

    }
  else if ($migrate)
    {

      # Note: I did not checked that part of the code, that should remain
      # unchanged. Hope it will still work.
      # yeupou@gnu.org 2003-09-24
      site_project_header(array('title'=>_("Migrate Mailing Lists"),'group'=>$group_id,'toptab'=>'amail'));

      if ($isgnu == false)
	{
	  print '<STRONG> This function is only useful for GNU projects';
	  site_project_footer(array());
	  exit;
	}


      if ( $list && $password )
	{

	  $site = $project->getTypeMailingListListinfoUrl();
	  $site .= '../sfverify?list=';
	  #$site = "http://mail.gnu.org/mailman/sfverify?list=";
	  $site .= urlencode($list);
	  $site .= "&password=";
	  $site .= urlencode($password);
	  $file = fopen("$site","r");
	if (!$file)
	  {
	    print "<p>Unable to open remote file.\n";
	    site_project_footer(array());
	    exit;
	  }
	$next = 0;
	$result = "";
	while (!feof ($file))
	  {
	    $line = fgets ($file, 1024);
	    if ( $next == 1 )
	      {
		break;
	      } elseif (eregi("\<BODY\>",$line,$void)) {
		$next = 1;
	      }

	  }
	fclose($file);

	$parse = explode(" ",$line);
	$parse[0] = substr($parse[0],0,1);
	if ( $parse[0] == "0" )
	  {
	    print("<STRONG>$list@gnu.org does not exist</STRONG>");
	  } elseif ($parse[0] == "2") {
	    print ("<STRONG>The password you supplied for $list@gnu.org is incorrect</STRONG>");
	  } else {
	    $admin_email = addslashes($parse[1]);
	    $is_public = addslashes($parse[2]);
	    $desc = $parse[3]; # join(array_slice($parse,3)," ");
	    $sql =  "SELECT list_name ".
	       "FROM mail_group_list ".
	       "WHERE list_name = '".addslashes($list)."'";
	    $result = db_query($sql);
	    if ( ! $result )
	      {
		print db_error();
		site_project_footer(array());
		exit;
	      }
	    $rows = db_numrows($result);
	    if ( $rows > 0 )
	      {
		print("<STRONG>This list has already been attached</STRONG");
	      } else {

		$password = "pass";
		$sql = "INSERT INTO mail_group_list "
		   . "(group_id,list_name,is_public,password,list_admin,status,description) VALUES ("
		   . "$group_id,"
		   . "'".addslashes($list)."',"
		   . "'$is_public',"
		   . "'".addslashes($password)."',"
		   . "'".user_getid()."',"
		   . "1,"
		   . "'". addslashes(htmlspecialchars($desc)) ."')";


		$result=db_query($sql);
		if (!$result) {
		  print("<STRONG>Error Adding List</STRONG>");
		  print db_error();
		} else {
		  print("<STRONG>$list has been attached</STRONG>");
		}

	      }
	  }

	site_project_footer(array());

	} else {

	  if ( $isgnu == false) {
	    print '<STRONG> This function is only useful for GNU projects';
	    site_project_footer(array());
	    exit;
	  }

	  print '
			<H2>Attach an existing Mailing List</H2>
			<P>';

	  print '
			<FORM ACTION="'.$PHP_SELF.'" METHOD="GET">
			<INPUT TYPE=hidden name=migrate value=1>
			<INPUT TYPE=hidden name=group_id value='.$group_id.'>
			<TABLE WIDTH="100%" BORDER="0" CELLSPACING="1" CELLPADDING="2">';
	  print '
				<TR class="'. utils_get_alt_row_color($i) .'"><TD>List name (<a href=http://mail.gnu.org/mailman/listinfo>all the public lists</a>)</TD><TD><INPUT type=text name=list></TD></TR>
				<TR BGCOLOR="'. utils_get_alt_row_color($i) .'"><TD>List Administrative Password</TD><TD><INPUT type=password name=password></TD></TR>';

	  print '
				</TABLE>
				<INPUT TYPE=submit VALUE="Attach to '.group_getunixname($group_id).'"></FORM>
			    <DD>If a mailing list already exists for the '.group_getunixname($group_id).' project but is not <a href=/mail/?group_id='.$group_id.'>listed</a>, you can fix this. By telling Savannah that a mailing list that <a href=http://mail.gnu.org/mailman/listinfo>shows on mail.gnu.org</a> is indeed related to the '.group_getunixname($group_id).' project, you make it easier for contributors and users to find it. Note that this step is not necessary if you create a mailing list using Savannah: it will be done automatically. But it is necessary if the mailing list existed before the project was created on Savannah.
                <DD>Private mailing lists can also be attached to Savannah. Those mailing list are not shown in the <a href=http://mail.gnu.org/mailman/listinfo>listinfo</a> page but will be taken anyway. Pointers to the mailing list archives and subscription forms will be <a href=/mail/?group_id='.$group_id.'>shown to your developers</a> and will therefore slightly reduce the privacy of the list. The public will not be able to see the archives or subscribe automatically to the private list since Mailman controls this by the use of a password. ';

	}

      site_project_footer(array());


    }
  else
    {
      /**********************************************************
			Show main page for choosing
			either moderotor or delete
      ***********************************************************/
    site_project_header(array('group'=>$group_id,'toptab'=>'amail'));

    print '
<h3><A HREF="'.$PHP_SELF.'?group='.$group_name.'&add_list=1">'._("Add Mailing List").'</A></h3><DD>'._("You can create mailing lists for your project using the web interface.").'</DD>

<h3><A HREF="'.$PHP_SELF.'?group_id='.$group_id.'&change_status=1">'._("Administrate/Update Lists").'</A></h3><DD>'._("Update information on existing mailing lists and change their policy.").'</DD>
			';

    if ($isgnu == true)
      {
	print '
<h3><A HREF="'.$PHP_SELF.'?group_id='.$group_id.'&migrate=1">Attach  a mailing list</A></h3>
<DD>If a mailing list already exists for the '.group_getunixname($group_id).' project but is not <a href=/mail/?group_id='.$group_id.'>listed</a>, you can fix this. By telling Savannah that a mailing list that <a href=http://mail.gnu.org/mailman/listinfo>shows on mail.gnu.org</a> is indeed related to the '.group_getunixname($group_id).' project, you make it easier for contributors and users to find it. Note that this step is not necessary if you create a mailing list using Savannah: it will be done automatically. But it is necessary if the mailing list existed before the project was created on Savannah. </DD>
	';
      }
    site_project_footer(array());
    }

}
else
{
  /*
		Not logged in or insufficient privileges
  */
  if (!$group_id)
    { exit_no_group(); }
  else
    { exit_permission_denied(); }
}
?>