<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: userperms.php,v 1.30 2004/09/22 08:11:52 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../../include/pre.php";    

session_require(array('group'=>$group_id,'admin_flags'=>'A'));

if ($update)  
{
  # ##### Update members permissions
  
  $res_dev = db_query("select user_id FROM user_group WHERE group_id=$group_id");
  while ($row_dev = db_fetch_array($res_dev)) 
    {
      # admin are not allowed to turn off their own admin flag
      # it is too dangerous -- set it back to 'A'
      if (user_getid() == $row_dev['user_id']) 
	{
	  $admin_flags="admin_user_$row_dev[user_id]";
	  $$admin_flags='A';
	} 
      else 
	{
	  $admin_flags="admin_user_$row_dev[user_id]";
	}
      $bugs_flags="bugs_user_$row_dev[user_id]";
      $task_flags="task_user_$row_dev[user_id]";
      $patch_flags="patch_user_$row_dev[user_id]";
      $support_flags="support_user_$row_dev[user_id]";
      $news_flags="news_user_$row_dev[user_id]";
      
      $sql = 'UPDATE user_group SET ' 
	 ."admin_flags='".$$admin_flags."',"
	 ."bugs_flags=".$$bugs_flags.","
	 ."news_flags=".$$news_flags.","
	 ."task_flags=".$$task_flags.", "
	 ."patch_flags=".$$patch_flags.", "
	 ."support_flags=".$$support_flags." "
	 ."WHERE user_id='$row_dev[user_id]' AND group_id='$group_id'";

      $result = db_query($sql);
      $name = user_getname($row_dev['user_id']);

      if ($result) 
	{
	  group_add_history('Changed User Permissions',
			    $name,
			    $group_id);
	  $feedback_able .= $name.", ";
	}
      else
	{
	  print db_error();
	  $feedback_unable .= $name.", ";
	}
    }
        
  if ($feedback_able)
    { 
      fb(sprintf(_("permissions for %s updated."), rtrim($feedback_able, ', '))); 

    }
  
  if ($feedback_unable)
    { 
      fb(sprintf(_("failed to update %s permissions."), rtrim($feedback_unable, ', '))); 
    }
  

  # ##### Update group default permissions
  
  $bugs_flags="bugs_user_";
  $task_flags="task_user_";
  $patch_flags="patch_user_";
  $support_flags="support_user_";
  $news_flags="news_user_";

  # If the group entry do not exists, create it
  if (!db_result(db_query("SELECT groups_default_permissions_id FROM groups_default_permissions WHERE group_id='$group_id'"), 0, "groups_default_permissions_id"))
    {
      db_query("INSERT INTO groups_default_permissions (group_id) VALUES ($group_id)"); 
    }
  
  # Update the table
  $sql = 'UPDATE groups_default_permissions SET ' 
     ."bugs_flags=".$$bugs_flags.","
     ."news_flags=".$$news_flags.","
     ."task_flags=".$$task_flags.", "
     ."patch_flags=".$$patch_flags.", "
     ."support_flags=".$$support_flags." "
     ."WHERE group_id='$group_id'";
  
  $result = db_query($sql);
  
  if ($result) 
    {
      group_add_history('Changed Group Default Permissions','',$group_id);
      fb(_("Permissions for the group updated."));

    }
  else
    {
      print db_error();
      fb(_("Unable to change group defaults permissions."), 0);
    }

  # ##### Update posting restrictions

  $bugs_flags="bugs_restrict";
  $task_flags="task_restrict";
  $patch_flags="patch_restrict";
  $support_flags="support_restrict";
  $news_flags="news_restrict";
  
  # Update the table
  $sql = 'UPDATE groups_default_permissions SET ' 
     ."bugs_rflags=".$$bugs_flags.","
     ."news_rflags=".$$news_flags.","
     ."task_rflags=".$$task_flags.", "
     ."patch_rflags=".$$patch_flags.", "
     ."support_rflags=".$$support_flags." "
     ."WHERE group_id='$group_id'";
  
  $result = db_query($sql);
  
  if ($result) 
    {
      group_add_history('Changed Posting Restrictions','',$group_id);
      fb(_("Posting restrictions updated."));

    }
  else
    {
      print db_error();
      fb(_("Unable to change posting restrictions."), 0);
    }

  
}



# start HTML
site_project_header(array('title'=>_("Permissions Management"),'group'=>$group_id,'toptab'=>'ahome'));


$sql = "select user.user_name AS user_name,"
. "user.user_id AS user_id, "
. "user_group.admin_flags, "
. "user_group.bugs_flags, "
. "user_group.forum_flags, "
. "user_group.task_flags, "
. "user_group.patch_flags, "
. "user_group.news_flags, "
. "user_group.support_flags "
. "FROM user,user_group WHERE "
. "user.user_id=user_group.user_id AND user_group.group_id=$group_id AND user_group.admin_flags<>'P'"
. "ORDER BY user.user_name";

$result = db_query($sql);

member_explain_roles();

########################### GROUP DEFAULTS

$title_arr=array();
$title_arr[]=_("Support Tracking");
$title_arr[]=_("Bug Tracking");
$title_arr[]=_("Task Tracking");
$title_arr[]=_("Patch Tracking");
$title_arr[]=_("News");

print '<form action="'.$PHP_SELF.'" method="post">
<input type="hidden" name="group" value="'.$group_name.'">';

print '<h3>'._("Group Default Permissions").'</h3>';
print html_build_list_table_top ($title_arr);

html_select_permission_box("support", group_getpermissions($group_id, "support"), "group");
html_select_permission_box("bugs", group_getpermissions($group_id, "bugs"), "group");
html_select_permission_box("task", group_getpermissions($group_id, "task"), "group");
html_select_permission_box("patch", group_getpermissions($group_id, "patch"), "group");     
html_select_permission_box("news", group_getpermissions($group_id, "news"), "group");


print '  </tr>
</table>
<p align="center"><input type="submit" name="update" value="'._("Update Permissions").'"></p>';


########################### PER MEMBERS

if (!$result || db_numrows($result) < 1) 
{
  print '<h2>'._("No Members Found").'</h2>';
} 
else 
{
  # If we have more than 15 users, do not print list with selectboxes,
  # it does not scale, the page would be too big.
  
  print '<p>&nbsp;</p>';

  $title_arr=array();
  $title_arr[]=_("Login");
  $title_arr[]=_("Project Admin");
  $title_arr[]=_("Support Tracking");
  $title_arr[]=_("Bug Tracking");
  $title_arr[]=_("Task Tracking");
  $title_arr[]=_("Patch Tracking");
  $title_arr[]=_("News");


  print '<h3>'._("Permissions per member").'</h3>';
  print html_build_list_table_top ($title_arr);

  # a function for this specific stuff that do not require generalization
    
  while ($row = db_fetch_array($result)) 
   {
     $i++;
     print '
  <tr class="'. utils_get_alt_row_color($i) .'">
    <td>'.utils_user_link($row['user_name']).'</td>';
     print '
    <td>
      <input type="radio" name="admin_user_'.$row['user_id'].'" value="A" '.(($row['admin_flags']=='A')?'checked':'').'> '._("Yes").'<br />
      <input type="radio" name="admin_user_'.$row['user_id'].'" value="" '.(($row['admin_flags']=='')?'checked':'').'> '._("No").'
    </td>';

     html_select_permission_box("support", $row);
     html_select_permission_box("bugs", $row);
     html_select_permission_box("task", $row);
     html_select_permission_box("patch", $row);     
     html_select_permission_box("news", $row);
  
     print '  </tr>';
  
   }
    
  print '
</table>
<p align="center"><input type="submit" name="update" value="'._("Update Permissions").'"></p>';

  
########################### POSTING RESTRICTIONS
# Exists also in trackers config (missing for news).

  print '<p>&nbsp;</p>';
  
  $title_arr=array();
  $title_arr[]="";
  $title_arr[]=_("Support Tracking");
  $title_arr[]=_("Bug Tracking");
  $title_arr[]=_("Task Tracking");
  $title_arr[]=_("Patch Tracking");
  $title_arr[]=_("News");

  print '<h3>'._("Posting restrictions").'</h3>';

  print html_build_list_table_top ($title_arr);
 
  $i++;
  print '
  <tr class="'. utils_get_alt_row_color($i) .'">
    <td>'._("Authentication level required").'</td>';
  html_select_restriction_box("support", group_getrestrictions($group_id, "support"));
  html_select_restriction_box("bugs", group_getrestrictions($group_id, "bugs"));
  html_select_restriction_box("task", group_getrestrictions($group_id, "task"));
  html_select_restriction_box("patch", group_getrestrictions($group_id, "patch")); 
  html_select_restriction_box("news", group_getrestrictions($group_id, "news"));
  print '  </tr>';
   
  print '
</table>
<p align="center"><input type="submit" name="update" value="'._("Update Permissions").'"></p></form>';


}


project_admin_footer(array());
?>
