<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: general.php,v 1.12 2005/04/11 21:38:02 toddy Exp $
#
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2005 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function my_hide_url ($svc, $db_item_id, $item_id, $count, $hide, $link="")
{
/*
  Function that generates hide/show urls to expand/collapse
  sections of the personal page

Input:
  $svc : artifact
  $db_item_id : the item (group, forum, task sub-project,...) from the
     database that we are curently processing and about to display
  $item_id : the item_id as given in the URL and on which the show/hide switch
     is going to apply.
  $hide = hide param as given in the script URL (-1 means no param was given)

Output:
  $hide_url: URL to use in the page to switch from hide to show or vice versa
  $count_diff: difference between the number of items in the list between now and
     the previous last time the section was open (can be negative if items were removed)
  $hide_flag: true if the section must be hidden, false otherwise

*/

  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_hide_url ($svc, $db_item_id, $item_id, $count, $hide) ';
  global $PHP_SELF;

  $pref_name = 'my_hide_'.$svc.$db_item_id;
  $old_pref_value = user_get_preference($pref_name);
  list($old_hide,$old_count) = explode('|', $old_pref_value);

  # Make sure they are both 0 if never set before
  if ($old_count == false) { $old_count = 0; }
  if ($old_hide == false) { $old_hide = 0; }

  if ($item_id == $db_item_id)
    {
      if (isset($hide))
	{
	  $pref_value = "$hide|$count";
	}
      else
	{
	  $pref_value = "$old_hide|$count";
	  $hide = $old_hide;
	}
    }
  else
    {
      if ($old_hide)
	{
	  # if items are hidden keep the old count and keep pref as is
	  $pref_value = $old_pref_value;
	}
      else
	{
	  # only update the item count if the items are visible
	  # if they are hidden keep reporting the old count
	  $pref_value = "$old_hide|$count";
	}
      $hide = $old_hide;
    }

  # Update pref value if needed
  if ($old_pref_value != $pref_value)
    {
      user_set_preference($pref_name, $pref_value);
    }

  if ($hide)
    {
      $hide_url= '<a href="'.$PHP_SELF.'?hide_'.$svc.'=0&amp;hide_group_id='.$db_item_id.'"><img src="'.$GLOBALS['sys_home'].'images/'. SV_THEME.'.theme/next.png" class="icon" alt="'._("Collapse").'" />'.$link.'</a>';
      $hide_now = true;
    }
  else
    {
      $hide_url= '<a href="'.$PHP_SELF.'?hide_'.$svc.'=1&amp;hide_group_id='.$db_item_id.'"><img src="'.$GLOBALS['sys_home'].'images/'. SV_THEME.'.theme/down.png" class="icon" alt="'._("Expand").'" />'.$link.'</a>';
      $hide_now = false;
    }

  return array($hide_now, $count-$old_count, $hide_url);
}

function my_format_as_flag($assigned_to, $submitted_by)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_format_as_flag($assigned_to, $submitted_by) ';
  $AS_flag = '';
  if ($assigned_to == user_getid())
    {
      $AS_flag = 'A';
    }
  if ($submitted_by == user_getid())
    {
      $AS_flag .= 'S';
    }
  if ($AS_flag) { $AS_flag = '[<b>'.$AS_flag.'</b>]'; }

  return $AS_flag;
}

function my_item_count($total, $new)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_item_count($total, $new) ';
  $ret = '(';
  $ret .= sprintf(ngettext("%s item", "%s items", $total), $total);
  if ($new)
    {
      $ret .= ", <b>".sprintf(ngettext("%s new", "%s new", $new), $new)."</b>";
    }
  $ret .= ')';
  return $ret;
}


function my_item_list ($role="assignee", $threshold="5", $status="open") {
  # status: 1 = open, 3 = closed
  if ($status == "open") { $status = 1; }
  if ($status == "closed") { $status = 3; }

  # threshold: based on priority
  $uid = user_getid();

  $items_per_groups = array();
  $groups = array();

  $item_date = array();
  $item_priority = array();
  $item_resolution_id = array();
  $item_summary = array();

  $trackers = array("support", "bugs", "task", "patch");
  $results = 0;


  # Get a timestamp to get new items (15 days)
  $new_date_limit = mktime(date("H"),
			   date("i"),
			   0,
			   date("m"),
			   date("d")-15,
			   date("Y"));


  while (list(, $tracker) = each($trackers))
    {
      $sql = 'SELECT '.$tracker.'.bug_id,'.$tracker.'.date,'.$tracker.'.priority,'.$tracker.'.resolution_id,'.$tracker.'.summary,groups.group_id,groups.group_name,groups.unix_group_name FROM '.$tracker.',groups '.
	'WHERE groups.group_id='.$tracker.'.group_id '.
	'AND '.$tracker.'.status_id='.$status.' '.
	'AND ('.$tracker.'.priority >= '.$threshold.' OR  '.$tracker.'.date > '.$new_date_limit.') ';
      if ($role == "assignee")
	{ $sql .= 'AND '.$tracker.'.assigned_to='.$uid.' '; }
      else
	{
          # If the submitter is also the owner, we ll show it in the assigned
          # list, which matters more than the fact he is submitter
	  $sql .= 'AND '.$tracker.'.assigned_to<>'.$uid.' AND '.$tracker.'.submitted_by='.$uid.' ';
	}
      $sql .= 'ORDER BY '.$tracker.'.date DESC ';
      $result=db_query($sql);
      $rows=db_numrows($result);
      if ($result && $rows > 0)
	{
	  $results = 1;
	  for ($j=0; $j<$rows; $j++)
	    {
	      # Create item unique name
	      $thisitem = $tracker.'#'.db_result($result,$j,'bug_id');

	      # Store data
	      $item_date[$thisitem] = db_result($result,$j,'date');
	      $item_priority[$thisitem] = db_result($result,$j,'priority');
	      $item_status[$thisitem] = db_result($result,$j,'resolution_id');
	      $item_summary[$thisitem] = db_result($result,$j,'summary');

	      # Associate with the relevant group
	      $thisgroup = db_result($result,$j,'unix_group_name');
	      if (array_key_exists($thisgroup, $items_per_groups))
		{ $items_per_groups[$thisgroup] = $items_per_groups[$thisgroup].','.$thisitem; }
	      else
		{ $items_per_groups[$thisgroup] = $thisitem; }
	      if (!array_key_exists($thisgroup, $groups))
		{ $groups[$thisgroup] = db_result($result,$j,'group_name'); }

	    }
	}
    }

  # Break here if we have no results
  if (!$results)
    {
      print _("None found");
      return false;
    }

  # Go thru the group list and list items
  asort($groups);
  while (list($thisgroup,$thisgroupfullname) = each($groups))
    {
      $thisgroupid = group_getid($thisgroup);

      $theseitems = array();
      $theseitems = explode(",", $items_per_groups[$thisgroup]);

      # Put the content in an array well sort later according to the
      # date
      $thisgroupcontent = array();
      while (list(,$thisitem) = each($theseitems))
	{
          list($tracker, $item_id) = explode("#", $thisitem);
          $prefix = utils_get_tracker_prefix($tracker);
	  $icon = utils_get_tracker_icon($tracker);

          $dstatus = db_result(db_query("SELECT value FROM ".$tracker."_field_value WHERE bug_field_id='108' AND (group_id='".$thisgroupid."' OR group_id='100') AND value_id='".$item_status[$thisitem]."' ORDER BY bug_fv_id  DESC LIMIT 1"), 0, 'value');

	  $thisgroupcontent[$item_date[$thisitem].$thisitem] = '<div class="'.utils_get_priority_color($item_priority[$thisitem], $status).'">'.
	    '<a href="'.$GLOBALS['sys_home'].$tracker.'/?func=detailitem&amp;item_id='.$item_id.'">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.$icon.'.png" class="icon" alt="'.$tracker.'" />'.
	    $prefix .' #'.$item_id.'</a>'.
	    _(": ").'&nbsp;'.
	    '<a href="'.$GLOBALS['sys_home'].$tracker.'/?func=detailitem&amp;item_id='.$item_id.'">'.stripslashes($item_summary[$thisitem]).'</a>'.
	    '&nbsp;<font class="smaller">['.$dstatus.']</font></div>';

	}
      arsort($thisgroupcontent);
      $count = count($thisgroupcontent);

      list($hide_now,$count_diff,$hide_url) = my_hide_url($role,$thisgroupid,$GLOBALS['hide_group_id'],$count,$GLOBALS['hide_'.$role], '&nbsp;<b>'.$thisgroupfullname.'</b>');

      print '<div class="boxitem">'.$hide_url.' <font class="smaller">'.my_item_count($count,max(0, $count_diff)).'</font></div>';

      if (!$hide_now)
        {
          while (list(,$line) = each($thisgroupcontent))
           {
             print $line;
           }
        }
      print '<br />';

    }


}


function my_incoming_unassigned_item_list ($groups) {
  $uid = user_getid();

  $items_per_groups = array();
  $groups_with_items = array();

  $item_date = array();
  $item_priority = array();
  $item_resolution_id = array();
  $item_summary = array();

  $trackers = array("support", "bugs", "task", "patch");
  $results = 0;


  # Get a timestamp to get new items (15 days)
  $new_date_limit = mktime(date("H"),
			   date("i"),
			   0,
			   date("m"),
			   date("d")-15,
			   date("Y"));


  while (list(, $tracker) = each($trackers))
    {
      $sql = 'SELECT '.$tracker.'.bug_id,'.$tracker.'.date,'.$tracker.'.priority,'.$tracker.'.resolution_id,'.$tracker.'.summary,groups.group_id,groups.group_name,groups.unix_group_name FROM '.$tracker.',groups '.
	'WHERE groups.group_id='.$tracker.'.group_id '.
	'AND '.$tracker.'.status_id=1 '.
	'AND '.$tracker.'.date > '.$new_date_limit.' '.
	'AND '.$tracker.'.assigned_to=100 AND (';

      # Go thru the list of groups to find out if any is relevant
      $previous = 0;
      reset($groups);
      while (list($group, $groupname) = each ($groups))
	{
          # Interesting only if the user got manager rights
	  $id = group_getid($group);
	  if (member_check(0, $id, member_create_tracker_flag($tracker).'3'))
	    {
	      if ($previous) { $sql .= "OR "; }
	      $sql .= "$tracker.group_id='".$id."' ";
	      $previous = 1;
	    }
	}

      $sql .= ') ORDER BY '.$tracker.'.date DESC ';

      # Go to the next tracker if the user have no manager right on any
      # projects of this tracker
      if (!$previous)
	{ continue; }

      $result=db_query($sql);
      $rows=db_numrows($result);

      if ($result && $rows > 0)
	{
	  $results = 1;
	  for ($j=0; $j<$rows; $j++)
	    {
	      # Create item unique name
	      $thisitem = $tracker.'#'.db_result($result,$j,'bug_id');

	      # Store data
	      $item_date[$thisitem] = db_result($result,$j,'date');
	      $item_priority[$thisitem] = db_result($result,$j,'priority');
	      $item_status[$thisitem] = db_result($result,$j,'resolution_id');
	      $item_summary[$thisitem] = db_result($result,$j,'summary');

	      # Associate with the relevant group
	      $thisgroup = db_result($result,$j,'unix_group_name');
	      if (array_key_exists($thisgroup, $items_per_groups))
		{ $items_per_groups[$thisgroup] = $items_per_groups[$thisgroup].','.$thisitem; }
	      else
		{ $items_per_groups[$thisgroup] = $thisitem; }
	      if (!array_key_exists($thisgroup, $groups_with_items))
		{ $groups_with_items[$thisgroup] = db_result($result,$j,'group_name'); }

	    }
	}
    }

  # Break here if we have no results
  if (!$results)
    { return false; }

  # Print the title (here in the function because we do not want to show
  # this table to people that are not even project member).
  print '<br /><div class="boxtitle">'._("New and Unassigned Items").'</div>';

  # Go thru the group list and list items
  asort($groups_with_items);
  while (list($thisgroup,$thisgroupfullname) = each($groups_with_items))
    {
      $thisgroupid = group_getid($thisgroup);

      $theseitems = array();
      $theseitems = explode(",", $items_per_groups[$thisgroup]);

      # Put the content in an array we ll sort later according to the
      # date
      $thisgroupcontent = array();
      while (list(,$thisitem) = each($theseitems))
	{
          list($tracker, $item_id) = explode("#", $thisitem);
          $prefix = utils_get_tracker_prefix($tracker);
	  $icon = utils_get_tracker_icon($tracker);

          $dstatus = db_result(db_query("SELECT value FROM ".$tracker."_field_value WHERE bug_field_id='108' AND (group_id='".$thisgroupid."' OR group_id='100') AND value_id='".$item_status[$thisitem]."' ORDER BY bug_fv_id  DESC LIMIT 1"), 0, 'value');

	  $thisgroupcontent[$item_date[$thisitem].$thisitem] = '<div class="'.utils_get_priority_color($item_priority[$thisitem], $status).'">'.
	    '<a href="'.$GLOBALS['sys_home'].$tracker.'/?func=detailitem&amp;item_id='.$item_id.'">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.$icon.'.png" class="icon" alt="'.$tracker.'" />'.
	    $prefix .' #'.$item_id.'</a>'.
	    _(": ").'&nbsp;'.
	    '<a href="'.$GLOBALS['sys_home'].$tracker.'/?func=detailitem&amp;item_id='.$item_id.'">'.stripslashes($item_summary[$thisitem]).'</a>'.
	    '&nbsp;<font class="smaller">['.$dstatus.']</font></div>';

	}
      arsort($thisgroupcontent);
      $count = count($thisgroupcontent);

      list($hide_now,$count_diff,$hide_url) = my_hide_url("unassigned",$thisgroupid,$GLOBALS['hide_group_id'],$count,$GLOBALS['hide_unassigned'], '&nbsp;<b>'.$thisgroupfullname.'</b>');

      print '<div class="boxitem">'.$hide_url.' <font class="smaller">'.my_item_count($count,max(0, $count_diff)).'</font></div>';

      if (!$hide_now)
        {
          while (list(,$line) = each($thisgroupcontent))
           {
             print $line;
           }
        }
      print '<br />';

    }


}


function my_incoming_assigned_item_list ($groups) {
  $uid = user_getid();

  $items_per_groups = array();
  $groups_with_items = array();

  $item_date = array();
  $item_priority = array();
  $item_resolution_id = array();
  $item_summary = array();

  $trackers = array("support", "bugs", "task", "patch");
  $results = 0;


  # Get a timestamp to get new items (15 days)
  $new_date_limit = mktime(date("H"),
			   date("i"),
			   0,
			   date("m"),
			   date("d")-15,
			   date("Y"));


  while (list(, $tracker) = each($trackers))
    {
      # We need two different SQL commands to find newly assigned item
      # that are in fact completely new items, with no history, and assigned
      # item that may be very very old but that were assigned recently to the
      # user

      # We'll ignore item self-assigned.
      $cases = array("assignedonsubmission", "assignedafterwards");
      while (list(, $case) = each($cases))
	{
	  if ($case == "assignedafterwards")
	    {
	      $sql = 'SELECT '.$tracker.'.bug_id,'.$tracker.'_history.date,'.$tracker.'.priority,'.$tracker.'.resolution_id,'.$tracker.'.summary,groups.group_id,groups.group_name,groups.unix_group_name FROM '.$tracker.','.$tracker.'_history,groups '.
		'WHERE groups.group_id='.$tracker.'.group_id '.
		'AND '.$tracker.'_history.bug_id='.$tracker.'.bug_id '.
		'AND '.$tracker.'_history.new_value='.$uid.' '.
		'AND '.$tracker.'_history.old_value<>'.$uid.' '.
		'AND '.$tracker.'_history.mod_by<>'.$uid.' '.
		'AND '.$tracker.'_history.field_name="assigned_to" '.
		'AND '.$tracker.'.status_id=1 '.
		'AND '.$tracker.'_history.date > '.$new_date_limit.' '.
		'AND '.$tracker.'.assigned_to='.$uid.'  AND (';

              # Go thru the list of groups to find out if any is relevant
	      $previous = 0;
	      reset($groups);
	      while (list($group, $groupname) = each ($groups))
		{
		  $id = group_getid($group);
# Interesting only if the user got technician rights
		  if (member_check(0, $id, member_create_tracker_flag($tracker).'1'))
		    {
		      if ($previous) { $sql .= "OR "; }
		      $sql .= "$tracker.group_id='".$id."' ";
		      $previous = 1;
		    }
		}

	      $sql .= ') ORDER BY '.$tracker.'_history.date DESC ';
	    }
	  else
	    {
	      $sql = 'SELECT '.$tracker.'.bug_id,'.$tracker.'.date,'.$tracker.'.priority,'.$tracker.'.resolution_id,'.$tracker.'.summary,groups.group_id,groups.group_name,groups.unix_group_name FROM '.$tracker.',groups '.
		'WHERE groups.group_id='.$tracker.'.group_id '.
		'AND '.$tracker.'.status_id='.$status.' '.
		'AND '.$tracker.'.date > '.$new_date_limit.' '.
		'AND '.$tracker.'.submitted_by<>'.$uid.' '.
		'AND '.$tracker.'.assigned_to='.$uid.' AND (';

              # Go thru the list of groups to find out if any is relevant
	      $previous = 0;
	      reset($groups);
	      while (list($group, $groupname) = each ($groups))
		{
		  $id = group_getid($group);
                  # Interesting only if the user got technician rights
		  if (member_check(0, $id, member_create_tracker_flag($tracker).'1'))
		    {
		      if ($previous) { $sql .= "OR "; }
		      $sql .= "$tracker.group_id='".$id."' ";
		      $previous = 1;
		    }
		}

		') ORDER BY '.$tracker.'.date DESC ';

	    }

          # Go to the next tracker if the user have no manager right on any
          # projects of this tracker
	  if (!$previous)
	    { continue; }

	  $result=db_query($sql);
	  $rows=db_numrows($result);

	  if ($result && $rows > 0)
	    {
	      $results = 1;
	      for ($j=0; $j<$rows; $j++)
		{
                  # Create item unique name
		  $thisitem = $tracker.'#'.db_result($result,$j,'bug_id');

		  # Items can be found in both cases (assigned on submission
		  # and assigned afterwards)
		  if (array_key_exists($thisitem, $item_date))
		    { continue; }

                  # Store data
		  $item_date[$thisitem] = db_result($result,$j,'date');
		  $item_priority[$thisitem] = db_result($result,$j,'priority');
		  $item_status[$thisitem] = db_result($result,$j,'resolution_id');
		  $item_summary[$thisitem] = db_result($result,$j,'summary');

	          # Associate with the relevant group
		  $thisgroup = db_result($result,$j,'unix_group_name');
		  if (array_key_exists($thisgroup, $items_per_groups))
		    { $items_per_groups[$thisgroup] = $items_per_groups[$thisgroup].','.$thisitem; }
		  else
		    { $items_per_groups[$thisgroup] = $thisitem; }
		  if (!array_key_exists($thisgroup, $groups_with_items))
		    { $groups_with_items[$thisgroup] = db_result($result,$j,'group_name'); }

		}
	    }
	}
    }

  # Break here if we have no results
  if (!$results)
    {
      print _("None found");
      return false;
    }

  # Go thru the group list and list items
  asort($groups_with_items);
  while (list($thisgroup,$thisgroupfullname) = each($groups_with_items))
    {
      $thisgroupid = group_getid($thisgroup);

      $theseitems = array();
      $theseitems = explode(",", $items_per_groups[$thisgroup]);

      # Put the content in an array we'll sort later according to the
      # date
      $thisgroupcontent = array();
      while (list(,$thisitem) = each($theseitems))
	{
          list($tracker, $item_id) = explode("#", $thisitem);
          $prefix = utils_get_tracker_prefix($tracker);
	  $icon = utils_get_tracker_icon($tracker);

          $dstatus = db_result(db_query("SELECT value FROM ".$tracker."_field_value WHERE bug_field_id='108' AND (group_id='".$thisgroupid."' OR group_id='100') AND value_id='".$item_status[$thisitem]."' ORDER BY bug_fv_id  DESC LIMIT 1"), 0, 'value');

	  $thisgroupcontent[$item_date[$thisitem].$thisitem] = '<div class="'.utils_get_priority_color($item_priority[$thisitem], $status).'">'.
	     '<a href="'.$GLOBALS['sys_home'].$tracker.'/?func=detailitem&amp;item_id='.$item_id.'">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.$icon.'.png" class="icon" alt="'.$tracker.'" />'.
	    $prefix .' #'.$item_id.'</a>'.
	    _(": ").'&nbsp;'.
	    '<a href="'.$GLOBALS['sys_home'].$tracker.'/?func=detailitem&amp;item_id='.$item_id.'">'.stripslashes($item_summary[$thisitem]).'</a>'.
	    '&nbsp;<font class="smaller">['.$dstatus.']</font></div>';

	}
      arsort($thisgroupcontent);
      $count = count($thisgroupcontent);

      list($hide_now,$count_diff,$hide_url) = my_hide_url("newlyassigned",$thisgroupid,$GLOBALS['hide_group_id'],$count,$GLOBALS['hide_newlyassigned'], '&nbsp;<b>'.$thisgroupfullname.'</b>');

      print '<div class="boxitem">'.$hide_url.' <font class="smaller">'.my_item_count($count,max(0, $count_diff)).'</font></div>';

      if (!$hide_now)
        {
          while (list(,$line) = each($thisgroupcontent))
           {
             print $line;
           }
        }
      print '<br />';

    }


}


?>
