#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Cvs.pm,v 1.2 2005/06/30 16:46:00 toddy Exp $
#
# Copyright 2003-2005 (c) Mathieu Roy <yeupou--gnu.org>
#                         Sylvain Beucler <beuc--beuc.net>
#                         Free Software Foundation, Inc.
# 
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

##
## Desc: any subs related to CVS.
## (Called Cvs instead of CVS to avoid confusion with /CVS)
## 
## Currently, the location of the locks is hardcoded, as the anoncvs
## group.
##

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(GetScriptCvsrootInit );
our $version = 1;


## Make a cvs area
sub CvsMakeArea {
    my ($name,$dir_cvs,$is_public) = @_;
    my $warning = "";

    # %PROJECT is not mandatory, but if it is missing, it may well be 
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific 
    # project.
    unless ($dir_cvs =~ s/\%PROJECT/$name/) {
	$warning = " (The string \%PROJECT was not found, there may be a group type serious misconfiguration)";
    }

    unless (-e $dir_cvs) {
	
	# build the directory
	my $mode = $is_public ? 2775 : 2770;
	system("mkdir", "-p", $dir_cvs);
	system("chmod", $mode, $dir_cvs);
	`cd $dir_cvs && CVSROOT=$dir_cvs cvs init`;

	# configure cvs
	open(FILE, "> $dir_cvs/CVSROOT/config");
	print FILE "# Set this to \"no\" if pserver shouldn't check system users/passwords
SystemAuth=no

# Put CVS lock files in this directory rather than directly in the repository.
LockDir=/var/lock/cvs/$name

# Set TopLevelAdmin to yes to create a CVS directory at the top
# level of the new working directory when using the cvs checkout
# command.
#TopLevelAdmin=no

# Set LogHistory to AMRT
# (log only modifications)
LogHistory=AMRT
"; 
	close(FILE);
	
	open(FILE, ">> $dir_cvs/CVSROOT/checkoutlist");
	print FILE "readers         Wont be able to control read-only access.
passwd          Wont be able to add pserver accounts.
";
	close(FILE);


	open(FILE, "> $dir_cvs/CVSROOT/passwd");
	print FILE "anoncvs:02oawyZdjhhpg
anonymous:02oawyZdjhhpg
";
	close(FILE);

	open(FILE, "> $dir_cvs/CVSROOT/readers");
	print FILE "anoncvs
anonymous
";
	close(FILE);

	open(FILE, "> $dir_cvs/CVSROOT/config");
	print FILE "# Set this to \"no\" if pserver shouldn't check system users/passwords
SystemAuth=no

# Put CVS lock files in this directory rather than directly in the repository.
LockDir=/var/lock/cvs/$name

# Set TopLevelAdmin to yes to create a CVS directory at the top
# level of the new working directory when using the cvs checkout
# command.
#TopLevelAdmin=no


# Set LogHistory to AMRT
# (log only modifications)
LogHistory=AMRT
"; 
	close(FILE);

	# cp the config file to be able to do ci on 'passwd' and 'readers'
	# without being prompted
	system("cp", "$dir_cvs/CVSROOT/config,v", "$dir_cvs/CVSROOT/passwd,v");
	system("cp", "$dir_cvs/CVSROOT/config,v", "$dir_cvs/CVSROOT/readers,v");

	# ci
	system("rcs", "-q", "-U", "$dir_cvs/CVSROOT/config", "$dir_cvs/CVSROOT/passwd", "$dir_cvs/CVSROOT/checkoutlist", "$dir_cvs/CVSROOT/readers");
	system("ci", "-q", "-m\"added by Savannah::Pm (anoncvs LockDir + SystemAuth)\"", "$dir_cvs/CVSROOT/config", "$dir_cvs/CVSROOT/passwd", "$dir_cvs/CVSROOT/checkoutlist", "$dir_cvs/CVSROOT/readers");
	system("co", "-q", "$dir_cvs/CVSROOT/config", "$dir_cvs/CVSROOT/passwd", "$dir_cvs/CVSROOT/checkoutlist", "$dir_cvs/CVSROOT/readers");


	system("touch", "$dir_cvs/CVSROOT/val-tags");
	system("mkdir", "$dir_cvs/$name");    # create the default module
	system("chmod", "2775", "$dir_cvs/$name");
	system("chgrp", "-R", $name, $dir_cvs);
	system("chown", "root.adm", "$dir_cvs/CVSROOT", "-R");
	                                     # make the CVSROOT ro for anybody
	                                     # doing otherwise is a major
	                                     # security hole.
	system("chgrp", $name, "$dir_cvs/CVSROOT/history"); 
                                             # history must be group writable
	system("chmod", "664", "$dir_cvs/CVSROOT/history");
	system("chgrp", $name, "$dir_cvs/CVSROOT/val-tags");
	system("chmod", "666", "$dir_cvs/CVSROOT/val-tags");
	                                     # val tag go world writable
	                                     # see task #147 @gna.org

	# build the locks
	system("mkdir", "-p", "/var/lock/cvs/$name");
	system("chmod", "777", "/var/lock/cvs/$name");
	system("chgrp", $name, "/var/lock/cvs/$name");

	return " ".$dir_cvs.$warning;
    } 
    return 0;
}


## Make a cvs area at gn!elsewhere.
## Ask yeupou@gna.org before modifying this function
sub CvsMakeAreaAttic {
    # Run the default sequence
    my $ret = CvsMakeArea(@_);
    
    
    if ($ret) {
	my ($name,$dir_cvs,$is_public) = @_;
	
	$dir_cvs =~ s/\%PROJECT/$name/;
	
	# hardcode cvsreport support
	open(FILE, "> $dir_cvs/CVSROOT/commitinfo");
	print FILE "ALL\tcvsreport -e 'mail text+html $name-commits'\n";
	close(FILE);
	system("rcs", "-q", "-U", "$dir_cvs/CVSROOT/commitinfo");
	system("ci", "-q", "-m\"added by Savannah::Pm (cvsreport support)\"", "$dir_cvs/CVSROOT/commitinfo");
	system("co", "-q", "$dir_cvs/CVSROOT/commitinfo");
	
	return " ".$dir_cvs;
    }

    return;
}

## Make a cvs area at Savannah
## This is temporary
sub CvsMakeAreaSavannah {
    my ($name,$dir_cvs,$is_public,$group_name) = @_;

    $group_name = (defined($group_name)) ? $group_name : "$name";

    my $replace_tag = "%PROJECT";
    
    # %PROJECT is not mandatory, but if it is missing, it may well be
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific
    # project.
    unless ($dir_cvs =~ s/\%PROJECT/$name/) {
	return 1;
    }

    my $root = "/savannah/cvsroot/$name";
    my $fullpath = "$root$dir_cvs";

    unless (-e "$root") {
	# print LOG strftime "[$script] %c ---- created cvsroot $name\n", localtime;
	
	mkdir ("$root");
	mkdir ("$root/bin");

	# hardcoded
	system (('/bin/cp', '/savannah/cvs-seed/cvs', 
		 "$root/bin"));
	
	mkdir ("$root/cvs-locks");
	chmod (02777, "$root/cvs-locks");
	
	mkdir ("$root/dev");
	system (('/bin/mknod',
		 "$root/dev/null", 'c', '1', '3'));
	
	mkdir ("$root/etc");
	# Create empty files so the anonymous checkout (and hence the
	# webpage activation) works straight away.
	open(PASSWD, "> $root/etc/passwd"); close(PASSWD);
	open(GROUP, "> $root/etc/group"); close(GROUP);

	mkdir ("$root/tmp");
	chmod (01777, "$root/tmp");
    }

    unless (-e $fullpath) {
	system (('/bin/mkdir', '-p', '-m', ($is_public ? '00755' : '00751'), $fullpath));

	chmod (01777, $fullpath) if ($is_public);
	chmod (00751, $fullpath) unless ($is_public);

	chdir ($fullpath);
	# hardcoded
	system (('/bin/tar', 'xfzp', '/savannah/cvs-seed/CVSROOT.tar.gz'));
	chdir ('/');
	system (('/bin/chgrp', $group_name,
		 "$fullpath/CVSROOT/history"));
	system (('/bin/chgrp', $group_name,
		 "$fullpath/CVSROOT/val-tags"));

	mkdir ("$fullpath/$name");
	chmod (02775, "$fullpath/$name");
	system (('/bin/chgrp', $group_name,
		 "$fullpath/$name"));
    }
}


## Make a webcvs area at Savannah
## This is temporary
sub WebCvsMakeAreaSavannahGNU {
    my ($name,$dir_cvs,$is_public,$group_name) = @_;

    my $replace_tag = "%PROJECT";
    
    unless ($dir_cvs =~ s/\%PROJECT/$name/) {
	return 1;
    }

    my $root = "/savannah/cvsroot/$name";
    my $fullpath = "$root$dir_cvs";

    unless (-e "$fullpath") {
        CvsMakeAreaSavannah(@_, "web$name");

	open(TEMPLOG, ">>/var/log/sv_curl_thingy.txt");
	print TEMPLOG localtime() . ": system (('/usr/bin/curl', 'http://www.gnu.org/new-savannah-project/new.py', '-s', '-F', 'type=non-gnu', '-F', 'project=$name'));\n";
	close(TEMPLOG);
        # perform an initial checkout so that updates happen:
        system (('/usr/bin/curl', 'http://www.gnu.org/new-savannah-project/new.py',
		 '-s', '-F', "type=gnu", '-F', "project=$name"));
    }
}


## Make a webcvs area at Savannah
## This is temporary
sub WebCvsMakeAreaSavannahNonGNU {
    my ($name,$dir_cvs,$is_public,$group_name) = @_;

    my $replace_tag = "%PROJECT";
    
    unless ($dir_cvs =~ s/\%PROJECT/$name/) {
	return 1;
    }

    my $root = "/savannah/cvsroot/$name";
    my $fullpath = "$root$dir_cvs";

    unless (-e "$fullpath") {    
        CvsMakeAreaSavannah(@_, "web$name");
    
        # perform an initial checkout so that updates happen:
	open(TEMPLOG, ">>/var/log/sv_curl_thingy.txt");
	print TEMPLOG localtime() . ": system (('/usr/bin/curl', 'http://www.gnu.org/new-savannah-project/new.py', '-s', '-F', 'type=non-gnu', '-F', 'project=$name'));\n";
	close(TEMPLOG);
        system (('/usr/bin/curl', 'http://www.gnu.org/new-savannah-project/new.py',
             '-s', '-F', "type=non-gnu", '-F', "project=$name"));
    }
}
