#!/bin/sh
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_nurse_ramfs.sh,v 1.4 2005/06/30 16:33:51 toddy Exp $ 
#
#
# Copyright 2003 (c) Loic Dachary <loic@gnu.org>
#
#
# 
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#

# ramfs is used for pserver anoncvs locks (see Admin Doc).
#
# Check that all directories in /mnt/ramfs match an existing pserver
# process and remove others. Since ramfs uses RAM, it is critical that
# it does not contain trash.


set -e

cd /tmpcvs

ls | grep '^cvs-serv' | while read dir
do
  pid=`expr $dir : 'cvs-serv\([0-9]*\)'`
  if [ -d /proc/$pid ] ; then
      # yeupou@gnu.org 2003-11-22 : print ok only if an argument is
      # passed in the command line, to avoid getting spammed when
      # putting that script in /etc/cron.hourly with a symlink
      if [ $1 ] ; then echo "# $dir ok" ; fi
  else
      # zerodeux@gnu.org 2003-11-28 : same reasoning as above, given
      # that removing such folders is one very purpose of this script.
      if [ $1 ] ; then echo "# $dir obsolete, removing"; fi
      rm -fr $dir
  fi
done

ls | grep -v '^cvs-serv' | xargs --no-run-if-empty rm -fr 
