<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sessions.php,v 1.5 2005/07/03 13:33:58 toddy Exp $
#
#  Copyright 2004      (c) Mathieu Roy <yeupou--at--gnu.org>
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


require "../include/pre.php";

# Check if the user is logged in.
session_require(array('isloggedin'=>'1'));


########################################################################
# Update the database
if ($func == "del")
{
  if ($dsession_hash && $dip_addr && $dtime)
    {

      $dsession_hash = substr($dsession_hash, 0, 8)."%";
      $sql = "DELETE FROM session WHERE session_hash like '$dsession_hash' "
	 . " AND ip_addr='$dip_addr'"
	 . " AND time='$dtime'"
	 . " AND user_id='".user_getid()."'"
	 . " LIMIT 1";
      if (db_query($sql))
	{ fb(_("Old session deleted")); }
      else
	{ fb(_("Failed to delete old session"), 1); }
    }
  else
    {
      fb(_("Parameters missing, update canceled"), 1);
    }
}



########################################################################
# Actually prints the HTML page

site_user_header(array('title'=>_("Manage sessions"),
		       'toptab'=>'account'));


$res = db_query("SELECT session_hash,ip_addr,time FROM session WHERE "
		 . "user_id = '".user_getid()."' "
		 . "ORDER BY time DESC");

if (db_numrows($res) < 1)
{
  exit_error(_("No session found."));
}

print $HTML->box_top(_("Opened Sessions"));

while ($row = db_fetch_array($res))
{
  $i++;
  if ($i > 1)
    { print $HTML->box_nextitem(utils_get_alt_row_color($i)); }
  $dsession_hash = substr($row['session_hash'], 0, 8)."...";

  # Do not incitate users to kill their own session
  print '<span class="trash">';
  if ($_COOKIE['session_hash'] != $row['session_hash'])
    {
      print utils_link($PHP_SELF.'?func=del&amp;dsession_hash='.$dsession_hash.'&amp;dip_addr='.$row['ip_addr'].'&amp;dtime='.$row['time'],
		       '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Kill this session").'" />');
    }
  else
    { print _("Current session"); }
  print '</span>';

  # I18N
  # The variables are: session identifier, time, remote host
  print sprintf(_("Session %s opened on %s from %s"), $dsession_hash, format_date($sys_datefmt, $row['time']), gethostbyaddr($row['ip_addr']))."<br />&nbsp;";

}

print $HTML->box_bottom();


site_user_footer(array());


?>
